/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build;

import com.atlassian.bamboo.clover.build.AbstractGrailsCloverIntegrator;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.reporters.html.source.SourceListener;
import com.atlassian.clover.reporters.html.source.groovy.GroovySourceListener;
import com.atlassian.clover.reporters.html.source.groovy.GroovySourceTraverser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class GrailsCloverBuildConfigIntegrator
extends AbstractGrailsCloverIntegrator {
    public static final String CLOVER_DEPENDENCIES = "\n    // ADDED BY CLOVER\n    repositories {\n        mavenRepo \"http://repo.grails.org/grails/plugins\"\n        mavenRepo \"https://maven.atlassian.com/repository/public\"\n        mavenRepo \"https://maven.atlassian.com/content/repositories/atlassian-public-snapshot\"\n        mavenRepo \"https://maven.atlassian.com/content/repositories/atlassian-central-snapshot/\"\n    }\n    plugins {\n        compile \"${CLOVER_FOR_GRAILS}\"\n    }\n    dependencies {\n        compile \"${CLOVER_CORE}\"\n    }\n    // ADDED BY CLOVER\n";

    public GrailsCloverBuildConfigIntegrator(@NotNull String pluginVersion) {
        super(pluginVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean integrate(final @NotNull File buildConfigFile) throws Exception {
        FullFileInfo fakeFileInfo = new FullFileInfo(null, buildConfigFile, "UTF-8", 0, 0, 0, 0L, 0L, 0L, 0L){

            public Reader getSourceReader() throws FileNotFoundException, UnsupportedEncodingException {
                return GrailsCloverBuildConfigIntegrator.this.getUTF8Reader(buildConfigFile);
            }
        };
        Reader sourceReader = null;
        try {
            sourceReader = fakeFileInfo.getSourceReader();
            GroovySourceTransformer transformer = new GroovySourceTransformer();
            new GroovySourceTraverser().traverse(fakeFileInfo.getSourceReader(), fakeFileInfo, (SourceListener)transformer);
            if (!transformer.isPomTrueFound) {
                FileUtils.writeStringToFile((File)buildConfigFile, (String)transformer.getRewrittenContent(), (Charset)StandardCharsets.UTF_8);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)sourceReader);
        }
        return false;
    }

    @Override
    public boolean integrate(@NotNull InputStream input, @NotNull OutputStream output) throws Exception {
        return false;
    }

    @NotNull
    protected String getCloverForGrailsArtifact() {
        return "org.grails.plugins:clover:" + this.getPluginVersion();
    }

    @NotNull
    protected String getCloverCoreArtifact() {
        return this.getCloverCoreGroupId() + ":" + this.getCloverCoreArtifactId() + ":" + this.getPluginVersion();
    }

    @NotNull
    protected Reader getUTF8Reader(@NotNull File file) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, decoder);
        return new BufferedReader(isr);
    }

    class GroovySourceTransformer
    implements GroovySourceListener {
        private static final String DOT = ".";
        private static final String BLOCK_OPEN = "{";
        private static final String BLOCK_CLOSE = "}";
        private static final String GRAILS_PROJECT_DEPENDENCY_RESOLUTION = "grails.project.dependency.resolution";
        private static final String NONE = "";
        private static final String MODIFIED_BY_AUTOMATIC_CLOVER_INTEGRATION = "// MODIFIED BY AUTOMATIC CLOVER INTEGRATION";
        @NotNull
        private LinkedList<String> closureStack = new LinkedList();
        @NotNull
        private String currentIdentifier = "";
        private boolean isPomTrueFound = false;
        private boolean isModifiedMarkerFound = false;
        private boolean isCloverInjected = false;
        @NotNull
        protected final StringBuilder out = new StringBuilder();

        GroovySourceTransformer() {
        }

        @NotNull
        public String getRewrittenContent() {
            return this.out.toString();
        }

        protected String getCombinedClosureStack() {
            StringBuilder combined = new StringBuilder();
            for (String closure : this.closureStack) {
                if (combined.length() > 0) {
                    combined.append('.');
                }
                combined.append(closure);
            }
            return combined.toString();
        }

        public void onRegexp(String s) {
            this.currentIdentifier = NONE;
            this.out.append(s);
        }

        public void onPackageSegment(String s, String s2) {
            this.currentIdentifier = NONE;
            this.out.append(s2);
        }

        public void onImportSegment(String s, String s2) {
            this.currentIdentifier = NONE;
            this.out.append(s2);
        }

        public void onImport(String s) {
            this.currentIdentifier = NONE;
        }

        public void onIdentifier(String s) {
            this.currentIdentifier = this.currentIdentifier + s;
            this.out.append(s);
        }

        public void onStringLiteral(String s) {
            if (("'true'".equals(s) || "\"true\"".equals(s)) && "pom".equals(this.currentIdentifier)) {
                this.isPomTrueFound = true;
            }
            this.currentIdentifier = NONE;
            this.out.append(s);
        }

        public void onKeyword(String s) {
            if ("true".equals(s) && "pom".equals(this.currentIdentifier)) {
                this.isPomTrueFound = true;
            }
            this.currentIdentifier = NONE;
            this.out.append(s);
        }

        public void onCommentChunk(String s) {
            if (s.contains(MODIFIED_BY_AUTOMATIC_CLOVER_INTEGRATION)) {
                this.isModifiedMarkerFound = true;
            }
            this.out.append(s);
        }

        public void onJavadocTag(String s) {
            this.out.append(s);
        }

        public void onStartDocument() {
        }

        public void onEndDocument() {
            if (!(this.isPomTrueFound || this.isModifiedMarkerFound || this.isCloverInjected)) {
                this.out.append("\ngrails.project.dependency.resolution = {");
                this.appendCloverDependencies();
                this.out.append("}\n");
            }
            if (!this.isModifiedMarkerFound) {
                this.out.append("\ngrails.project.fork = false // ADDED BY CLOVER\n");
            }
            if (this.isCloverInjected) {
                this.out.insert(0, "// MODIFIED BY AUTOMATIC CLOVER INTEGRATION\n");
            }
        }

        public void onNewLine() {
            this.out.append("\n");
        }

        public void onChunk(String s) {
            if (DOT.equals(s)) {
                this.currentIdentifier = this.currentIdentifier + s;
            } else if (BLOCK_OPEN.equals(s)) {
                this.closureStack.add(this.currentIdentifier);
                this.currentIdentifier = NONE;
            } else if (BLOCK_CLOSE.equals(s)) {
                if (this.closureStack.size() > 0 && this.getCombinedClosureStack().equals(GRAILS_PROJECT_DEPENDENCY_RESOLUTION) && !this.isPomTrueFound && !this.isModifiedMarkerFound) {
                    this.appendCloverDependencies();
                }
                this.closureStack.removeLast();
                this.currentIdentifier = NONE;
            } else if (!"=".equals(s) && !s.trim().isEmpty()) {
                this.currentIdentifier = NONE;
            }
            this.out.append(s);
        }

        private void appendCloverDependencies() {
            String cloverDependencies = GrailsCloverBuildConfigIntegrator.CLOVER_DEPENDENCIES.replace("${CLOVER_FOR_GRAILS}", GrailsCloverBuildConfigIntegrator.this.getCloverForGrailsArtifact()).replace("${CLOVER_CORE}", GrailsCloverBuildConfigIntegrator.this.getCloverCoreArtifact());
            this.out.append(cloverDependencies);
            this.isCloverInjected = true;
        }
    }
}

