/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.chains.plugins.PrePostTaskActions;
import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.clover.build.GrailsCloverBuildConfigIntegrator;
import com.atlassian.bamboo.clover.build.GrailsCloverPomIntegrator;
import com.atlassian.bamboo.plugins.grails.GrailsBuildTask;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.InternalTaskType;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.clover.versions.LibraryVersion;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloverGrailsBuildTaskActions
implements PrePostTaskActions {
    private static final Logger log = Logger.getLogger(CloverGrailsBuildTaskActions.class);
    private BuildLogger buildLogger;
    private static final LibraryVersion MIN_GRAILS_VERSION_SUPPORTED = new LibraryVersion("2.0.0");
    private static final LibraryVersion MAX_GRAILS_VERSION_SUPPORTED = new LibraryVersion("3.0.0");
    private static final String GRAILS_CLOVER_PLUGIN_VERSION_VARIABLE = "grails.cloverPluginVersion";
    static final String GRAILS_CLOVER_PLUGIN_DEFAULT_VERSION = "4.1.2";
    static final String GRAILS_OPENCLOVER_PLUGIN_DEFAULT_VERSION = "4.3.1";
    Map<File, File> filesToRevert = new HashMap<File, File>();
    boolean minimalGrailsVersionSupported = true;

    public void executeBefore(@NotNull InternalTaskType task, @NotNull CommonTaskContext context) throws Exception {
        this.buildLogger = context.getBuildLogger();
        log.debug((Object)("CloverGrailsBuildActions.executeBefore() called.  Task is " + task.getClass().getName() + " Root dir is " + context.getRootDirectory() + " Working dir is " + context.getWorkingDirectory()));
        TaskContext buildTaskContext = (TaskContext)Narrow.to((Object)context, TaskContext.class);
        if (buildTaskContext == null) {
            log.warn((Object)(this.getClass().getSimpleName() + " was called for a non-build task. Exiting."));
            return;
        }
        if (!CloverPluginHelper.isAutoIntegrate(buildTaskContext.getBuildContext().getBuildDefinition().getCustomConfiguration())) {
            return;
        }
        buildTaskContext.getBuildContext().getBuildDefinition().getCustomConfiguration().put("custom.grails.runClean", "true");
        if (!this.isRequiredGrailsSupported(context)) {
            this.minimalGrailsVersionSupported = false;
            this.buildLogger.addErrorLogEntry(String.format("CLOVER: Project in %s  is not for Grails [%s, %s). Automatic Clover integration can not be performed. You need to integrate Clover manually.", context.getWorkingDirectory(), MIN_GRAILS_VERSION_SUPPORTED, MAX_GRAILS_VERSION_SUPPORTED));
            return;
        }
        File buildConfigFile = this.getBuildConfigFile(context);
        if (buildConfigFile != null) {
            this.backupFile(buildConfigFile);
            boolean wasIntegrated = this.addCloverToBuildConfigFile(context, buildConfigFile);
            if (!wasIntegrated) {
                File pomFile = this.getPomFile(context);
                if (pomFile != null) {
                    this.backupFile(pomFile);
                    wasIntegrated = this.addCloverToPomFile(context, pomFile);
                    if (!wasIntegrated) {
                        this.buildLogger.addErrorLogEntry("CLOVER: Failed to perform automatic integration in neither BuildConfig.groovy nor pom.xml. Do you have manual integration configured?");
                    }
                } else {
                    this.buildLogger.addErrorLogEntry("CLOVER: Failed to locate pom.xml file. Automatic Clover integration will not be performed.");
                }
            }
        } else {
            this.buildLogger.addErrorLogEntry("CLOVER: Failed to locate BuildConfig.groovy file. Automatic Clover integration will not be performed.");
        }
    }

    public TaskResult executeAfter(@NotNull InternalTaskType task, @Nullable TaskResult taskResult) {
        log.debug((Object)("CloverGrailsBuildActions.executeAfter() called.  Task is " + task.getClass().getName() + " Task state is " + (taskResult != null ? taskResult.getTaskState() : "<null>") + " Result data is " + (taskResult != null ? taskResult.getResultData() : "<null>")));
        this.restoreFilesFromBackup();
        if (taskResult != null && !this.minimalGrailsVersionSupported) {
            return TaskResultBuilder.copyWithNewState((TaskResult)taskResult, (TaskState)TaskState.FAILED);
        }
        return taskResult;
    }

    protected boolean isRequiredGrailsSupported(@NotNull CommonTaskContext context) {
        String grailsVersionStr = GrailsBuildTask.getRequiredGrailsVersion((CommonTaskContext)context);
        if (!StringUtils.isEmpty((CharSequence)grailsVersionStr)) {
            LibraryVersion grailsVersionRequired = new LibraryVersion(grailsVersionStr);
            return grailsVersionRequired.compareTo(MIN_GRAILS_VERSION_SUPPORTED) >= 0 && grailsVersionRequired.compareTo(MAX_GRAILS_VERSION_SUPPORTED) < 0;
        }
        return false;
    }

    @NotNull
    private String getGrailsCloverPluginVersion(@NotNull CommonTaskContext context) {
        String customVersion = (String)context.getConfigurationMap().get((Object)GRAILS_CLOVER_PLUGIN_VERSION_VARIABLE);
        if (customVersion != null) {
            return customVersion;
        }
        TaskContext buildTaskContext = (TaskContext)Narrow.to((Object)context, TaskContext.class);
        Map customConfiguration = buildTaskContext == null ? null : buildTaskContext.getBuildContext().getBuildDefinition().getCustomConfiguration();
        return CloverPluginHelper.isIntegrateUsingAtlassianClover(customConfiguration) ? GRAILS_CLOVER_PLUGIN_DEFAULT_VERSION : GRAILS_OPENCLOVER_PLUGIN_DEFAULT_VERSION;
    }

    @Nullable
    protected File getBuildConfigFile(@NotNull CommonTaskContext context) {
        File buildConfigFile = new File(context.getWorkingDirectory(), "grails-app" + File.separator + "conf" + File.separator + "BuildConfig.groovy");
        return buildConfigFile.isFile() ? buildConfigFile : null;
    }

    @Nullable
    protected File getPomFile(@NotNull CommonTaskContext context) {
        File pomFile = new File(context.getWorkingDirectory(), "pom.xml");
        return pomFile.isFile() ? pomFile : null;
    }

    protected boolean addCloverToBuildConfigFile(@NotNull CommonTaskContext context, @NotNull File buildConfigFile) {
        this.buildLogger.addBuildLogEntry("CLOVER: Integrating Clover using " + buildConfigFile);
        try {
            GrailsCloverBuildConfigIntegrator configIntegrator = new GrailsCloverBuildConfigIntegrator(this.getGrailsCloverPluginVersion(context));
            return configIntegrator.integrate(buildConfigFile);
        }
        catch (Exception e) {
            this.buildLogger.addErrorLogEntry("CLOVER: Failed to parse " + buildConfigFile, (Throwable)e);
            return false;
        }
    }

    protected boolean addCloverToPomFile(@NotNull CommonTaskContext context, @NotNull File pomFile) {
        this.buildLogger.addBuildLogEntry("CLOVER: Integrating Clover using " + pomFile);
        try {
            GrailsCloverPomIntegrator pomIntegrator = new GrailsCloverPomIntegrator(this.getGrailsCloverPluginVersion(context));
            return pomIntegrator.integrate(pomFile);
        }
        catch (Exception e) {
            this.buildLogger.addErrorLogEntry("CLOVER: Failed to parse " + pomFile, (Throwable)e);
            return false;
        }
    }

    private void backupFile(@NotNull File original) throws IOException {
        File backupFile = File.createTempFile(original.getName(), ".bak");
        FileUtils.copyFile((File)original, (File)backupFile);
        this.filesToRevert.put(original, backupFile);
    }

    private void restoreFilesFromBackup() {
        for (Map.Entry<File, File> fileToRevert : this.filesToRevert.entrySet()) {
            File original = fileToRevert.getKey();
            File backup = fileToRevert.getValue();
            try {
                this.buildLogger.addBuildLogEntry("CLOVER: Restoring original content of " + original);
                FileUtils.copyFile((File)backup, (File)original);
                backup.delete();
            }
            catch (IOException ex) {
                this.buildLogger.addErrorLogEntry("CLOVER: Failed to restore the original file " + original + " from a backup file " + backup + ". You may need to revert changes made.", (Throwable)ex);
            }
        }
    }
}

