/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build;

import com.atlassian.clover.versions.LibraryVersion;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGrailsCloverIntegrator {
    static final String CLOVER_GRAILS_GROUPID = "org.grails.plugins";
    static final String CLOVER_GRAILS_ARTIFACTID = "clover";
    private static final String CLOVER_CORE_ARTIFACTID = "clover";
    private static final String CLOVER3_CORE_GROUPID = "com.cenqua.clover";
    private static final String CLOVER4_CORE_GROUPID = "com.atlassian.clover";
    private static final String OPENCLOVER_CORE_GROUPID = "org.openclover";
    private static final String CLOVER4_MIN_VER = "4.0.0";
    private static final String OPENCLOVER_MIN_VER = "4.2.0";
    private static final LibraryVersion LIBRARY_CLOVER4_MIN_VER = new LibraryVersion("4.0.0");
    private static final LibraryVersion LIBRARY_OPENCLOVER_MIN_VER = new LibraryVersion("4.2.0");
    @NotNull
    private final String pluginVersion;

    AbstractGrailsCloverIntegrator(@NotNull String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public abstract boolean integrate(@NotNull File var1) throws Exception;

    public abstract boolean integrate(@NotNull InputStream var1, @NotNull OutputStream var2) throws Exception;

    @NotNull
    String getPluginVersion() {
        return this.pluginVersion;
    }

    @NotNull
    String getCloverCoreGroupId() {
        LibraryVersion libraryVersion = new LibraryVersion(this.getPluginVersion());
        if (libraryVersion.compareTo(LIBRARY_OPENCLOVER_MIN_VER) >= 0) {
            return OPENCLOVER_CORE_GROUPID;
        }
        if (libraryVersion.compareTo(LIBRARY_CLOVER4_MIN_VER) >= 0) {
            return CLOVER4_CORE_GROUPID;
        }
        return CLOVER3_CORE_GROUPID;
    }

    @NotNull
    String getCloverCoreArtifactId() {
        return "clover";
    }
}

