/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.analytics;

import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.clover.analytics.BuildCodeQualitySettingsAnalyticsEvent;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.v2.build.events.BuildQueuedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class BuildQueuedEventCodeQualityAnalytics {
    private final EventPublisher eventPublisher;

    @Inject
    public BuildQueuedEventCodeQualityAnalytics(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onBuildQueuedEvent(@NotNull BuildQueuedEvent event) {
        Map customConfiguration = event.getContext().getBuildDefinition().getCustomConfiguration();
        List taskDefinitions = event.getContext().getBuildDefinition().getTaskDefinitions();
        long antTasksCount = taskDefinitions.stream().filter(BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.ant:task.builder.ant")).count();
        long mavenTasksCount = taskDefinitions.stream().filter(BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.maven:task.builder.maven").or(BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.maven:task.builder.mvn2")).or(BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.maven:task.builder.mvn3"))).count();
        long grailsTasksCount = taskDefinitions.stream().filter(BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins:grailsBuilderTaskType")).count();
        this.eventPublisher.publish((Object)new BuildCodeQualitySettingsAnalyticsEvent(CloverPluginHelper.isCloverOn(customConfiguration), CloverPluginHelper.isAutoIntegrate(customConfiguration), CloverPluginHelper.isIntegrateUsingAtlassianClover(customConfiguration), CloverPluginHelper.isHistorical(customConfiguration), CloverPluginHelper.isJson(customConfiguration), antTasksCount, mavenTasksCount, grailsTasksCount));
    }
}

