/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.license.LicenseManagerFactory;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloverPluginHelper {
    public static final String BANDANA_KEY_GLOBAL_LICENSE_KEY = "com.atlassian.bamboo.plugin.clover:globalLicenseKey";
    public static final Predicate<ImmutablePlan> isCloverEnabledForPlan = plan -> plan != null && CloverPluginHelper.isCloverOn(plan.getBuildDefinition().getCustomConfiguration());

    public static boolean isAutoIntegrate(@Nullable BuildConfiguration config) {
        return CloverPluginHelper.isCloverOn(config) && "auto".equals(config.getString("custom.clover.integration"));
    }

    public static boolean isAutoIntegrate(@Nullable Map<String, String> config) {
        return CloverPluginHelper.isCloverOn(config) && "auto".equals(config.get("custom.clover.integration"));
    }

    public static boolean isCloverOn(@Nullable BuildConfiguration config) {
        return config != null && config.getBoolean("custom.clover.exists");
    }

    public static boolean isCloverOn(@Nullable Map<String, String> config) {
        return config != null && Boolean.parseBoolean(config.get("custom.clover.exists"));
    }

    public static boolean isIntegrateUsingAtlassianClover(TaskContext taskContext) {
        return CloverPluginHelper.isIntegrateUsingAtlassianClover(taskContext.getBuildContext().getBuildDefinition().getCustomConfiguration());
    }

    public static boolean isIntegrateUsingAtlassianClover(@Nullable Map<String, String> config) {
        return CloverPluginHelper.isAutoIntegrate(config) && "atlassianclover".equals(config.get("custom.clover.tool"));
    }

    public static boolean isHistorical(@Nullable Map<String, String> config) {
        return CloverPluginHelper.isAutoIntegrate(config) && Boolean.parseBoolean(config.get("custom.clover.historical"));
    }

    public static boolean isJson(@Nullable Map<String, String> config) {
        return CloverPluginHelper.isAutoIntegrate(config) && Boolean.parseBoolean(config.get("custom.clover.json"));
    }

    public static boolean hasGlobalLicenseKey(@NotNull BandanaManager bandanaManager) {
        return StringUtils.isNotEmpty((CharSequence)((String)bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_GLOBAL_LICENSE_KEY)));
    }

    public static boolean hasValidGlobalLicenseKey(@NotNull BandanaManager bandanaManager) {
        return CloverPluginHelper.isValidLicenseKey(CloverPluginHelper.getGlobalLicenseKey(bandanaManager));
    }

    public static boolean isValidLicenseKey(String licenseKey) {
        if (StringUtils.isNotEmpty((CharSequence)licenseKey)) {
            ProductLicense productLicense = CloverPluginHelper.getCloverProductLicense(licenseKey);
            return productLicense != null;
        }
        return false;
    }

    @Nullable
    public static ProductLicense getCloverProductLicense(String licenseKey) {
        try {
            AtlassianLicense atlassianLicense = LicenseManagerFactory.get().getLicense(licenseKey);
            return atlassianLicense.getProductLicense(Product.CLOVER);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static String getGlobalLicenseKey(@NotNull BandanaManager bandanaManager) {
        return StringUtils.defaultString((String)((String)bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_GLOBAL_LICENSE_KEY)));
    }

    public static void setGlobalLicenseKey(@NotNull BandanaManager bandanaManager, @NotNull String globalLicenseKey) {
        bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_GLOBAL_LICENSE_KEY, (Object)globalLicenseKey);
    }
}

