[#-- @ftlvariable name="" type="com.atlassian.bamboo.build.coverage.ViewCloverCoverageSummary" --]
[#-- @ftlvariable name="action" type="com.atlassian.bamboo.build.coverage.ViewCloverCoverageSummary" --]
[#-- @ftlvariable name="numberUtils" type="com.atlassian.bamboo.util.NumberUtils" --]

<html>
<head>
[@ui.header pageKey='Coverage Summary' object=immutableBuild.name title=true /]
    <meta name="tab" content="clover"/>
</head>

<body>
[@ui.header pageKey='Code Coverage Summary' /]
[#if reportLinker??]
    [#assign latestBuild = reportLinker.buildResultsSummary /]

    [#if (latestBuild.customBuildData.CLOVER_BUILD_COVERAGE)?has_content]
        [#assign coverageNumber = numberUtils.unlocalizedStringToDouble(latestBuild.customBuildData.CLOVER_BUILD_COVERAGE) /]
    <div id="cloverSuccessRate" class="successRatePercentage">
        <p>
            <span>${coverageNumber?round}%</span>
            Latest coverage
        </p>
    </div>
    [/#if]

<p id="clover-info">
    [#if reportLinker.cloverReportUrl??]
        <a href="${reportLinker.cloverReportUrl}">[#rt]
            View latest Clover HTML report[#t]
        </a>[#lt]
    [#else]
        <a href="${req.contextPath}/build/result/viewCloverResult.action?buildKey=${latestBuild.planKey}&amp;buildNumber=${latestBuild.buildNumber}">[#rt]
            View latest Clover information[#t]
        </a>[#lt]
    [/#if]
    from <a href="${req.contextPath}/browse/${latestBuild.planResultKey}">#${latestBuild.buildNumber}</a>
    (${latestBuild.buildCompletedDate?datetime?string("hh:mm a, EEE, d MMM yyyy")})
</p>

    [#if (coverageNumber)?has_content]
    <div title="${100 - coverageNumber}% Not Covered" class="barNegative">
        <div title="${coverageNumber}% Covered" class="barPositive" style="width: ${coverageNumber}%;"></div>
    </div>
    [/#if]
[#else]
<p>No Clover coverage data found.</p>
[/#if]

<div id="clover-graphs">
[@ww.action name="viewCloverCoverageSummary" namespace="/build" executeResult="true" /]
    [@ww.action name="viewCloverLinesOfCodeSummary" namespace="/build" executeResult="true" /]
</div>
</body>
</html>