[#-- @ftlvariable name="" type="com.atlassian.bamboo.build.coverage.ViewCloverBuildResults" --]
[#-- @ftlvariable name="action" type="com.atlassian.bamboo.build.coverage.ViewCloverBuildResults" --]
[#-- @ftlvariable name="numberUtils" type="com.atlassian.bamboo.util.NumberUtils" --]
<html>
<head>
	[@ui.header page='Coverage' object='${immutablePlan.name} ${resultsSummary.buildNumber}' title=true /]
    <meta name="tab" content="clover"/>
    ${webResourceManager.requireResource("com.atlassian.bamboo.plugin.clover:webCss")}
</head>

<body>

    <p class="headingInfo">
        <a href="${req.contextPath}/build/viewCloverSummary.action?buildKey=${immutableBuild.key}">View history</a>
    </p>
    [@ui.header page='Clover Code Coverage' cssClass="headingClover"/]

[#if (reportLinker.cloverReportUrl)??]
    [#include "cloverReportHtml.ftl" /]
[#else]

[#macro cloverResultDivide dividendAsString divisorAsString ]
    [#assign dividend = numberUtils.unlocalizedStringToDouble(dividendAsString) /]
    [#assign divisor = numberUtils.unlocalizedStringToDouble(divisorAsString) /]
    [#compress ]
        [#if divisor == 0 ]
            -
        [#else ]
            ${(dividend / divisor)?string('0.0%')}
        [/#if]
    [/#compress]
[/#macro]


[#assign customDataMap=buildResultsSummary.customBuildData/]

[#if customDataMap.CLOVER_BUILD_COVERAGE??]

    [@ui.bambooInfoDisplay titleKey='clover.testCoverage.title' float=true]

        [@ww.label id='buildCoverage' labelKey='clover.testCoverage.build' descriptionKey='clover.testCoverage.build.description']
            [@ww.param name='value']${(numberUtils.unlocalizedStringToDouble(customDataMap.CLOVER_BUILD_COVERAGE!) / 100)?string('0.0%')}
            [#if customDataMap.CLOVER_COVERAGE_DELTA?? ]
                (${numberUtils.unlocalizedStringToDouble(customDataMap.CLOVER_COVERAGE_DELTA)?string('0.0%')})
            [/#if]
            [/@ww.param]
        [/@ww.label]

        [#if customDataMap.CLOVER_STATEMENTS?? && customDataMap.CLOVER_COVERED_STATEMENTS??]
            [@ww.label labelKey='clover.testCoverage.statement' descriptionKey='clover.testCoverage.statement.description']
                [@ww.param name='value'][@cloverResultDivide customDataMap.CLOVER_COVERED_STATEMENTS customDataMap.CLOVER_STATEMENTS /][/@ww.param]
            [/@ww.label]
        [/#if]

        [#if customDataMap.CLOVER_METHODS?? && customDataMap.CLOVER_COVERED_METHODS??]
            [@ww.label labelKey='clover.testCoverage.methods' descriptionKey='clover.testCoverage.methods.description']
                [@ww.param name='value'][@cloverResultDivide customDataMap.CLOVER_COVERED_METHODS customDataMap.CLOVER_METHODS /][/@ww.param]
            [/@ww.label]
        [/#if]

        [#if customDataMap.CLOVER_CONDITIONALS?? && customDataMap.CLOVER_COVERED_CONDITIONALS??]
            [@ww.label labelKey='clover.testCoverage.conditionals' descriptionKey='clover.testCoverage.conditionals.description']
                [@ww.param name='value'][@cloverResultDivide customDataMap.CLOVER_COVERED_CONDITIONALS customDataMap.CLOVER_CONDITIONALS /][/@ww.param]
            [/@ww.label]
        [/#if]

    [/@ui.bambooInfoDisplay]


    [@ui.bambooInfoDisplay titleKey='clover.buildStatistics.title' float=true]

        [@ww.label labelKey='clover.buildStatistics.loc' descriptionKey='clover.buildStatistics.loc.description'
            value='${customDataMap.CLOVER_LOC!}' /]
        [@ww.label labelKey='clover.buildStatistics.ncloc' descriptionKey='clover.buildStatistics.ncloc.description'
            value='${customDataMap.CLOVER_NCLOC!}' /]
        [@ww.label labelKey='clover.buildStatistics.files'
            value='${customDataMap.CLOVER_FILES!}' /]
        [@ww.label labelKey='clover.buildStatistics.methods'
            value='${customDataMap.CLOVER_METHODS!}' /]
        [@ww.label labelKey='clover.buildStatistics.classes'
            value='${customDataMap.CLOVER_CLASSES!}' /]
        [@ww.label labelKey='clover.buildStatistics.packages'
            value='${customDataMap.CLOVER_PACKAGES!}' /]

    [/@ui.bambooInfoDisplay]
[#else]
    <p>[@ww.text name='clover.noCoverageData'/]</p>
[/#if]

[/#if]

</body>
</html>