[#-- @ftlvariable name="action" type="com.atlassian.bamboo.ww2.actions.admin.ConfigureCloverPlugin" --]
[#-- @ftlvariable name="" type="com.atlassian.bamboo.ww2.actions.admin.ConfigureCloverPlugin" --]

<html>
<head>
[@ui.header pageKey="clover.plugin.configure.title" title=true /]
    <meta name="decorator" content="adminpage">
</head>
<body>
[@ui.header pageKey="clover.plugin.configure.title" /]

[#assign licensePageInfo]
    [#if !license??]
        [@ui.messageBox type="warning" titleKey='clover.license.error.missing'/]
    [#else]
        [#if featureManager.onDemandInstance]
            [@ui.messageBox type="warning" titleKey='clover.plugin.configure.globalLicenseKey.onDemand'/]
        [/#if]
        [#if license.evaluation]
            [#if license.expired]
                [@ww.text name='clover.license.expiry.expired.message' id='cloverLicenseExpiryExpiredMessage']
                    [@ww.param][@ww.date name='license.expiryDate' format='dd MMMM yyyy'/][/@ww.param]
                [/@ww.text]
                [@ui.messageBox type="warning" title=cloverLicenseExpiryExpiredMessage /]
            [#else]
                [@ww.text name='license.expiry.expiring' id='licenseExpiryExpiring']
                    [@ww.param][@ww.date name='license.expiryDate' format='dd MMMM yyyy'/][/@ww.param]
                [/@ww.text]
                [@ui.messageBox type="info" title=licenseExpiryExpiring]
                    [@ww.text name='license.contact']
                        [@ww.param][@ww.text name='license.contact.company' /][/@ww.param]
                    [/@ww.text]
                [/@ui.messageBox]
            [/#if]
        [#else]
            [#if license.maintenanceExpired]
                [@ww.text name='license.support.ended.message' id='licenseSupportEndedMessage']
                    [@ww.param][@ww.date name='license.maintenanceExpiryDate' format='dd MMMM yyyy'/][/@ww.param]
                    [@ww.param][@ww.text name='license.contact.company' /][/@ww.param]
                [/@ww.text]
                [@ui.messageBox type="warning" title=licenseSupportEndedMessage /]
            [#else]
            <p>[@ww.text name='clover.plugin.configure.form.title.description' /]</p>
            [/#if]
        [/#if]
    [/#if]
[/#assign]

[@ui.bambooPanel titleKey='clover.plugin.configure.form.title']
${licensePageInfo}
    [#if license??]
        [@ww.label labelKey='license.organisation' name='license.organisation.name' /]
        [@ww.label labelKey='license.datePurchased' ]
            [@ww.param name='value'][@ww.date name='license.purchaseDate' format='dd MMMM yyyy'/][/@ww.param]
        [/@ww.label]
        [@ww.label labelKey='license.type' name='license.description' /]

        [#if license.maintenanceExpired]
            [@ww.label labelKey='license.support.ended' ]
                [@ww.param name='value'][@ww.date name='license.maintenanceExpiryDate' format='dd MMMM yyyy'/][/@ww.param]
            [/@ww.label]
        [#else]
            [@ww.label labelKey='license.support' ]
                [@ww.param name='value'][@ww.date name='license.maintenanceExpiryDate' format='dd MMMM yyyy'/][/@ww.param]
            [/@ww.label]
        [/#if]
    [/#if]
[/@ui.bambooPanel]

[@ww.form id='configureCloverPlugin' action='updateConfigureCloverPlugin.action' submitLabelKey='clover.license.update.license']
    [@ww.param name='buttons']
        [@cp.displayLinkButton buttonId="deleteButton" buttonLabel="clover.license.delete.license" buttonUrl='${req.contextPath}/admin/deleteConfigureCloverPlugin.action' cssClass="requireConfirmation" altText="delete the Clover license" /]
    [/@ww.param]
    [@ui.bambooSection titleKey='license.update.title' ]
        [@ww.textarea labelKey='clover.plugin.configure.globalLicenseKey' name="licenseString" rows="8" cssClass="long-field" /]
    [/@ui.bambooSection]
[/@ww.form]

</body>
</html>