/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.extras.api.ProductLicense;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConfigureCloverPlugin
extends BambooActionSupport
implements GlobalAdminSecurityAware,
Preparable {
    private static final Logger log = Logger.getLogger(ConfigureCloverPlugin.class);
    private String licenseString;
    private ProductLicense license;
    private BandanaManager bandanaManager;

    public void prepare() throws Exception {
        this.license = CloverPluginHelper.getCloverProductLicense(CloverPluginHelper.getGlobalLicenseKey(this.bandanaManager));
    }

    public void validate() {
        super.validate();
        if (StringUtils.isEmpty((String)this.licenseString)) {
            this.addFieldError("licenseString", this.getText("license.error.required"));
        } else if (!CloverPluginHelper.isValidLicenseKey(this.licenseString)) {
            this.addFieldError("licenseString", this.getText("license.error.invalid"));
        }
    }

    public String doDefault() throws Exception {
        return "input";
    }

    public String doExecute() throws Exception {
        CloverPluginHelper.setGlobalLicenseKey(this.bandanaManager, this.licenseString);
        return "success";
    }

    public String doDelete() throws Exception {
        CloverPluginHelper.setGlobalLicenseKey(this.bandanaManager, "");
        return "success";
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public ProductLicense getLicense() {
        return this.license;
    }
}

