/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.charts;

import com.atlassian.bamboo.charts.utils.ChartDefaults;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import com.atlassian.bamboo.util.NumberUtils;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildSummaryCoverageLineChart
extends BambooReportLineChart
implements XYToolTipGenerator {
    public BuildSummaryCoverageLineChart() {
        this.setyAxisLabel("% Code Coverage");
    }

    public JFreeChart getJFreeChart() {
        JFreeChart jFreeChart1 = super.getJFreeChart();
        XYPlot xyPlot = jFreeChart1.getXYPlot();
        xyPlot.getRangeAxis().setUpperBound(100.0);
        if (this.dataSet.getSeriesCount() == 1) {
            XYAreaRenderer renderer = new XYAreaRenderer(5);
            ChartUtil.populateRendererDefaults((XYToolTipGenerator)this, (XYSeriesLabelGenerator)this, (AbstractXYItemRenderer)renderer);
            renderer.setOutline(true);
            renderer.setSeriesOutlinePaint(0, (Paint)ChartDefaults.BRIGHT_GREEN);
            renderer.setSeriesPaint(0, (Paint)ChartDefaults.GREEN_DIFF);
            xyPlot.setRenderer((XYItemRenderer)renderer);
        }
        return jFreeChart1;
    }

    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        double percentageCovered = dataset.getYValue(series, item);
        String buildKey = (String)((Object)dataset.getSeriesKey(series));
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return "Tests in " + timePeriod + " covered " + NumberUtils.round((double)percentageCovered, (int)1) + "% of code in build " + buildKey;
    }
}

