/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.core.LicenseManagerFactory;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloverPluginHelper {
    private static final Logger log = Logger.getLogger(CloverPluginHelper.class);
    public static final String BANDANA_KEY_GLOBAL_LICENSE_KEY = "com.atlassian.bamboo.plugin.clover:globalLicenseKey";

    public static boolean isAutoIntegrate(@Nullable BuildConfiguration config) {
        return CloverPluginHelper.isCloverOn(config) && "auto".equals(config.getString("custom.clover.integration"));
    }

    public static boolean isAutoIntegrate(@Nullable Map<String, String> config) {
        return CloverPluginHelper.isCloverOn(config) && "auto".equals(config.get("custom.clover.integration"));
    }

    public static boolean isCloverOn(@Nullable BuildConfiguration config) {
        return config != null && config.getBoolean("custom.clover.exists");
    }

    public static boolean isCloverOn(@Nullable Map<String, String> config) {
        return config != null && Boolean.parseBoolean(config.get("custom.clover.exists"));
    }

    public static boolean isUseLocalLicenseKey(@Nullable BuildConfiguration config) {
        return config != null && config.getBoolean("custom.clover.useLocalLicenseKey");
    }

    public static boolean hasGlobalLicenseKey(@NotNull BandanaManager bandanaManager) {
        return StringUtils.isNotEmpty((String)((String)bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_GLOBAL_LICENSE_KEY)));
    }

    public static boolean hasValidGlobalLicenseKey(@NotNull BandanaManager bandanaManager) {
        return CloverPluginHelper.isValidLicenseKey(CloverPluginHelper.getGlobalLicenseKey(bandanaManager));
    }

    public static boolean isValidLicenseKey(String licenseKey) {
        if (StringUtils.isNotEmpty((String)licenseKey)) {
            ProductLicense productLicense = CloverPluginHelper.getCloverProductLicense(licenseKey);
            return productLicense != null;
        }
        return false;
    }

    @Nullable
    public static ProductLicense getCloverProductLicense(String licenseKey) {
        try {
            AtlassianLicense atlassianLicense = LicenseManagerFactory.getLicenseManager().getLicense(licenseKey);
            return atlassianLicense.getProductLicense(Product.CLOVER);
        }
        catch (LicenseException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static String getGlobalLicenseKey(@NotNull BandanaManager bandanaManager) {
        return StringUtils.defaultString((String)((String)bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_GLOBAL_LICENSE_KEY)));
    }

    public static void setGlobalLicenseKey(@NotNull BandanaManager bandanaManager, @NotNull String globalLicenseKey) {
        bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_KEY_GLOBAL_LICENSE_KEY, (Object)globalLicenseKey);
    }

    @Nullable
    public static String getLocalLicenseKey(@Nullable BuildConfiguration config) {
        if (config != null) {
            return config.getString("custom.clover.license");
        }
        return null;
    }
}

