/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.coverage;

import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class CloverReportParser {
    private static final String CLOVER3_PREFIX = "clover3";
    private static final String CLOVER3_NAMESPACE = "http://schemas.atlassian.com/clover3/report";
    private long coveredElements;
    private long elements;
    private long files;
    private long classes;
    private long coveredConditionals;
    private long conditionals;
    private long packages;
    private long loc;
    private long ncloc;
    private long statements;
    private long coveredStatements;
    private long methods;
    private long coveredMethods;

    public void parse(InputStream stream) throws DocumentException {
        SAXReader reader = this.createReader();
        Document document = reader.read(stream);
        this.parse(document);
    }

    public void parse(File file) throws MalformedURLException, DocumentException {
        SAXReader reader = this.createReader();
        Document document = reader.read(file);
        this.parse(document);
    }

    public void parse(Document document) throws DocumentException {
        Node metricsNode = this.selectProjectMetricsNode(document);
        this.coveredElements = this.getLongValueFromNode(metricsNode, "@coveredelements");
        this.elements = this.getLongValueFromNode(metricsNode, "@elements");
        this.files = this.getLongValueFromNode(metricsNode, "@files");
        this.classes = this.getLongValueFromNode(metricsNode, "@classes");
        this.coveredConditionals = this.getLongValueFromNode(metricsNode, "@coveredconditionals");
        this.conditionals = this.getLongValueFromNode(metricsNode, "@conditionals");
        this.packages = this.getLongValueFromNode(metricsNode, "@packages");
        this.loc = this.getLongValueFromNode(metricsNode, "@loc");
        this.ncloc = this.getLongValueFromNode(metricsNode, "@ncloc");
        this.statements = this.getLongValueFromNode(metricsNode, "@statements");
        this.coveredStatements = this.getLongValueFromNode(metricsNode, "@coveredstatements");
        this.methods = this.getLongValueFromNode(metricsNode, "@methods");
        this.coveredMethods = this.getLongValueFromNode(metricsNode, "@coveredmethods");
    }

    protected Node selectProjectMetricsNode(Document document) throws DocumentException {
        Element metricsNode;
        Element projectNode;
        QName metricsQName;
        QName projectQName;
        QName coverageQName;
        if (this.isClover3(document)) {
            Namespace cloverNamespace = new Namespace(CLOVER3_PREFIX, CLOVER3_NAMESPACE);
            coverageQName = new QName("coverage", cloverNamespace);
            projectQName = new QName("project", cloverNamespace);
            metricsQName = new QName("metrics", cloverNamespace);
        } else {
            coverageQName = new QName("coverage");
            projectQName = new QName("project");
            metricsQName = new QName("metrics");
        }
        Element coverageNode = document.getRootElement();
        if (coverageNode != null && (projectNode = coverageNode.element(projectQName)) != null && (metricsNode = projectNode.element(metricsQName)) != null) {
            return metricsNode;
        }
        throw new DocumentException("Invalid Clover XML file format -  unable to find /" + coverageQName.getQualifiedName() + "/" + projectQName.getQualifiedName() + "/" + metricsQName.getQualifiedName() + " element");
    }

    private long getLongValueFromNode(Node metricsNode, String attribute) {
        Number number = metricsNode.numberValueOf(attribute);
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }

    public long getCoveredElements() {
        return this.coveredElements;
    }

    public long getElements() {
        return this.elements;
    }

    public long getFiles() {
        return this.files;
    }

    public long getClasses() {
        return this.classes;
    }

    public long getCoveredConditionals() {
        return this.coveredConditionals;
    }

    public long getConditionals() {
        return this.conditionals;
    }

    public long getPackages() {
        return this.packages;
    }

    public long getLoc() {
        return this.loc;
    }

    public long getNcloc() {
        return this.ncloc;
    }

    public long getStatements() {
        return this.statements;
    }

    public long getCoveredStatements() {
        return this.coveredStatements;
    }

    public long getMethods() {
        return this.methods;
    }

    public long getCoveredMethods() {
        return this.coveredMethods;
    }

    public double getProjectCoveragePercentage() {
        if (this.elements == 0L) {
            return 0.0;
        }
        double result = (double)this.coveredElements * 100.0 / (double)this.elements;
        return NumberUtils.round((double)result, (int)1);
    }

    private boolean isClover3(Document document) {
        return document.getRootElement() != null && CLOVER3_NAMESPACE.equals(document.getRootElement().getNamespaceURI());
    }

    private SAXReader createReader() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CLOVER3_PREFIX, CLOVER3_NAMESPACE);
        DocumentFactory factory = new DocumentFactory();
        factory.setXPathNamespaceURIs(map);
        SAXReader reader = BambooXmlUtils.newSecureSaxReader();
        reader.setDocumentFactory(factory);
        return reader;
    }
}

