/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.coverage;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.index.CustomPostBuildIndexWriter;
import com.atlassian.bamboo.index.IndexUtils;
import com.atlassian.bamboo.index.PostChainIndexWriter;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;

public class CloverPostBuildIndexWriter
implements CustomPostBuildIndexWriter,
PostChainIndexWriter {
    public void updateIndexDocument(@NotNull Document document, @NotNull BuildResultsSummary buildResultsSummary) {
        CloverPostBuildIndexWriter.updateIndex(document, (ResultsSummary)buildResultsSummary);
    }

    public void updateIndexDocument(@NotNull Document document, @NotNull ChainResultsSummary chainResultsSummary) {
        CloverPostBuildIndexWriter.updateIndex(document, (ResultsSummary)chainResultsSummary);
    }

    private static void updateIndex(Document document, ResultsSummary resultsSummary) {
        Map map = resultsSummary.getCustomBuildData();
        CloverPostBuildIndexWriter.indexField(document, map, "CLOVER_BUILD_COVERAGE");
        CloverPostBuildIndexWriter.indexField(document, map, "CLOVER_NCLOC");
    }

    private static void indexField(Document document, Map<String, String> map, String field) {
        String stringValue = map.get(field);
        if (stringValue != null) {
            IndexUtils.addField((String)field, (Number)Double.parseDouble(stringValue), (Document)document);
        }
    }
}

