/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.coverage;

import com.atlassian.bamboo.index.CustomIndexReader;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.util.NumberUtils;
import org.apache.lucene.document.Document;

public class CloverIndexReader
implements CustomIndexReader {
    public void extractFromDocument(Document document, BuildResultsSummary buildResultsSummary) {
        Double coverage = NumberUtils.createDoubleQuietly((String)document.get("CLOVER_BUILD_COVERAGE"));
        this.addToCustomDataIfNotNull(buildResultsSummary, "CLOVER_BUILD_COVERAGE", coverage);
        Double linesOfCode = NumberUtils.createDoubleQuietly((String)document.get("CLOVER_NCLOC"));
        this.addToCustomDataIfNotNull(buildResultsSummary, "CLOVER_NCLOC", linesOfCode);
    }

    private void addToCustomDataIfNotNull(BuildResultsSummary buildResultsSummary, String key, Object value) {
        if (value != null) {
            buildResultsSummary.getCustomBuildData().put(key, value.toString());
        }
    }
}

