/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.coverage;

import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CloverDeltaCalculator
extends AbstractBuildTask
implements CustomBuildProcessorServer {
    private ResultsSummaryManager resultsSummaryManager;

    @NotNull
    public BuildContext call() {
        Map customBuildData;
        String currentCoverageString;
        String prevCoverStr;
        ResultsSummary previousSummary = this.getPreviousBuildResultsSummary();
        if (previousSummary != null && (prevCoverStr = (String)previousSummary.getCustomBuildData().get("CLOVER_BUILD_COVERAGE")) != null && (currentCoverageString = (String)(customBuildData = this.buildContext.getBuildResult().getCustomBuildData()).get("CLOVER_BUILD_COVERAGE")) != null) {
            double currentCoverage = Double.parseDouble(currentCoverageString);
            customBuildData.put("CLOVER_COVERAGE_DELTA", Double.toString(NumberUtils.round((double)(currentCoverage - Double.parseDouble(prevCoverStr)), (int)4)));
        }
        return this.buildContext;
    }

    protected ResultsSummary getPreviousBuildResultsSummary() {
        return this.resultsSummaryManager.getLastSuccessfulResultSummary(this.buildContext.getPlanResultKey().getPlanKey());
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

