/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.coverage;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.plugins.PostChainAction;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CloverChainResultAggregator
implements PostChainAction {
    private static final Logger log = Logger.getLogger(CloverChainResultAggregator.class);

    public void execute(@NotNull Chain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull ChainExecution chainExecution) throws InterruptedException, Exception {
        if (!chainResultsSummary.isSuccessful()) {
            return;
        }
        double aggregatedCov = 0.0;
        int aggregatedCovCnt = 0;
        long aggregatedNcloc = 0L;
        int aggregatedNclocCnt = 0;
        for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary buildResult : stageResult.getBuildResults()) {
                String nclocStr = (String)buildResult.getCustomBuildData().get("CLOVER_NCLOC");
                String covStr = (String)buildResult.getCustomBuildData().get("CLOVER_BUILD_COVERAGE");
                if (StringUtils.isNotEmpty((String)covStr)) {
                    try {
                        aggregatedCov += Double.parseDouble(covStr);
                        ++aggregatedCovCnt;
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isNotEmpty((String)nclocStr)) continue;
                try {
                    aggregatedNcloc += Long.parseLong(nclocStr);
                    ++aggregatedNclocCnt;
                }
                catch (NumberFormatException ignored) {}
            }
        }
        if (aggregatedNclocCnt > 0) {
            chainResultsSummary.getCustomBuildData().put("CLOVER_NCLOC", Long.toString(aggregatedNcloc));
        }
        if (aggregatedCovCnt > 0) {
            chainResultsSummary.getCustomBuildData().put("CLOVER_BUILD_COVERAGE", Double.toString(aggregatedCov / (double)aggregatedCovCnt));
        }
    }
}

