/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.coverage;

import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.builder.coverage.CloverReportParser;
import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskProcessCommandDecoratorModuleDescriptor;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.FileVisitor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurableBuildPlugin;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloverBuildProcessor
extends BaseConfigurableBuildPlugin
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(CloverBuildProcessor.class);
    private static final String CLOVER_XML_PATH_KEY = "custom.clover.path";
    public static final String CLOVER_EXISTS = "custom.clover.exists";
    public static final String CLOVER_INTEGRATION = "custom.clover.integration";
    public static final String CLOVER_INTEGRATION_CUSTOM = "custom";
    public static final String CLOVER_INTEGRATION_AUTO = "auto";
    public static final String CLOVER_LICENSE = "custom.clover.license";
    public static final String CLOVER_LICENSE_USE_LOCAL_LICENSE_KEY = "custom.clover.useLocalLicenseKey";
    public static final String CLOVER_JSON = "custom.clover.json";
    public static final String CLOVER_HISTORICAL = "custom.clover.historical";
    public static final String CLOVER_OPTIMIZE = "custom.clover.optimize";
    public static final String CLOVER_BUILD_COVERAGE = "CLOVER_BUILD_COVERAGE";
    public static final String CLOVER_COVERAGE_DELTA = "CLOVER_COVERAGE_DELTA";
    private static final String CLOVER_ELEMENTS = "CLOVER_ELEMENTS";
    private static final String CLOVER_COVERED_ELEMENTS = "CLOVER_COVERED_ELEMENTS";
    private static final String CLOVER_PACKAGES = "CLOVER_PACKAGES";
    private static final String CLOVER_CONDITIONALS = "CLOVER_CONDITIONALS";
    private static final String CLOVER_COVERED_CONDITIONALS = "CLOVER_COVERED_CONDITIONALS";
    private static final String CLOVER_LOC = "CLOVER_LOC";
    public static final String CLOVER_NCLOC = "CLOVER_NCLOC";
    private static final String CLOVER_STATEMENTS = "CLOVER_STATEMENTS";
    private static final String CLOVER_COVERED_STATEMENTS = "CLOVER_COVERED_STATEMENTS";
    private static final String CLOVER_FILES = "CLOVER_FILES";
    private static final String CLOVER_METHODS = "CLOVER_METHODS";
    private static final String CLOVER_COVERED_METHODS = "CLOVER_COVERED_METHODS";
    private static final String CLOVER_CLASSES = "CLOVER_CLASSES";
    public static final String CLOVER_REPORT_ARTIFACT_PREFIX = "Clover Report";
    public static final String CLOVER_REPORT_ARTIFACT_LABEL = "Clover Report (System)";
    public static final String CLOVER_HAS_GLOBAL_LICENSE = "cloverHasGlobalLicense";
    public static final String CLOVER_HAS_VALID_GLOBAL_LICENSE = "cloverHasValidGlobalLicense";
    public static final String CLOVER_HAS_LOCAL_LICENSE = "cloverHasLocalLicense";
    private static final Map<String, String> CLOVER_INTEGRATION_OPTIONS = new LinkedHashMap<String, String>(){
        {
            this.put(CloverBuildProcessor.CLOVER_INTEGRATION_AUTO, "Automatically integrate Clover into this build.");
            this.put(CloverBuildProcessor.CLOVER_INTEGRATION_CUSTOM, "Clover is already integrated into this build and a clover.xml file will be produced.For more information visit: <a href='http://www.atlassian.com/software/clover/' rel='help'>Atlassian Clover</a> or view the <a href='http://confluence.atlassian.com/display/CLOVER/' rel='help'>Online Documentation.</a>");
        }
    };
    private ArtifactDefinitionManager artifactDefinitionManager;
    private BandanaManager bandanaManager;
    private PlanManager planManager;

    @NotNull
    public BuildContext call() throws Exception {
        Map customConfiguration = this.buildContext.getBuildDefinition().getCustomConfiguration();
        if (!CloverPluginHelper.isCloverOn(customConfiguration)) {
            return this.buildContext;
        }
        String pathPattern = (String)customConfiguration.get(CLOVER_XML_PATH_KEY);
        if (StringUtils.isEmpty((String)pathPattern)) {
            throw new IllegalStateException("Clover result path is empty, but Clover integration is enabled");
        }
        LinkedHashSet<File> directoriesToScan = this.getDirectoriesToScan(customConfiguration);
        CloverFileLocator locator = null;
        for (File directoryToScan : directoriesToScan) {
            locator = new CloverFileLocator(directoryToScan);
            locator.visitFilesThatMatch(pathPattern);
            if (locator.getFile() == null) continue;
            break;
        }
        assert (locator != null);
        File cloverXmlFile = locator.getFile();
        if (cloverXmlFile == null) {
            throw new Exception("No file matches the specified pattern:" + pathPattern + " in " + directoriesToScan);
        }
        HashMap cloverResults = Maps.newHashMap();
        this.processCloverResultsFile(cloverXmlFile, cloverResults);
        CurrentBuildResult buildResult = this.buildContext.getBuildResult();
        buildResult.getCustomBuildData().putAll(cloverResults);
        return this.buildContext;
    }

    private LinkedHashSet<File> getDirectoriesToScan(Map<String, String> configuration) {
        LinkedHashSet directories = Sets.newLinkedHashSet();
        File buildWorkingDirectory = BuildContextHelper.getBuildWorkingDirectory((BuildContext)this.buildContext);
        if (!CloverPluginHelper.isAutoIntegrate(configuration)) {
            directories.add(buildWorkingDirectory);
        }
        ArrayList tasksDecoratedByClover = Lists.newArrayList();
        List supportedDecorators = this.moduleDescriptor.getPlugin().getModuleDescriptorsByModuleClass(TaskProcessCommandDecorator.class);
        for (ModuleDescriptor supportedDecorator : supportedDecorators) {
            TaskProcessCommandDecoratorModuleDescriptor taskProcessCommandDecoratorModuleDescriptor = (TaskProcessCommandDecoratorModuleDescriptor)Narrow.downTo((Object)supportedDecorator, TaskProcessCommandDecoratorModuleDescriptor.class);
            if (taskProcessCommandDecoratorModuleDescriptor == null) continue;
            Set decorableTaskTypeKeys = taskProcessCommandDecoratorModuleDescriptor.getDecorableTaskTypeKeys();
            for (String decorableTaskTypeKey : decorableTaskTypeKeys) {
                Iterables.addAll((Collection)tasksDecoratedByClover, (Iterable)BambooPluginUtils.filterTasks((BuildContext)this.buildContext, (String)decorableTaskTypeKey));
            }
        }
        for (TaskDefinition taskDefinition : tasksDecoratedByClover) {
            String workingSubDirectory = (String)taskDefinition.getConfiguration().get("workingSubDirectory");
            if (workingSubDirectory == null) continue;
            directories.add(new File(buildWorkingDirectory, workingSubDirectory));
        }
        if (CloverPluginHelper.isAutoIntegrate(configuration)) {
            directories.add(BuildContextHelper.getBuildWorkingDirectory((BuildContext)this.buildContext));
        }
        return directories;
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        if (buildConfiguration.getProperty(CLOVER_INTEGRATION) == null) {
            buildConfiguration.setProperty(CLOVER_INTEGRATION, (Object)CLOVER_INTEGRATION_CUSTOM);
        }
        if (buildConfiguration.getProperty(CLOVER_LICENSE_USE_LOCAL_LICENSE_KEY) == null) {
            buildConfiguration.setProperty(CLOVER_LICENSE_USE_LOCAL_LICENSE_KEY, (Object)StringUtils.isNotEmpty((String)CloverPluginHelper.getLocalLicenseKey(buildConfiguration)));
        }
    }

    public void customizeBuildRequirements(@NotNull PlanKey planKey, @NotNull BuildConfiguration buildConfiguration, @NotNull RequirementSet requirementSet) {
        Job job = (Job)this.planManager.getPlanByKeyIfOfType(planKey, Job.class);
        if (job != null) {
            ArtifactDefinition artifact;
            String taskKey;
            ArrayList taskKeys = Lists.newArrayList((Iterable)Iterables.filter(Arrays.asList(buildConfiguration.getStringArray("buildTasks.taskDefinition.pluginKey")), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !"com.atlassian.bamboo.plugins.vcs:task.vcs.checkout".equals(input);
                }
            }));
            if (taskKeys.size() > 1) {
                log.warn((Object)"Multiple tasks defined. Only first task will be instrumented by Clover");
                taskKey = (String)taskKeys.get(0);
            } else {
                if (taskKeys.isEmpty()) {
                    log.warn((Object)"No tasks defined. Clover instrumentation will not have any effect");
                    return;
                }
                taskKey = (String)taskKeys.get(0);
            }
            boolean isAnt = taskKey.contains("ant");
            boolean isGrails = taskKey.contains("grails");
            String reportDir = isAnt ? "clover" : (isGrails ? "target/clover/report/" : "target/site/clover");
            ArtifactDefinition artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition((ImmutablePlan)job, CLOVER_REPORT_ARTIFACT_LABEL);
            List artifacts = buildConfiguration.getList("artifacts.artifact.label");
            int index = artifacts.indexOf(CLOVER_REPORT_ARTIFACT_LABEL);
            boolean autoArtifactExists = artifactDefinition != null;
            boolean autoIntegrate = CloverPluginHelper.isAutoIntegrate(buildConfiguration);
            boolean cloverEnabled = CloverPluginHelper.isCloverOn(buildConfiguration);
            if (cloverEnabled && !autoArtifactExists) {
                ArtifactDefinitionImpl artifact2 = new ArtifactDefinitionImpl(CLOVER_REPORT_ARTIFACT_LABEL, reportDir, "**/*.*");
                artifact2.setProducerJob(job);
                this.artifactDefinitionManager.saveArtifactDefinition((ArtifactDefinition)artifact2);
            } else if (!cloverEnabled && (artifact = this.artifactDefinitionManager.findArtifactDefinition((ImmutablePlan)job, CLOVER_REPORT_ARTIFACT_LABEL)) != null) {
                this.artifactDefinitionManager.removeArtifactDefinition(artifact);
            }
            if (autoIntegrate) {
                buildConfiguration.clearProperty(CLOVER_XML_PATH_KEY);
                buildConfiguration.addProperty(CLOVER_XML_PATH_KEY, (Object)(reportDir + File.separator + "**" + File.separator + "clover.xml"));
            }
        }
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration configuration) {
        SimpleErrorCollection ec = new SimpleErrorCollection();
        if (CloverPluginHelper.isCloverOn(configuration)) {
            if (configuration.getProperty(CLOVER_INTEGRATION) == null) {
                ec.addError(CLOVER_INTEGRATION, "Please select an integration option for Clover.");
            }
            if (CLOVER_INTEGRATION_CUSTOM.equals(configuration.getString(CLOVER_INTEGRATION)) && StringUtils.isBlank((String)configuration.getString(CLOVER_XML_PATH_KEY))) {
                ec.addError(CLOVER_XML_PATH_KEY, "Please specify the directory containing the XML clover output files.");
            }
            if (CloverPluginHelper.isAutoIntegrate(configuration)) {
                String localLicenseKey = CloverPluginHelper.getLocalLicenseKey(configuration);
                if (StringUtils.isEmpty((String)localLicenseKey)) {
                    if (!CloverPluginHelper.hasGlobalLicenseKey(this.bandanaManager)) {
                        ec.addError(CLOVER_LICENSE, "Global Clover license has not been configured. You need to provide license in order to use Clover.");
                    }
                } else if (!CloverPluginHelper.isValidLicenseKey(localLicenseKey)) {
                    ec.addError(CLOVER_LICENSE, "Please provide valid Clover license.");
                }
            }
        }
        return ec;
    }

    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan build) {
        context.put(CLOVER_HAS_GLOBAL_LICENSE, CloverPluginHelper.hasGlobalLicenseKey(this.bandanaManager));
        context.put(CLOVER_HAS_VALID_GLOBAL_LICENSE, CloverPluginHelper.hasValidGlobalLicenseKey(this.bandanaManager));
    }

    protected void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        context.put("cloverIntegrationOptions", CLOVER_INTEGRATION_OPTIONS);
        context.put(CLOVER_HAS_GLOBAL_LICENSE, CloverPluginHelper.hasGlobalLicenseKey(this.bandanaManager));
        context.put(CLOVER_HAS_VALID_GLOBAL_LICENSE, CloverPluginHelper.hasValidGlobalLicenseKey(this.bandanaManager));
        context.put(CLOVER_HAS_LOCAL_LICENSE, buildConfiguration.getBoolean(CLOVER_LICENSE_USE_LOCAL_LICENSE_KEY));
        if (CloverPluginHelper.isCloverOn(buildConfiguration) && buildConfiguration.getProperty(CLOVER_INTEGRATION) == null) {
            buildConfiguration.addProperty(CLOVER_INTEGRATION, (Object)CLOVER_INTEGRATION_CUSTOM);
        }
    }

    private void processCloverResultsFile(File file, Map<String, String> cloverResults) throws MalformedURLException, DocumentException, HibernateException {
        CloverReportParser parser = new CloverReportParser();
        parser.parse(file);
        double coverageDbl = parser.getProjectCoveragePercentage();
        cloverResults.put(CLOVER_BUILD_COVERAGE, Double.toString(coverageDbl));
        cloverResults.put(CLOVER_ELEMENTS, Long.toString(parser.getElements()));
        cloverResults.put(CLOVER_COVERED_ELEMENTS, Long.toString(parser.getCoveredElements()));
        cloverResults.put(CLOVER_PACKAGES, Long.toString(parser.getPackages()));
        cloverResults.put(CLOVER_CONDITIONALS, Long.toString(parser.getConditionals()));
        cloverResults.put(CLOVER_COVERED_CONDITIONALS, Long.toString(parser.getCoveredConditionals()));
        cloverResults.put(CLOVER_LOC, Long.toString(parser.getLoc()));
        cloverResults.put(CLOVER_NCLOC, Long.toString(parser.getNcloc()));
        cloverResults.put(CLOVER_STATEMENTS, Long.toString(parser.getStatements()));
        cloverResults.put(CLOVER_COVERED_STATEMENTS, Long.toString(parser.getCoveredStatements()));
        cloverResults.put(CLOVER_FILES, Long.toString(parser.getFiles()));
        cloverResults.put(CLOVER_METHODS, Long.toString(parser.getMethods()));
        cloverResults.put(CLOVER_COVERED_METHODS, Long.toString(parser.getCoveredMethods()));
        cloverResults.put(CLOVER_CLASSES, Long.toString(parser.getClasses()));
    }

    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    private static class CloverFileLocator
    extends FileVisitor {
        private File file;

        private CloverFileLocator(File planSourceDirectory) {
            super(planSourceDirectory);
        }

        public void visitFile(File file) throws InterruptedException {
            if (file.getName().endsWith("xml")) {
                if (this.file == null) {
                    this.file = file;
                } else {
                    String errorMessage = "Multiple files match the Clover result file pattern. One is at '" + file.getAbsolutePath() + "' " + "the other is at '" + this.file.getAbsolutePath() + "'. " + "Please ensure that only one clover.xml is picked up by the copy pattern.";
                    this.file = null;
                    throw new IllegalStateException(errorMessage);
                }
            }
        }

        private File getFile() {
            return this.file;
        }
    }
}

