/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.command;

import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCloverCommandDecorator
implements TaskProcessCommandDecorator {
    private static final Logger log = Logger.getLogger(AbstractCloverCommandDecorator.class);
    public static final String CFG_CLOVER_EXISTS = "custom.clover.exists";
    protected BandanaManager bandanaManager;
    protected CapabilityContext capabilityContext;
    protected EnvironmentVariableAccessor environmentVariableAccessor;

    @NotNull
    public abstract List<String> decorateCloverArguments(@NotNull TaskContext var1, @NotNull CIOptions.Builder var2, @NotNull List<String> var3);

    @NotNull
    public List<String> decorate(@NotNull TaskContext taskContext, @NotNull List<String> arguments) {
        if (this.canDecorate(taskContext)) {
            CIOptions.Builder options = this.createOptionsBuilder(taskContext);
            this.configureLicense(taskContext, options);
            return this.decorateCloverArguments(taskContext, options, arguments);
        }
        return arguments;
    }

    protected CIOptions.Builder createOptionsBuilder(@NotNull TaskContext taskContext) {
        Map<String, String> configuration = this.getCustomConfiguration(taskContext);
        return new CIOptions.Builder().historical(Boolean.parseBoolean(configuration.get("custom.clover.historical"))).json(Boolean.parseBoolean(configuration.get("custom.clover.json"))).fullClean(true).optimize(Boolean.parseBoolean(configuration.get("custom.clover.optimize")));
    }

    protected boolean canDecorate(@NotNull TaskContext taskContext) {
        Map<String, String> configuration = this.getCustomConfiguration(taskContext);
        return Boolean.parseBoolean(configuration.get(CFG_CLOVER_EXISTS)) && CloverPluginHelper.isAutoIntegrate(configuration);
    }

    protected boolean isWindowsPlatform() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    protected File getLicenseDir(@NotNull TaskContext taskContext) {
        return new File(taskContext.getWorkingDirectory(), ".clover");
    }

    protected void configureLicense(@NotNull TaskContext taskContext, @NotNull CIOptions.Builder options) {
        Map<String, String> configuration = this.getCustomConfiguration(taskContext);
        String licenseKey = Boolean.parseBoolean(configuration.get("custom.clover.useLocalLicenseKey")) ? configuration.get("custom.clover.license") : (CloverPluginHelper.hasGlobalLicenseKey(this.bandanaManager) ? CloverPluginHelper.getGlobalLicenseKey(this.bandanaManager) : "");
        if (StringUtils.isNotEmpty((String)licenseKey)) {
            File license = new File(this.getLicenseDir(taskContext), "clover.license");
            try {
                FileUtils.saveTextFile((String)licenseKey, (File)license);
                options.license(license);
            }
            catch (IOException e) {
                if (!this.isWindowsPlatform() || !licenseKey.contains(">") && !licenseKey.contains("<")) {
                    options.licenseCert(licenseKey);
                }
                log.warn((Object)("No clover.license file set due to: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected boolean isEnabled(Map<String, String> configuration) {
        return CloverPluginHelper.isAutoIntegrate(configuration);
    }

    @NotNull
    protected Map<String, String> getCustomConfiguration(@NotNull TaskContext taskContext) {
        Map customConfiguration = taskContext.getBuildContext().getBuildDefinition().getCustomConfiguration();
        if (customConfiguration != null) {
            return customConfiguration;
        }
        return Collections.emptyMap();
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setEnvironmentVariableAccessor(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
    }
}

