/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.coverage;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CloverResultWebItemCondition
implements Condition {
    private CachedPlanManager cachedPlanManager;
    private ResultsSummaryManager resultsSummaryManager;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String planKey = StringUtils.defaultString((String)((String)context.get("planKey")), (String)((String)context.get("buildKey")));
        String buildNumber = (String)context.get("buildNumber");
        if (planKey == null || buildNumber == null) {
            return false;
        }
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey));
        if (plan == null) {
            return false;
        }
        int number = Integer.parseInt(buildNumber);
        ResultsSummary summary = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)plan.getKey(), (int)number));
        if (summary == null) {
            return false;
        }
        Map customData = summary.getCustomBuildData();
        return customData.containsKey("CLOVER_BUILD_COVERAGE");
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

