/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.coverage;

import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.coverage.ReportProvider;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CloverReportLinker
implements ReportProvider {
    private static final Logger log = Logger.getLogger(CloverReportLinker.class);
    final Collection<ArtifactLink> artifacts;
    private final ImmutableResultsSummary buildResultsSummary;
    private final ArtifactLinkManager artifacLinkManager;
    private final String baseUrl;

    public CloverReportLinker(ResultsSummary summary, ArtifactLinkManager artifacLinkManager, String baseUrl) {
        this.buildResultsSummary = summary;
        this.artifacLinkManager = artifacLinkManager;
        this.baseUrl = baseUrl;
        this.artifacts = artifacLinkManager.getArtifactLinks(summary, null);
    }

    @Override
    @Nullable
    public String getCloverReportUrl() {
        ArtifactLink artifact = this.getLatestCloverArtifact();
        if (artifact == null) {
            return null;
        }
        return ArtifactHandlingUtils.getArtifactUrl((ArtifactLinkManager)this.artifacLinkManager, (ArtifactLink)artifact, (String)this.baseUrl);
    }

    @Nullable
    private ArtifactLink getLatestCloverArtifact() {
        ArtifactLink cloverArtifact = null;
        for (ArtifactLink artifactLink : this.artifacts) {
            if (!artifactLink.getLabel().startsWith("Clover Report (System)") && !this.isCloverReport(artifactLink)) continue;
            cloverArtifact = artifactLink;
            break;
        }
        return cloverArtifact;
    }

    @Override
    public ImmutableResultsSummary getBuildResultsSummary() {
        return this.buildResultsSummary;
    }

    @Override
    public String getTimestamp() {
        ArtifactLink artifact = this.getLatestCloverArtifact();
        if (artifact != null) {
            ArtifactLinkDataProvider artifactLinkDataProvider = this.artifacLinkManager.getArtifactLinkDataProvider(artifact);
            if (artifactLinkDataProvider == null) {
                return "";
            }
            Date ts = artifactLinkDataProvider.lastModified();
            return ts == null ? "" : new SimpleDateFormat("HH:mm:ss dd MMM yyyy").format(ts);
        }
        return "";
    }

    private boolean isCloverReport(ArtifactLink artifactLink) {
        ArtifactLinkDataProvider artifactLinkDataProvider = this.artifacLinkManager.getArtifactLinkDataProvider(artifactLink);
        if (artifactLinkDataProvider == null || !artifactLinkDataProvider.exists()) {
            return false;
        }
        String artifactPath = (String)Iterables.getFirst((Iterable)artifactLinkDataProvider.getUrls(), null);
        if (artifactPath == null) {
            log.error((Object)("No URLs returned by " + artifactLinkDataProvider.getClass()));
            return false;
        }
        if (artifactLinkDataProvider.exists(new String[]{artifactPath, "img", "clover.ico"})) {
            return true;
        }
        String parentPath = FilenameUtils.getPathNoEndSeparator((String)artifactPath);
        return artifactLinkDataProvider.exists(new String[]{parentPath, "img", "clover.ico"});
    }
}

