/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CloverGrailsPreBuildAction
implements CustomPreBuildAction {
    private static final Logger log = Logger.getLogger(CloverGrailsPreBuildAction.class);
    public static final String INSTALL_DEFAULT_CLOVER_PLUGIN = "install-plugin clover";
    public static final String INSTALL_SPECIFIC_CLOVER_PLUGIN_VERSION = "install-plugin clover ${bamboo.grails.cloverPluginVersion}";
    public static final String GRAILS_TASK_KEY = "com.atlassian.bamboo.plugins.bamboo-grails-plugin:grailsBuilderTaskType";
    public static final String GRAILS_CLOVER_PLUGIN_VERSION_VARIABLE = "grails.cloverPluginVersion";
    private BuildContext buildContext;
    private String goal;
    private final CustomVariableContext customVariableContext;

    public CloverGrailsPreBuildAction(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public ErrorCollection validate(BuildConfiguration config) {
        return null;
    }

    public void init(@NotNull BuildContext buildContext) {
        this.buildContext = buildContext;
        this.goal = Iterables.contains(this.customVariableContext.getVariables(buildContext).keySet(), (Object)GRAILS_CLOVER_PLUGIN_VERSION_VARIABLE) ? INSTALL_SPECIFIC_CLOVER_PLUGIN_VERSION : INSTALL_DEFAULT_CLOVER_PLUGIN;
    }

    @NotNull
    public BuildContext call() throws Exception {
        if (CloverPluginHelper.isAutoIntegrate(this.buildContext.getBuildDefinition().getCustomConfiguration())) {
            for (TaskDefinition taskDefinition : this.buildContext.getBuildDefinition().getTaskDefinitions()) {
                if (!GRAILS_TASK_KEY.equals(taskDefinition.getPluginKey())) continue;
                String goals = (String)taskDefinition.getConfiguration().get("goals");
                goals = this.goal + "\r\n" + goals;
                taskDefinition.getConfiguration().put("goals", goals);
            }
        }
        return this.buildContext;
    }
}

