define('plugin-bitbucket/repository-form', [
    'jquery',
    'underscore',
    'brace',
    'util/events',
    'util/elements'
], function(
    $,
    _,
    Brace,
    events,
    elements
) {
    'use strict';

    var RepositoryForm = Brace.View.extend({

        mixins: [
            events.EventBusMixin,
            elements
        ],

        elements: {
            repository: 'input[name="repository.bitbucket.repository"]'
        },
        inheritedData: {
            repository: ''
        },

        initialize: function(options) {
            this.params = options.params || {};

            if (options.elements) {
                this.elements = options.elements;
            }

            if (options.params.inheritedData) {
                this.inheritedData = options.params.inheritedData;
            }

            this.onEvent('unbind', this.onUnbind);
            this.onEvent('repository:server:toggle-override', this.onToggleBranchOverride);

            this.onEvent('bitbucket:repository:update', this.onRepositoryUpdate);
            this.onEvent('bitbucket:repository:init', _.bind(function(instance, item) {
                this.onRepositoryUpdate(instance, item, true);
            }, this));

            this.onEvent('bitbucket:errors:show', this.onShowFieldErrors);
            this.onEvent('bitbucket:errors:clear', this.onClearFieldErrors);

            this.triggerEvent('bitbucket:form:config', this.getConfig());
            this.triggerEvent('bitbucket:repository:selection:init');
        },

        onUnbind: function() {
            this.undelegateEvents();
            this.clearElementsCache();
            this.$el.removeData().unbind();
            this.offEventNamespace('repository');
            this.offEventNamespace('bitbucket');
        },

        isOverrideOn: function() {
            return !this.params.overrideRepositoryLocation.length
                || this.params.overrideRepositoryLocation.val() === 'true';
        },

        onToggleBranchOverride: function() {
            if (this.inheritedData && this.inheritedData.repository) {
                var currentSlug = this.getElement('repository').val();
                if (currentSlug !== this.inheritedData.repository) {
                    if (this.isOverrideOn()) {
                        this.triggerEvent('bitbucket:repository:change', {fullName: currentSlug}, false);
                    } else {
                        this.triggerEvent('bitbucket:repository:change',
                            {fullName: this.inheritedData.repository}, false);
                    }
                }
            }
        },

        onRepositoryUpdate: function(instance, item, state) {
            this.triggerEvent('bitbucket:form:config', this.getConfig());
            this.triggerEvent('bitbucket:repository:change', item, !!state);
            this.params.scmEl.val(item.scm.toUpperCase());
            BAMBOO.DynamicFieldParameters.syncFieldShowHide(this.params.scmEl.parent(), true);
            if (this.params.detailedConfiguration.hasClass('hidden')) {
                this.params.detailedConfiguration.hide().removeClass('hidden').slideDown();
            }
        },

        onClearFieldErrors: function() {
            this.$el.find('.error').remove();
        },

        onShowFieldErrors: function(instance, field, errors) {
            if (_.isString(field)) {
                field = this.getElement(field);
            }

            field.parent().find('.error').remove();

            BAMBOO.addFieldErrors(
                field.closest('form'),
                field.attr('name'),
                errors, true
            );
        },

        getConfig: function() {
            return {
                repository: this.getElement('repository').val()
            };
        }

    });

    return RepositoryForm;
});
