define('plugin-bitbucket/bitbucket-autocomplete', [
    'jquery',
    'underscore',
    'widget/autocomplete-ajax'
], function(
    $,
    _,
    AutocompleteAjax
) {
    'use strict';

    var BitbucketAutocomplete = AutocompleteAjax.extend({

        getRemoteData: function(url, params) {
            this.$el.removeClass('ajax-completed');

            var data = _.extend(params.data, this.getJsonAuthenticationParams());

            return $.ajax({
                type: 'POST',
                url: url,
                data: JSON.stringify(data),
                contentType: 'application/json',
                dataType: 'json'
            })
                .fail(_.bind(this.onRemoteError, this))
                .complete(_.bind(function() {
                    this.$el.data('ajax-completed', (new Date()).getTime());
                    this.$el.addClass('ajax-completed');
                }, this));
        },

        onRemoteError: function(xhr) {
            var errors = [];

            this.$fieldGroup.show();
            this.$el.auiSelect2('close');
            this.removeLoadingIcon().clearValue().enable().$el.val('');

            if (xhr.responseText) {
                var response = JSON.parse(xhr.responseText);

                if (response.errors) {
                    errors = response.errors;
                }
            }

            if (!errors.length) {
                errors.push(AJS.I18n.getText('repository.bitbucket.ajaxError'));
            }

            this.triggerEvent('bitbucket:errors:show',
                this.$el, errors
            );
        },

        isOverrideOn: function() {
            return !this.params.overrideRepositoryLocation.length
                || this.params.overrideRepositoryLocation.val() === 'true';
        },

        getJsonAuthenticationParams: function() {
            if (this.isOverrideOn()) {
                var params = { accessLevel: this.params.accessLevel.val() };
                if (params.accessLevel === 'PUBLIC') {
                    params.username = this.params.owner.val();
                } else {
                    params.credentialsSource = this.getCredentialsSource();
                    if (params.credentialsSource === 'SHARED_CREDENTIALS') {
                        params.sharedCredentialsId = this.params.sharedCredentialsId.val();
                    } else {
                        params.username = this.params.username.val();
                        params.password = this.params.password.val();
                    }
                }
                params.repositoryId = this.params.repositoryId;
                return params;
            } else {
                // if override off don't send credentials, use inherited data
                return {
                    repositoryId: this.params.inheritedData.id,
                    repository: this.params.inheritedData.repository
                };
            }
        },

        getCredentialsSource: function() {
            return this.params.credentialsSource.filter(function(index, radio) {
                return $(radio).is(':checked');
            }).val();
        }
    });

    return BitbucketAutocomplete;
});
