<div id="bbcloud-repository">
[@s.select
 labelKey='repository.bitbucket.accessLevel'
 name='repository.bitbucket.accessLevel'
 toggle=true
 list=bbCloudAccessLevels
 listKey='value'
 listValue='name'
 optionDescription='label']
[/@s.select]

[@ui.bambooSection dependsOn='repository.bitbucket.accessLevel' showOn='PRIVATE']

    [@s.radio name='repository.bitbucket.passwordCredentialsSource'
    listKey='name'
    listValue='label'
    toggle='true'
    list=bbCloudPasswordCredentialSources
    descriptionKey='repository.bitbucket.passwordCredentialsSource.description'
    cssClass='radio-group']
    [/@s.radio]

    [@ui.bambooSection dependsOn='repository.bitbucket.passwordCredentialsSource' showOn='CUSTOM']
        [@s.textfield id='repository.bitbucket.username' labelKey='repository.bitbucket.username' name='repository.bitbucket.username' required=true /]
        [#if stack.findValue('repository.bitbucket.password')?has_content]
            [@s.checkbox labelKey='repository.password.change' toggle=true name='repository.bitbucket.password.change' /]
            [@ui.bambooSection dependsOn='repository.bitbucket.password.change' showOn=true]
                [@s.password labelKey='repository.bitbucket.password' name='repository.bitbucket.temporary.password' required=true /]
            [/@ui.bambooSection]
        [#else]
            [@s.hidden name='repository.bitbucket.password.change' value=true /]
            [@s.password labelKey='repository.bitbucket.password' name='repository.bitbucket.temporary.password' required=true /]
        [/#if]
    [/@ui.bambooSection]

    [@ui.bambooSection dependsOn='repository.bitbucket.passwordCredentialsSource' showOn='SHARED_CREDENTIALS']
        [#if bbCloudPasswordSharedCredentials.empty]
            [@noCredentialsMessageBox id='repository.bitbucket.passwordSharedCredentials.infoBox'/]
        [#else]
            [#if stack.findValue('repository.bitbucket.passwordSharedCredentials.deleted')!false]
                [@credentialsDeletedMessageBox /]
            [/#if]
            [@s.select
            labelKey='repository.bitbucket.sharedCredentials.id'
            name='repository.bitbucket.passwordSharedCredentials.id'
            toggle=true
            list=bbCloudPasswordSharedCredentials
            listKey='name'
            listValue='label']
            [/@s.select]
        [/#if]
    [/@ui.bambooSection]
[/@ui.bambooSection]

[@ui.bambooSection dependsOn='repository.bitbucket.accessLevel' showOn='PUBLIC']
    [@s.textfield id='repository.bitbucket.owner' labelKey='repository.bitbucket.owner' name='repository.bitbucket.owner' required=true /]
[/@ui.bambooSection]


<div id="repository-bitbucket-repository" class="hidden">
    [@s.label labelKey="repository.bitbucket.repository" escape='false']
        [@s.param name='value']
            [@s.hidden name='repository.bitbucket.repository' cssClass='text long-field' showValidationErrors=true /]
        [/@s.param]
    [/@s.label]
</div>

[@s.hidden name="repository.bitbucket.scm" toggle=true/]

[#-- detailed configuration should be displayed only when repository has been selected --]
[@ui.bambooSection id='bitbucket-detailed-configuration' cssClass=stack.findValue('repository.bitbucket.repository')?has_content?then('', 'hidden')]
    [@ui.bambooSection id='bitbucket-authentication-configuration' dependsOn='repository.bitbucket.accessLevel' showOn='PRIVATE']
        [@s.select
        labelKey='repository.bitbucket.authenticationType'
        name='repository.bitbucket.authenticationType'
        toggle=true
        list=bbCloudPrivateRepositoryAuthenticationTypes
        listKey='name'
        listValue='label']
        [/@s.select]

        [@ui.bambooSection dependsOn='repository.bitbucket.authenticationType' showOn='SSH_KEYPAIR']

            [@s.radio name='repository.bitbucket.sshCredentialsSource'
            listKey='name'
            listValue='label'
            toggle='true'
            list=bbCloudSshCredentialSources
            descriptionKey='repository.bitbucket.sshCredentialsSource.description'
            cssClass='radio-group']
            [/@s.radio]

            [@ui.bambooSection dependsOn='repository.bitbucket.sshCredentialsSource' showOn='CUSTOM']
                [#if stack.findValue('repository.bitbucket.sshKey')?has_content]
                    [@s.checkbox labelKey='repository.bitbucket.sshKey.change' toggle=true name='repository.bitbucket.temporary.sshKeyChange' /]
                    [@ui.bambooSection dependsOn='repository.bitbucket.temporary.sshKeyChange']
                        [@s.file labelKey='repository.bitbucket.sshKey' name='repository.bitbucket.temporary.sshKeyFile' required=true /]
                    [/@ui.bambooSection]
                [#else]
                    [@s.hidden name='repository.bitbucket.temporary.sshKeyChange' value='true'/]
                    [@s.file labelKey='repository.bitbucket.sshKey' name='repository.bitbucket.temporary.sshKeyFile' required=true /]
                [/#if]

                [#if stack.findValue('repository.bitbucket.sshPassphrase')?has_content]
                    [@s.checkbox labelKey='repository.bitbucket.sshPassphrase.change' toggle=true name='repository.bitbucket.temporary.sshPassphraseChange' /]
                    [@ui.bambooSection dependsOn='repository.bitbucket.temporary.sshPassphraseChange']
                        [@s.password labelKey='repository.bitbucket.sshPassphrase' name='repository.bitbucket.temporary.sshPassphrase' /]
                    [/@ui.bambooSection]
                [#else]
                    [@s.hidden name='repository.bitbucket.temporary.sshPassphraseChange' value='true' /]
                    [@s.password labelKey='repository.bitbucket.sshPassphrase' name='repository.bitbucket.temporary.sshPassphrase' /]
                [/#if]
            [/@ui.bambooSection]

            [@ui.bambooSection dependsOn='repository.bitbucket.sshCredentialsSource' showOn='SHARED_CREDENTIALS']
                [#if bbCloudSshSharedCredentials.empty]
                    [@noCredentialsMessageBox id='repository.bitbucket.sshSharedCredentials.infoBox'/]
                [#else]
                    [#if stack.findValue('repository.bitbucket.sshSharedCredentials.deleted')!false]
                        [@credentialsDeletedMessageBox /]
                    [/#if]
                    [@s.select
                    labelKey='repository.bitbucket.sharedCredentials.id'
                    name='repository.bitbucket.sshSharedCredentials.id'
                    toggle=true
                    list=bbCloudSshSharedCredentials
                    listKey='name'
                    listValue='label']
                    [/@s.select]
                [/#if]
            [/@ui.bambooSection]

        [/@ui.bambooSection]
    [/@ui.bambooSection]
[/@ui.bambooSection]


<script type="text/javascript">
    try {
    require([
        'jquery',
        'plugin-bitbucket/repository-autocomplete',
        'plugin-bitbucket/repository-form'
    ], function(
            $,
            RepositoryAutocomplete,
            RepositoryForm
    ){
        var container = $('#bbcloud-repository');
        var overrideRepositoryLocation = $('#overrideRepositoryLocation');

        new RepositoryAutocomplete({
            el: container.find('input[name="repository.bitbucket.repository"]'),
            params: {
                overrideRepositoryLocation: overrideRepositoryLocation,
                placeholder: '[@s.text name='repository.bitbucket.repository.placeholder' /]',
                repositoryId: ${(repositoryId)!0},
                accessLevel: container.find('select[name="repository.bitbucket.accessLevel"]'),
                credentialsSource: container.find('input[name="repository.bitbucket.passwordCredentialsSource"]'),
                sharedCredentialsId: container.find('select[name="repository.bitbucket.passwordSharedCredentials.id"]'),
                username: container.find('input[id="repository.bitbucket.username"]'),
                password: container.find('input[name="repository.bitbucket.temporary.password"]'),
                owner: container.find('input[id="repository.bitbucket.owner"]'),
                slugEl: container.find('input[name="repository.bitbucket.repository"]'),
                scmEl: container.find('input[name="repository.bitbucket.scm"]')
                [#if inheritedVcsDefinition??]
                ,
                inheritedData: {
                    id: '${inheritedVcsDefinition.id}',
                    repository: '${inheritedVcsDefinition.vcsLocation.configuration.get("repository.bitbucket.repository")?js_string}'
                }
                [/#if]
            }
        });

        new RepositoryForm({
            el: container,
            params: {
                overrideRepositoryLocation: overrideRepositoryLocation,
                scmEl: container.find('input[name="repository.bitbucket.scm"]'),
                detailedConfiguration: container.find('fieldset#bitbucket-detailed-configuration')
                [#if inheritedVcsDefinition??]
                ,
                inheritedData: {
                    id: '${inheritedVcsDefinition.id}',
                    repository: '${inheritedVcsDefinition.vcsLocation.configuration.get("repository.bitbucket.repository")?js_string}'
                }
                [/#if]
            }
        });
    });
    } catch (e) {
        console.info(e);
    }
</script>
</div>

[#macro noCredentialsMessageBox id]
    [@ui.messageBox type='info']
    <div id="${id}">
        <p>
            [#if fn.hasRestrictedAdminPermission()]
                    [@s.text name='sharedCredentials.info.noCredentialsDefined.admin']
                [@s.param][@s.url action='configureSharedCredentials' namespace='/admin/credentials'/][/@s.param]
            [/@s.text]
                [#else]
                [@s.text name='sharedCredentials.info.noCredentialsDefined.nonAdmin']
                    [@s.param][@s.url action='viewAdministrators' namespace=''/][/@s.param]
                [/@s.text]
            [/#if]
        </p>
        <p>
            [@s.text name='sharedCredentials.info.noCredentialsDefined.moreInfo']
                    [@s.param][@help.href pageKey="shared.credentials"/][/@s.param]
                [/@s.text]
        </p>
    </div>
    [/@ui.messageBox]
[/#macro]

[#macro credentialsDeletedMessageBox]
    [#if fn.hasRestrictedAdminPermission()]
        [@ui.messageBox type="error" titleKey="repository.bitbucket.sharedCredentials.deleted.title"]
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.edit"/]
        <br/>
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.update" ]
                [@s.param][@s.url action="configureSharedCredentials" namespace="/admin" /][/@s.param]
            [/@s.text]
        [/@ui.messageBox]
    [#else]
        [@ui.messageBox type="error" titleKey="repository.bitbucket.sharedCredentials.deleted.title"]
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.edit"/]
        [/@ui.messageBox]
    [/#if]
[/#macro]
