[#-- @ftlvariable name="repository" type="com.atlassian.bamboo.plugins.bitbucket.BitbucketRepository" --]

[@s.select
    labelKey='repository.bitbucket.accessLevel'
    name='repository.bitbucket.accessLevel'
    list=repository.accessLevels
    listKey='value'
    listValue='name'
    optionDescription='label'
    disabled=true/]

[#if buildConfiguration.getString('repository.bitbucket.accessLevel')=='PRIVATE']

    [@s.radio name='view.repository.bitbucket.passwordCredentialsSource'
        value= stack.findValue('repository.bitbucket.passwordCredentialsSource')
        listKey='name'
        listValue='label'
        list=repository.passwordCredentialsSources
        descriptionKey='repository.bitbucket.passwordCredentialsSource.description'
        cssClass='radio-group'
        disabled = true/]

    [#if buildConfiguration.getString('repository.bitbucket.passwordCredentialsSource')=='CUSTOM']
        [@s.textfield id='repository.bitbucket.username' labelKey='repository.bitbucket.username' name='repository.bitbucket.username' disabled=true /]
    [/#if]

    [#if buildConfiguration.getString('repository.bitbucket.passwordCredentialsSource')=='SHARED_CREDENTIALS']
        [#if repository.passwordSharedCredentials.empty]
            [@noCredentialsMessageBox id='repository.bitbucket.passwordSharedCredentials.infoBox'/]
        [#else]
            [#if buildConfiguration.getBoolean('repository.bitbucket.passwordSharedCredentials.deleted')]
                [@credentialsDeletedMessageBox /]
           [/#if]
            [@s.select
                labelKey='repository.bitbucket.sharedCredentials.id'
                name='repository.bitbucket.passwordSharedCredentials.id'
                list=repository.passwordSharedCredentials
                listKey='name'
                listValue='label'
                disabled = true/]
        [/#if]
    [/#if]
[/#if]

[#if buildConfiguration.getString('repository.bitbucket.accessLevel')=='PUBLIC']
    [@s.textfield id='repository.bitbucket.owner' labelKey='repository.bitbucket.owner' name='repository.bitbucket.owner' disabled=true /]
[/#if]

[@s.select labelKey="repository.bitbucket.repository"
    name='repository.bitbucket.readonly.repository'
    value=buildConfiguration.getString('repository.bitbucket.repository')
    list=[buildConfiguration.getString('repository.bitbucket.repository')]
    fieldClass='bitbucket-repository'
    cssClass='long-field'
    disabled=true/]


[#-- detailed configuration should be displayed only when repository has been selected --]
[@ui.bambooSection id='bitbucket-detailed-configuration']
    [@s.select labelKey='repository.bitbucket.branch'
        name='repository.bitbucket.branch'
        descriptionKey='repository.bitbucket.branch.description'
        fieldClass='bitbucket-branch'
        disabled=true]
        [#if buildConfiguration.getString('repository.bitbucket.branch')?has_content]
            [@s.param name='headerKey2' value=buildConfiguration.getString('repository.bitbucket.branch') /]
            [@s.param name='headerValue2' value=buildConfiguration.getString('repository.bitbucket.branch') /]
        [/#if]
    [/@s.select]

    [#if buildConfiguration.getString('repository.bitbucket.accessLevel')=='PRIVATE']
        [@s.select
            labelKey='repository.bitbucket.authenticationType'
            name='repository.bitbucket.authenticationType'
            list=repository.privateRepositoryAuthenticationTypes
            listKey='name'
            listValue='label'
            disabled=true/]

        [#if buildConfiguration.getString('repository.bitbucket.authenticationType')=='SSH_KEYPAIR']

            [@s.radio name='view.repository.bitbucket.sshCredentialsSource'
                value=stack.findValue('repository.bitbucket.sshCredentialsSource')
                listKey='name'
                listValue='label'
                list=repository.sshCredentialsSources
                descriptionKey='repository.bitbucket.sshCredentialsSource.description'
                cssClass='radio-group'
                disabled=true/]

            [#if buildConfiguration.getString('repository.bitbucket.sshCredentialsSource')=='SHARED_CREDENTIALS']
                [#if repository.sshSharedCredentials.empty]
                    [@noCredentialsMessageBox id='repository.bitbucket.sshSharedCredentials.infoBox'/]
                [#else]
                    [#if buildConfiguration.getBoolean('repository.bitbucket.sshSharedCredentials.deleted')]
                        [@credentialsDeletedMessageBox /]
                    [/#if]
                    [@s.select
                        labelKey='repository.bitbucket.sharedCredentials.id'
                        name='repository.bitbucket.sshSharedCredentials.id'
                        list=repository.sshSharedCredentials
                        listKey='name'
                        listValue='label'
                        disabled=true/]
                [/#if]
            [/#if]
        [/#if]
    [/#if]

    [#if buildConfiguration.getString('repository.bitbucket.scm')=='GIT']
        [@s.checkbox labelKey='repository.bitbucket.git.useShallowClones' name='repository.bitbucket.git.useShallowClones' disabled=true/]
        [#if (plan.buildDefinition.branchIntegrationConfiguration.enabled)!false ]
            [#if buildConfiguration.getBoolean('repository.bitbucket.git.useShallowClones')]
                [@ui.messageBox type='info' ]
                    [@s.text name='repository.bitbucket.git.messages.branchIntegration.shallowClonesWillBeDisabled' /]
                [/@ui.messageBox]
            [/#if]
        [/#if]
    [/#if]
[/@ui.bambooSection]

[#macro noCredentialsMessageBox id]
    [@ui.messageBox type='info']
    <div id="${id}">
        <p>
            [#if fn.hasRestrictedAdminPermission()]
                    [@s.text name='sharedCredentials.info.noCredentialsDefined.admin']
                [@s.param][@s.url action='configureSharedCredentials' namespace='/admin/credentials'/][/@s.param]
            [/@s.text]
                [#else]
                [@s.text name='sharedCredentials.info.noCredentialsDefined.nonAdmin']
                    [@s.param][@s.url action='viewAdministrators' namespace=''/][/@s.param]
                [/@s.text]
            [/#if]
        </p>
        <p>
            [@s.text name='sharedCredentials.info.noCredentialsDefined.moreInfo']
                    [@s.param][@help.href pageKey="shared.credentials"/][/@s.param]
                [/@s.text]
        </p>
    </div>
    [/@ui.messageBox]
[/#macro]

[#macro credentialsDeletedMessageBox]
    [#if fn.hasRestrictedAdminPermission()]
        [@ui.messageBox type="error" titleKey="repository.bitbucket.sharedCredentials.deleted.title"]
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.edit"/]
        <br/>
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.update" ]
                [@s.param][@s.url action="configureSharedCredentials" namespace="/admin" /][/@s.param]
            [/@s.text]
        [/@ui.messageBox]
    [#else]
        [@ui.messageBox type="error" titleKey="repository.bitbucket.sharedCredentials.deleted.title"]
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.edit"/]
        [/@ui.messageBox]
    [/#if]
[/#macro]
