[#-- @ftlvariable name="repository" type="com.atlassian.bamboo.plugins.bitbucket.BitbucketRepository" --]

[@s.select
    labelKey='repository.bitbucket.accessLevel'
    name='repository.bitbucket.accessLevel'
    toggle=true
    list=repository.accessLevels
    listKey='value'
    listValue='name'
    optionDescription='label']
[/@s.select]

[@ui.bambooSection dependsOn='repository.bitbucket.accessLevel' showOn='PRIVATE']

    [@s.radio name='repository.bitbucket.passwordCredentialsSource'
        listKey='name'
        listValue='label'
        toggle='true'
        list=repository.passwordCredentialsSources
        descriptionKey='repository.bitbucket.passwordCredentialsSource.description'
        cssClass='radio-group']
    [/@s.radio]

    [@ui.bambooSection dependsOn='repository.bitbucket.passwordCredentialsSource' showOn='CUSTOM']
        [@s.textfield id='repository.bitbucket.username' labelKey='repository.bitbucket.username' name='repository.bitbucket.username' required=true /]
        [#if buildConfiguration.getString('repository.bitbucket.password')?has_content]
            [@s.checkbox labelKey='repository.password.change' toggle=true name='repository.bitbucket.password.change' /]
            [@ui.bambooSection dependsOn='repository.bitbucket.password.change' showOn=true]
                [@s.password labelKey='repository.bitbucket.password' name='repository.bitbucket.temporary.password' required=true /]
            [/@ui.bambooSection]
        [#else]
            [@s.hidden name='repository.bitbucket.password.change' value=true /]
            [@s.password labelKey='repository.bitbucket.password' name='repository.bitbucket.temporary.password' required=true /]
        [/#if]
    [/@ui.bambooSection]

    [@ui.bambooSection dependsOn='repository.bitbucket.passwordCredentialsSource' showOn='SHARED_CREDENTIALS']
        [#if repository.passwordSharedCredentials.empty]
            [@noCredentialsMessageBox id='repository.bitbucket.passwordSharedCredentials.infoBox'/]
        [#else]
            [#if buildConfiguration.getBoolean('repository.bitbucket.passwordSharedCredentials.deleted')]
                [@credentialsDeletedMessageBox /]
            [/#if]
            [@s.select
                labelKey='repository.bitbucket.sharedCredentials.id'
                name='repository.bitbucket.passwordSharedCredentials.id'
                toggle=true
                list=repository.passwordSharedCredentials
                listKey='name'
                listValue='label']
            [/@s.select]
        [/#if]
    [/@ui.bambooSection]
[/@ui.bambooSection]

[@ui.bambooSection dependsOn='repository.bitbucket.accessLevel' showOn='PUBLIC']
    [@s.textfield id='repository.bitbucket.owner' labelKey='repository.bitbucket.owner' name='repository.bitbucket.owner' required=true /]
[/@ui.bambooSection]

[@s.select labelKey="repository.bitbucket.repository" name='repository.bitbucket.repository' fieldClass='bitbucket-repository' cssClass='select2-container aui-select2-container']
    [@s.param name='disabled' value=!(buildConfiguration.getString('repository.bitbucket.repository')?has_content) /]
    [@s.param name='extraUtility'][@ui.displayButton id='repository-bitbucket-load-repositories' valueKey='repository.bitbucket.loadRepositories'/][/@s.param]

    [#if buildConfiguration.getString('repository.bitbucket.repository')?has_content]
        [@s.param name='headerKey2' value=buildConfiguration.getString('repository.bitbucket.repository') /]
        [@s.param name='headerValue2']
            [#if buildConfiguration.getString('repository.bitbucket.scm')?has_content]
            ${(buildConfiguration.getString('repository.bitbucket.repository') + ' (' + buildConfiguration.getString('repository.bitbucket.scm')?lower_case + ')')}[#t/]
        [#else]
            ${buildConfiguration.getString('repository.bitbucket.repository')}[#t/]
        [/#if]
        [/@s.param]
    [/#if]
[/@s.select]

[@s.hidden name="repository.bitbucket.scm" toggle=true/]

[#-- detailed configuration should be displayed only when repository has been selected --]
[@ui.bambooSection id='bitbucket-detailed-configuration' cssClass=buildConfiguration.getString('repository.bitbucket.repository')?has_content?then('', 'hidden')]
    [@s.select labelKey='repository.bitbucket.branch' name='repository.bitbucket.branch' descriptionKey='repository.bitbucket.branch.description' fieldClass='bitbucket-branch']
        [#if buildConfiguration.getString('repository.bitbucket.branch')?has_content]
            [@s.param name='headerKey2' value=buildConfiguration.getString('repository.bitbucket.branch') /]
            [@s.param name='headerValue2' value=buildConfiguration.getString('repository.bitbucket.branch') /]
        [/#if]
    [/@s.select]

    [@ui.bambooSection id='bitbucket-authentication-configuration' dependsOn='repository.bitbucket.accessLevel' showOn='PRIVATE']
        [@s.select
            labelKey='repository.bitbucket.authenticationType'
            name='repository.bitbucket.authenticationType'
            toggle=true
            list=repository.privateRepositoryAuthenticationTypes
            listKey='name'
            listValue='label']
        [/@s.select]

        [@ui.bambooSection dependsOn='repository.bitbucket.authenticationType' showOn='SSH_KEYPAIR']

            [@s.radio name='repository.bitbucket.sshCredentialsSource'
                listKey='name'
                listValue='label'
                toggle='true'
                list=repository.sshCredentialsSources
                descriptionKey='repository.bitbucket.sshCredentialsSource.description'
                cssClass='radio-group']
            [/@s.radio]

            [@ui.bambooSection dependsOn='repository.bitbucket.sshCredentialsSource' showOn='CUSTOM']
                [#if buildConfiguration.getString('repository.bitbucket.sshKey')?has_content]
                    [@s.checkbox labelKey='repository.bitbucket.sshKey.change' toggle=true name='repository.bitbucket.temporary.sshKeyChange' /]
                    [@ui.bambooSection dependsOn='repository.bitbucket.temporary.sshKeyChange']
                        [@s.file labelKey='repository.bitbucket.sshKey' name='repository.bitbucket.temporary.sshKeyFile' required=true /]
                    [/@ui.bambooSection]
                [#else]
                    [@s.hidden name='repository.bitbucket.temporary.sshKeyChange' value='true'/]
                    [@s.file labelKey='repository.bitbucket.sshKey' name='repository.bitbucket.temporary.sshKeyFile' required=true /]
                [/#if]

                [#if buildConfiguration.getString('repository.bitbucket.sshPassphrase')?has_content]
                    [@s.checkbox labelKey='repository.bitbucket.sshPassphrase.change' toggle=true name='repository.bitbucket.temporary.sshPassphraseChange' /]
                    [@ui.bambooSection dependsOn='repository.bitbucket.temporary.sshPassphraseChange']
                        [@s.password labelKey='repository.bitbucket.sshPassphrase' name='repository.bitbucket.temporary.sshPassphrase' /]
                    [/@ui.bambooSection]
                [#else]
                    [@s.hidden name='repository.bitbucket.temporary.sshPassphraseChange' value='true' /]
                    [@s.password labelKey='repository.bitbucket.sshPassphrase' name='repository.bitbucket.temporary.sshPassphrase' /]
                [/#if]
            [/@ui.bambooSection]

            [@ui.bambooSection dependsOn='repository.bitbucket.sshCredentialsSource' showOn='SHARED_CREDENTIALS']
                [#if repository.sshSharedCredentials.empty]
                    [@noCredentialsMessageBox id='repository.bitbucket.sshSharedCredentials.infoBox'/]
                [#else]
                    [#if buildConfiguration.getBoolean('repository.bitbucket.sshSharedCredentials.deleted')]
                        [@credentialsDeletedMessageBox /]
                    [/#if]
                    [@s.select
                        labelKey='repository.bitbucket.sharedCredentials.id'
                        name='repository.bitbucket.sshSharedCredentials.id'
                        toggle=true
                        list=repository.sshSharedCredentials
                        listKey='name'
                        listValue='label']
                    [/@s.select]
                [/#if]
            [/@ui.bambooSection]

        [/@ui.bambooSection]
    [/@ui.bambooSection]

    [@ui.bambooSection dependsOn='repository.bitbucket.scm' showOn='GIT']
        [@s.checkbox labelKey='repository.bitbucket.git.useShallowClones' toggle='true' name='repository.bitbucket.git.useShallowClones' /]
        [#if (plan.buildDefinition.branchIntegrationConfiguration.enabled)!false ]
            [@ui.bambooSection dependsOn='repository.bitbucket.git.useShallowClones']
                [@ui.messageBox type='info']
                    [@s.text name='repository.bitbucket.git.messages.branchIntegration.shallowClonesWillBeDisabled' /]
                [/@ui.messageBox]
            [/@ui.bambooSection]
        [/#if]
    [/@ui.bambooSection]
[/@ui.bambooSection]

<script type="text/javascript">
    if (typeof require !== 'undefined') {
        require([ 'feature/bitbucket-repository-form' ], function(RepositoryForm) {
            var repositoryForm = new RepositoryForm({
                repositoryKey: '${repository.key?js_string}',
                repositoryId: ${(repositoryId)!0},
                selectors: {
                    repositoryType: '#selectedRepository',
                    accessLevel: 'select[name="repository.bitbucket.accessLevel"]',
                    credentialsSource: 'input[name="repository.bitbucket.passwordCredentialsSource"]',
                    sharedCredentialsId: 'select[name="repository.bitbucket.passwordSharedCredentials.id"]',
                    username: 'input[id="repository.bitbucket.username"]',
                    password: 'input[name="repository.bitbucket.temporary.password"]',
                    owner: 'input[id="repository.bitbucket.owner"]',
                    loadRepositoriesButton: '#repository-bitbucket-load-repositories',
                    repository: 'select[name="repository.bitbucket.repository"]',
                    branch: 'select[name="repository.bitbucket.branch"]',
                    bitbucketScm: 'input[name="repository.bitbucket.scm"]',
                    detailedConfiguration: 'fieldset#bitbucket-detailed-configuration'
                }
            });
            repositoryForm.init();
        });
    }
</script>

[#macro noCredentialsMessageBox id]
    [@ui.messageBox type='info']
    <div id="${id}">
        <p>
            [#if fn.hasRestrictedAdminPermission()]
                    [@s.text name='sharedCredentials.info.noCredentialsDefined.admin']
                [@s.param][@s.url action='configureSharedCredentials' namespace='/admin/credentials'/][/@s.param]
            [/@s.text]
                [#else]
                [@s.text name='sharedCredentials.info.noCredentialsDefined.nonAdmin']
                    [@s.param][@s.url action='viewAdministrators' namespace=''/][/@s.param]
                [/@s.text]
            [/#if]
        </p>
        <p>
            [@s.text name='sharedCredentials.info.noCredentialsDefined.moreInfo']
                    [@s.param][@help.href pageKey="shared.credentials"/][/@s.param]
                [/@s.text]
        </p>
    </div>
    [/@ui.messageBox]
[/#macro]

[#macro credentialsDeletedMessageBox]
    [#if fn.hasRestrictedAdminPermission()]
        [@ui.messageBox type="error" titleKey="repository.bitbucket.sharedCredentials.deleted.title"]
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.edit"/]
            <br/>
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.update" ]
                [@s.param][@s.url action="configureSharedCredentials" namespace="/admin" /][/@s.param]
            [/@s.text]
        [/@ui.messageBox]
    [#else]
        [@ui.messageBox type="error" titleKey="repository.bitbucket.sharedCredentials.deleted.title"]
            [@s.text name="repository.bitbucket.sharedCredentials.deleted.edit"/]
        [/@ui.messageBox]
    [/#if]
[/#macro]
