/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2.viewer;

import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketRepository;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.hg.BitbucketUrlProvider;
import com.atlassian.bamboo.plugins.hg.HgRepository;
import com.atlassian.bamboo.plugins.hg.HgWebRepositoryUrlProvider;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsType;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudVcsRepositoryViewer
implements VcsRepositoryViewer {
    private static final Logger log = Logger.getLogger(BitbucketCloudVcsRepositoryViewer.class);
    private static final Pattern GIT_AT_BITBUCKET_PATTERN = Pattern.compile("git@bitbucket.org:([^/]+/[^/]+)$");
    private static final Pattern GENERIC_GIT_PATTERN = Pattern.compile("[^/]+/[^/]+$");
    private static final String DEFAULT_HG_REV = "tip";
    private static final String DEFAULT_GIT_REV = "HEAD";
    private CustomVariableContext customVariableContext;
    private VcsRepositoryManager vcsRepositoryManager;
    @NotNull
    private HgWebRepositoryUrlProvider urlProvider = new BitbucketUrlProvider();

    @Nullable
    public String getWebRepositoryUrlForRevision(@NotNull String revisionId, @NotNull VcsRepositoryData repositoryData) {
        return this.urlProvider.getUrlForChangeset(null, revisionId, this.getUriForRepositoryData(repositoryData));
    }

    @NotNull
    public Map<String, String> getWebRepositoryUrlForRevisions(Stream<String> revisionIds, VcsRepositoryData repositoryDefinition) {
        return revisionIds.collect(Collectors.toMap(c -> c, c -> this.getWebRepositoryUrlForRevision((String)c, repositoryDefinition)));
    }

    @Nullable
    public String getWebRepositoryUrlForFile(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.urlProvider.getUrlForFile(file.getName(), this.getDefaultRevString(repositoryData), this.getUriForRepositoryData(repositoryData));
    }

    private String getDefaultRevString(VcsRepositoryData repositoryData) {
        VcsLocationConfigurator vcsLocationConfigurator;
        Optional vcsType;
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryData.getPluginKey());
        if (moduleDescriptor != null && (vcsType = (vcsLocationConfigurator = moduleDescriptor.getVcsLocationConfigurator()).getScmType(repositoryData.getVcsLocation())).isPresent()) {
            if (VcsType.GIT.equals(vcsType.get())) {
                return DEFAULT_GIT_REV;
            }
            if (VcsType.HG.equals(vcsType.get())) {
                return DEFAULT_HG_REV;
            }
        }
        return DEFAULT_GIT_REV;
    }

    @Nullable
    public String getWebRepositoryUrlForFileRevision(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.urlProvider.getUrlForFile(file.getName(), file.getRevision(), this.getUriForRepositoryData(repositoryData));
    }

    @Nullable
    public String getWebRepositoryUrlForFileDiff(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.urlProvider.getUrlForChangeset(file.getName(), file.getRevision(), this.getUriForRepositoryData(repositoryData));
    }

    @Nullable
    protected URI getUriForRepositoryData(VcsRepositoryData vcsRepositoryData) {
        if (vcsRepositoryData.isLegacyRepository()) {
            RepositoryData repositoryData = vcsRepositoryData.asLegacyData();
            return this.getUriForRepositoryData(repositoryData);
        }
        String urlString = null;
        if ("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2".equals(vcsRepositoryData.getPluginKey())) {
            String gitUrl = (String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.git.repositoryUrl");
            urlString = BitbucketProperty.BITBUCKET_BASE_URL + BitbucketCloudVcsRepositoryViewer.getBbRepositoryNameFromGitUrl(gitUrl);
        } else if ("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:mercurial".equals(vcsRepositoryData.getPluginKey())) {
            urlString = (String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.hg.repositoryUrl");
        } else if ("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bbCloud".equals(vcsRepositoryData.getPluginKey())) {
            urlString = BitbucketProperty.BITBUCKET_BASE_URL + (String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.repository");
        }
        if (!StringUtils.isBlank((CharSequence)urlString)) {
            try {
                return new URI(this.customVariableContext.substituteString(urlString));
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    protected URI getUriForRepositoryData(RepositoryData repositoryData) {
        BitbucketRepository bbRepository = (BitbucketRepository)((Object)Narrow.downTo((Object)repositoryData.getRepository(), BitbucketRepository.class));
        if (bbRepository != null) {
            try {
                return new URI(bbRepository.getRealRepositoryUrl());
            }
            catch (URISyntaxException e) {
                log.debug((Object)"", (Throwable)e);
                return null;
            }
        }
        HgRepository repository = (HgRepository)Narrow.downTo((Object)repositoryData.getRepository(), HgRepository.class);
        if (repository != null) {
            return repository.getRemoteUri();
        }
        return this.getGitRepository(repositoryData);
    }

    @Nullable
    private URI getGitRepository(RepositoryData repositoryData) {
        GitRepository repository = (GitRepository)Narrow.downTo((Object)repositoryData.getRepository(), GitRepository.class);
        if (repository == null) {
            return null;
        }
        String repositoryName = BitbucketCloudVcsRepositoryViewer.getBbRepositoryNameFromGitUrl(repository.getRepositoryUrl());
        try {
            return new URI(BitbucketProperty.BITBUCKET_BASE_URL + repositoryName);
        }
        catch (URISyntaxException e) {
            log.debug((Object)"", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    static String getBbRepositoryNameFromGitUrl(String repositoryUrl) {
        String noTrailingSlash = StringUtils.removeEnd((String)repositoryUrl, (String)"/");
        String noGit = StringUtils.removeEnd((String)noTrailingSlash, (String)".git");
        Matcher matcher1 = GIT_AT_BITBUCKET_PATTERN.matcher(noGit);
        if (matcher1.find()) {
            return matcher1.group(1);
        }
        Matcher matcher = GENERIC_GIT_PATTERN.matcher(noGit);
        return matcher.find() ? matcher.group(0) : null;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }
}

