/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2.export;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAuthenticationType;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketSshCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiException;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiService;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryType;
import com.atlassian.bamboo.plugins.bitbucket.api.rest.entity.BitbucketResourceEntity;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.repository.bitbucket.cloud.BitbucketCloudRepository;
import com.atlassian.bamboo.specs.builders.repository.git.SshPrivateKeyAuthentication;
import com.atlassian.bamboo.specs.builders.repository.git.UserPasswordAuthentication;
import com.atlassian.bamboo.specs.model.repository.bitbucket.cloud.BitbucketCloudRepositoryProperties;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.SharedCredentialsAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.SshPrivateKeyAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.UserPasswordAuthenticationProperties;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.export.DefaultVcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class BitbucketCloudImporterExporter
implements VcsRepositoryDataExporter<BitbucketCloudRepository, BitbucketCloudRepositoryProperties> {
    private static final Logger log = Logger.getLogger(BitbucketCloudImporterExporter.class);
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"");
    private final BitbucketApiService bitbucketApiService;
    private final SecretEncryptionService encryptionService;
    private final CredentialsAccessor credentialsAccessor;

    @Autowired
    public BitbucketCloudImporterExporter(BitbucketApiService bitbucketApiService, @BambooImport SecretEncryptionService secretEncryptionService, @BambooImport CredentialsAccessor credentialsAccessor) {
        this.bitbucketApiService = bitbucketApiService;
        this.encryptionService = secretEncryptionService;
        this.credentialsAccessor = credentialsAccessor;
    }

    @NotNull
    public BitbucketCloudRepository getEntityPropertiesBuilder(@NotNull VcsRepositoryData repositoryData) {
        return new BitbucketCloudRepository();
    }

    @NotNull
    public BitbucketCloudRepository appendLocationData(@NotNull BitbucketCloudRepository builder, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        Map cfg = vcsLocationDefinition.getConfiguration();
        switch (BitbucketAccessLevel.valueOf((String)cfg.get("repository.bitbucket.accessLevel"))) {
            case PUBLIC: {
                String repositorySlug = (String)cfg.get("repository.bitbucket.repository");
                String owner = (String)cfg.get("repository.bitbucket.owner");
                builder.repositorySlug(owner, repositorySlug.substring(owner.length() + 1));
                break;
            }
            case PRIVATE: {
                this.appendPrivateAuthenticationData(builder, cfg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not expected BitbucketAccessLevel here: " + (String)cfg.get("repository.bitbucket.accessLevel"));
            }
        }
        try {
            builder.commandTimeoutInMinutes(Integer.parseInt((String)cfg.get("repository.bitbucket.commandTimeout")));
        }
        catch (NumberFormatException ex) {
            log.info((Object)String.format("Can't parse timeout value: %s. Assuming default value of: %s", cfg.get("repository.bitbucket.commandTimeout"), BitbucketCloudRepositoryProperties.DEFAULT_COMMAND_TIMEOUT));
        }
        builder.shallowClonesEnabled(Boolean.parseBoolean(cfg.getOrDefault("repository.bitbucket.git.useShallowClones", String.valueOf(false))));
        builder.remoteAgentCacheEnabled(Boolean.parseBoolean(cfg.getOrDefault("repository.bitbucket.git.useRemoteAgentCache", String.valueOf(false))));
        builder.submodulesEnabled(Boolean.parseBoolean(cfg.getOrDefault("repository.bitbucket.git.useSubmodules", String.valueOf(false))));
        builder.verboseLogs(Boolean.parseBoolean(cfg.getOrDefault("repository.bitbucket.verbose.logs", String.valueOf(false))));
        builder.fetchWholeRepository(Boolean.parseBoolean(cfg.getOrDefault("repository.bitbucket.fetch.whole.repository", String.valueOf(false))));
        builder.lfsEnabled(Boolean.parseBoolean(cfg.getOrDefault("repository.bitbucket.git.lfs", String.valueOf(false))));
        return builder;
    }

    private void appendPrivateAuthenticationData(BitbucketCloudRepository builder, Map<String, String> cfg) {
        BitbucketPasswordCredentialsSource passwordSource = BitbucketPasswordCredentialsSource.valueOf(cfg.get("repository.bitbucket.passwordCredentialsSource"));
        String slug = cfg.get("repository.bitbucket.repository");
        String owner = this.getOwnerFromRepoSlug(slug);
        block0 : switch (passwordSource) {
            case CUSTOM: {
                String username = cfg.get("repository.bitbucket.username");
                String password = this.getEncryptedValue(cfg.get("repository.bitbucket.password"));
                builder.accountAuthentication(new UserPasswordAuthentication(username).password(password));
                builder.repositorySlug(owner, slug.substring(owner.length() + 1));
                break;
            }
            case SHARED_CREDENTIALS: {
                CredentialsData credentials = this.getSharedCredentials(cfg.get("repository.bitbucket.passwordSharedCredentials.id"));
                switch (credentials.getPluginKey()) {
                    case "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials": {
                        builder.accountAuthentication(new SharedCredentialsIdentifier(credentials.getName()));
                        builder.repositorySlug(owner, slug.substring(owner.length() + 1));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Not expected shared credentials type here: " + credentials.getPluginKey());
            }
            default: {
                throw new IllegalArgumentException("Not expected password credential source here: " + cfg.get("repository.bitbucket.passwordCredentialsSource"));
            }
        }
        BitbucketAuthenticationType authType = BitbucketAuthenticationType.valueOf(cfg.get("repository.bitbucket.authenticationType"));
        if (authType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            BitbucketSshCredentialsSource sshSource = BitbucketSshCredentialsSource.valueOf(cfg.get("repository.bitbucket.sshCredentialsSource"));
            block10 : switch (sshSource) {
                case CUSTOM: {
                    SshPrivateKeyAuthentication sshAuth = new SshPrivateKeyAuthentication(this.getEncryptedValue(cfg.get("repository.bitbucket.sshKey")));
                    if (StringUtils.isNotBlank((CharSequence)cfg.get("repository.bitbucket.sshPassphrase"))) {
                        sshAuth.passphrase(this.getEncryptedValue(cfg.get("repository.bitbucket.sshPassphrase")));
                    }
                    builder.checkoutAuthentication(sshAuth);
                    break;
                }
                case SHARED_CREDENTIALS: {
                    CredentialsData credentials = this.getSharedCredentials(cfg.get("repository.bitbucket.sshSharedCredentials.id"));
                    switch (credentials.getPluginKey()) {
                        case "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials": {
                            builder.checkoutAuthentication(new SharedCredentialsIdentifier(credentials.getName()));
                            break block10;
                        }
                    }
                    throw new IllegalArgumentException("Not expected shared credentials type here: " + credentials.getPluginKey());
                }
            }
        }
    }

    @NotNull
    public BitbucketCloudRepository appendBranchData(@NotNull BitbucketCloudRepository builder, @NotNull VcsBranchDefinition vcsBranchDefinition) {
        return builder.branch(vcsBranchDefinition.getVcsBranch().getName());
    }

    @NotNull
    public BitbucketCloudRepository appendChangeDetectionOptions(@NotNull BitbucketCloudRepository builder, @NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        return builder.changeDetection(DefaultVcsRepositoryDataExporter.exportStandardChangeDetectionOptions((VcsChangeDetectionOptions)changeDetectionOptions));
    }

    @NotNull
    public BitbucketCloudRepository appendBranchDetectionOptions(@NotNull BitbucketCloudRepository builder, @NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return builder;
    }

    @Nullable
    public Map<String, String> importLocationData(@NotNull BitbucketCloudRepositoryProperties properties, @Nullable VcsLocationDefinition existingData) {
        if (!properties.hasParent()) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            BitbucketResourceEntity repository = this.getRepository(properties);
            cfg.put("repository.bitbucket.scm", BitbucketRepositoryType.valueOf(repository.getScm().toUpperCase()).name());
            BitbucketAccessLevel accessLevel = this.getAccessLevel(properties);
            cfg.put("repository.bitbucket.accessLevel", accessLevel.name());
            switch (accessLevel) {
                case PUBLIC: {
                    cfg.put("repository.bitbucket.owner", this.getOwnerFromRepoSlug(properties.getRepositorySlug()));
                    cfg.put("repository.bitbucket.authenticationType", BitbucketAuthenticationType.NONE.name());
                    break;
                }
                case PRIVATE: {
                    cfg.putAll(this.getAuthenticationProperties(properties));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't expect BitbucketAccessLevel of type: " + accessLevel.name());
                }
            }
            cfg.put("repository.bitbucket.repository", properties.getRepositorySlug());
            cfg.put("repository.bitbucket.git.useShallowClones", Boolean.toString(properties.isUseShallowClones()));
            cfg.put("repository.bitbucket.git.useRemoteAgentCache", Boolean.toString(properties.isUseRemoteAgentCache()));
            cfg.put("repository.bitbucket.git.useSubmodules", Boolean.toString(properties.isUseSubmodules()));
            cfg.put("repository.bitbucket.commandTimeout", Long.toString(properties.getCommandTimeout().toMinutes()));
            cfg.put("repository.bitbucket.verbose.logs", Boolean.toString(properties.isVerboseLogs()));
            cfg.put("repository.bitbucket.fetch.whole.repository", Boolean.toString(properties.isFetchWholeRepository()));
            cfg.put("repository.bitbucket.git.lfs", Boolean.toString(properties.isUseLfs()));
            return cfg;
        }
        return null;
    }

    private BitbucketAccessLevel getAccessLevel(BitbucketCloudRepositoryProperties repositoryProperties) {
        return repositoryProperties.getAuthenticationProperties() == null ? BitbucketAccessLevel.PUBLIC : BitbucketAccessLevel.PRIVATE;
    }

    private Map<String, String> getAuthenticationProperties(BitbucketCloudRepositoryProperties repositoryProperties) {
        AuthenticationProperties authProperties = repositoryProperties.getAuthenticationProperties();
        AuthenticationProperties checkoutProperties = repositoryProperties.getCheckoutAuthenticationProperties();
        Map<String, String> userPasswordAuthProperties = this.getCheckoutPropertiesFromAccountAuthentication(repositoryProperties, authProperties);
        if (checkoutProperties != null) {
            HashMap<String, String> authPropsMap = new HashMap<String, String>();
            authPropsMap.putAll(userPasswordAuthProperties);
            authPropsMap.putAll(this.getCheckoutPropertiesFromCheckoutAuthentication(checkoutProperties));
            return authPropsMap;
        }
        return userPasswordAuthProperties;
    }

    @NotNull
    private Map<String, String> getCheckoutPropertiesFromCheckoutAuthentication(AuthenticationProperties checkoutProperties) {
        if (checkoutProperties instanceof SshPrivateKeyAuthenticationProperties) {
            SshPrivateKeyAuthenticationProperties sshPrivateKeyProperties = (SshPrivateKeyAuthenticationProperties)checkoutProperties;
            return ImmutableMap.of((Object)"repository.bitbucket.authenticationType", (Object)BitbucketAuthenticationType.SSH_KEYPAIR.name(), (Object)"repository.bitbucket.sshCredentialsSource", (Object)BitbucketSshCredentialsSource.CUSTOM.name(), (Object)"repository.bitbucket.sshKey", (Object)this.getEncryptedValue(sshPrivateKeyProperties.getSshPrivateKey()), (Object)"repository.bitbucket.sshPassphrase", (Object)this.getEncryptedValue(sshPrivateKeyProperties.getPassphrase()));
        }
        if (checkoutProperties instanceof SharedCredentialsAuthenticationProperties) {
            CredentialsData sharedCredentials = this.getSharedCredentials((SharedCredentialsAuthenticationProperties)checkoutProperties);
            switch (sharedCredentials.getPluginKey()) {
                case "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials": {
                    return ImmutableMap.of((Object)"repository.bitbucket.authenticationType", (Object)BitbucketAuthenticationType.SSH_KEYPAIR.name(), (Object)"repository.bitbucket.sshCredentialsSource", (Object)BitbucketSshCredentialsSource.SHARED_CREDENTIALS.name(), (Object)"repository.bitbucket.sshSharedCredentials.id", (Object)String.valueOf(sharedCredentials.getId()));
                }
            }
            throw new PropertiesValidationException(VALIDATION_CONTEXT, String.format("Only %s type of shared credentials is available for repository checkout. You used %s", "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials", sharedCredentials.getPluginKey()));
        }
        throw new PropertiesValidationException(VALIDATION_CONTEXT, "Can't use checkout authentication of type: " + checkoutProperties.getClass().getSimpleName());
    }

    @NotNull
    private Map<String, String> getCheckoutPropertiesFromAccountAuthentication(BitbucketCloudRepositoryProperties repositoryProperties, AuthenticationProperties authProperties) {
        if (authProperties instanceof UserPasswordAuthenticationProperties) {
            UserPasswordAuthenticationProperties userAuth = (UserPasswordAuthenticationProperties)authProperties;
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)userAuth.getPassword(), (String)"user password");
            String encryptedPassword = this.getEncryptedValue(userAuth.getPassword());
            return ImmutableMap.of((Object)"repository.bitbucket.authenticationType", (Object)BitbucketAuthenticationType.PASSWORD.name(), (Object)"repository.bitbucket.passwordCredentialsSource", (Object)BitbucketPasswordCredentialsSource.CUSTOM.name(), (Object)"repository.bitbucket.username", (Object)userAuth.getUsername(), (Object)"repository.bitbucket.password", (Object)encryptedPassword);
        }
        if (authProperties instanceof SharedCredentialsAuthenticationProperties) {
            CredentialsData credentials = this.getSharedCredentials((SharedCredentialsAuthenticationProperties)repositoryProperties.getAuthenticationProperties());
            switch (credentials.getPluginKey()) {
                case "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials": {
                    return ImmutableMap.of((Object)"repository.bitbucket.authenticationType", (Object)BitbucketAuthenticationType.PASSWORD.name(), (Object)"repository.bitbucket.passwordCredentialsSource", (Object)BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS.name(), (Object)"repository.bitbucket.passwordSharedCredentials.id", (Object)String.valueOf(credentials.getId()));
                }
            }
            throw new PropertiesValidationException(VALIDATION_CONTEXT, "Unsupported shared credentials type " + credentials.getPluginKey());
        }
        throw new PropertiesValidationException(VALIDATION_CONTEXT, "Can't set access level. Didn't expect here authentication type of " + authProperties.getClass().getSimpleName());
    }

    @NotNull
    private BitbucketResourceEntity getRepository(BitbucketCloudRepositoryProperties repositoryProperties) {
        try {
            List<BitbucketResourceEntity> repositories = this.getBitbucketCloudRepositories(repositoryProperties);
            Optional<BitbucketResourceEntity> maybeRepository = repositories.stream().filter(entity -> entity.getId().equals(repositoryProperties.getRepositorySlug())).findFirst();
            if (!maybeRepository.isPresent()) {
                if (repositories.isEmpty()) {
                    throw new PropertiesValidationException(VALIDATION_CONTEXT, String.format("Can't find any repository matching %s.", repositoryProperties.getRepositorySlug()));
                }
                List possibleRepositories = repositories.stream().map(BitbucketResourceEntity::getId).collect(Collectors.toList());
                throw new PropertiesValidationException(VALIDATION_CONTEXT, String.format("Can't find %s repository. Available options are: %s", repositoryProperties.getRepositorySlug(), possibleRepositories));
            }
            return maybeRepository.get();
        }
        catch (BitbucketApiException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    private List<BitbucketResourceEntity> getBitbucketCloudRepositories(BitbucketCloudRepositoryProperties repositoryProperties) throws BitbucketApiException {
        AuthenticationProperties authProperties = repositoryProperties.getAuthenticationProperties();
        String slug = repositoryProperties.getRepositorySlug();
        if (authProperties == null) {
            return this.bitbucketApiService.getPublicRepositories(this.getOwnerFromRepoSlug(slug), this.getRepositoryNameFromSlug(slug));
        }
        if (authProperties instanceof UserPasswordAuthenticationProperties) {
            UserPasswordAuthenticationProperties userAuthentication = (UserPasswordAuthenticationProperties)authProperties;
            String decryptedPassword = this.getDecryptedValue(userAuthentication.getPassword());
            return this.bitbucketApiService.getRepositories(userAuthentication.getUsername(), decryptedPassword, slug);
        }
        if (authProperties instanceof SharedCredentialsAuthenticationProperties) {
            CredentialsData credentials = this.getSharedCredentials((SharedCredentialsAuthenticationProperties)authProperties);
            switch (credentials.getPluginKey()) {
                case "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials": {
                    String username = (String)credentials.getConfiguration().get("username");
                    String password = (String)credentials.getConfiguration().get("password");
                    ImporterUtils.checkThat((ValidationContext)VALIDATION_CONTEXT, (boolean)StringUtils.isNotBlank((CharSequence)password), (String)"Shared credentials password must not be empty. Use UsernamePasswordCredentials if repository access is public.", (Object[])new Object[0]);
                    return this.bitbucketApiService.getRepositories(username, password, slug);
                }
            }
            throw new PropertiesValidationException(VALIDATION_CONTEXT, "Unsupported shared credentials type " + credentials.getPluginKey());
        }
        throw new PropertiesValidationException(VALIDATION_CONTEXT, "Can't import repository. Can't handle authentication properties of: " + authProperties.getClass().getSimpleName());
    }

    @NotNull
    private String getOwnerFromRepoSlug(String slug) {
        return slug.substring(0, slug.indexOf(47));
    }

    @NotNull
    private String getRepositoryNameFromSlug(String slug) {
        return slug.substring(slug.indexOf(47) + 1);
    }

    @NotNull
    private CredentialsData getSharedCredentials(SharedCredentialsAuthenticationProperties authProperties) {
        SharedCredentialsIdentifierProperties sharedCredentials = authProperties.getSharedCredentials();
        CredentialsData credentials = this.credentialsAccessor.getCredentialsByName(sharedCredentials.getName());
        ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (credentials != null ? 1 : 0) != 0, (Object)("Can't find shared credentials by name: " + sharedCredentials.getName()));
        return credentials;
    }

    @NotNull
    private CredentialsData getSharedCredentials(String sharedCredentialsId) {
        try {
            CredentialsData credentials = this.credentialsAccessor.getCredentials(Long.parseLong(sharedCredentialsId));
            if (credentials == null) {
                throw new IllegalArgumentException("Can't find shared credentials by id: " + sharedCredentialsId);
            }
            return credentials;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Can't find shared credentials by id: " + sharedCredentialsId);
        }
    }

    @Nullable
    public Map<String, String> importBranchData(@NotNull BitbucketCloudRepositoryProperties repositoryProperties, @Nullable VcsBranchDefinition existingData) {
        if (!repositoryProperties.hasParent() || repositoryProperties.getBranch() != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            cfg.put("repository.bitbucket.branch", repositoryProperties.getBranch());
            return cfg;
        }
        return null;
    }

    @Nullable
    public Map<String, String> importChangeDetectionOptions(@NotNull BitbucketCloudRepositoryProperties repositoryProperties, @Nullable VcsChangeDetectionOptions existingData) {
        return DefaultVcsRepositoryDataExporter.importStandardChangeDetectionOptions((VcsRepositoryProperties)repositoryProperties, (VcsChangeDetectionProperties)repositoryProperties.getVcsChangeDetection());
    }

    @Nullable
    public Map<String, String> importBranchDetectionOptions(@NotNull BitbucketCloudRepositoryProperties repositoryProperties, @Nullable VcsBranchDetectionOptions existingData) {
        return null;
    }

    private String getEncryptedValue(String value) {
        return this.encryptionService.isEncrypted(value) ? value : this.encryptionService.encrypt(value);
    }

    private String getDecryptedValue(String value) {
        return this.encryptionService.isEncrypted(value) ? this.encryptionService.decrypt(value) : value;
    }
}

