/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.SshCredentialsImpl;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketApiAccessor;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAuthenticationType;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketSshCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryType;
import com.atlassian.bamboo.plugins.hg.HgRepository;
import com.atlassian.bamboo.plugins.hg.configuration.HgRepositoryFields;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsType;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudServerConfigurator
implements VcsLocationConfigurator {
    private static final Logger log = Logger.getLogger(BitbucketCloudServerConfigurator.class);
    @Inject
    private I18nResolver i18nResolver;
    @Inject
    private CredentialsAccessor credentialsAccessor;
    private final Function<String, String> getUuidForEmailFunction;
    private static final String ACCESS_LEVELS = "bbCloudAccessLevels";
    private static final String PASSWORD_CREDENTIAL_SOURCES = "bbCloudPasswordCredentialSources";
    private static final String SSH_CREDENTIAL_SOURCES = "bbCloudSshCredentialSources";
    private static final String PASSWORD_SHARED_CREDENTIALS = "bbCloudPasswordSharedCredentials";
    private static final String SSH_SHARED_CREDENTIALS = "bbCloudSshSharedCredentials";
    private static final String PRIVATE_REPO_AUTH_TYPES = "bbCloudPrivateRepositoryAuthenticationTypes";

    public BitbucketCloudServerConfigurator() {
        this.getUuidForEmailFunction = BitbucketApiAccessor::getUuidForAnEmailOrUsername;
    }

    @VisibleForTesting
    protected BitbucketCloudServerConfigurator(Function<String, String> getUuidForEmailFunction) {
        this.getUuidForEmailFunction = getUuidForEmailFunction;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        context.put("repository.bitbucket.commandTimeout", String.valueOf(HgRepositoryFields.DEFAULT_COMMAND_TIMEOUT.toMinutes()));
        context.put("repository.bitbucket.accessLevel", BitbucketAccessLevel.PRIVATE.name());
        context.put("repository.bitbucket.passwordCredentialsSource", this.getDefaultPasswordCredentialsSource().name());
        context.put("repository.bitbucket.sshCredentialsSource", this.getDefaultSshCredentialsSource().name());
        context.put("repository.bitbucket.authenticationType", BitbucketAuthenticationType.SSH_KEYPAIR.name());
        this.populateUiElements(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
    }

    private void populateContextCommon(Map<String, Object> context, VcsLocationDefinition vcsLocationDefinition) {
        Map cfg = vcsLocationDefinition.getConfiguration();
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf((String)cfg.get("repository.bitbucket.authenticationType"));
        context.put("repository.bitbucket.authenticationType", authenticationType.name());
        BitbucketAccessLevel accessLevel = BitbucketAccessLevel.valueOf((String)cfg.get("repository.bitbucket.accessLevel"));
        context.put("repository.bitbucket.accessLevel", accessLevel.name());
        if (accessLevel == BitbucketAccessLevel.PRIVATE || authenticationType == BitbucketAuthenticationType.PASSWORD) {
            BitbucketPasswordCredentialsSource passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf((String)cfg.get("repository.bitbucket.passwordCredentialsSource"));
            context.put("repository.bitbucket.passwordCredentialsSource", passwordCredentialsSource.name());
            if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                Long passwordSharedCredentialsId = Long.parseLong((String)cfg.get("repository.bitbucket.passwordSharedCredentials.id"));
                context.put("repository.bitbucket.passwordSharedCredentials.id", passwordSharedCredentialsId);
                if (!this.credentialExists(passwordSharedCredentialsId)) {
                    context.put("repository.bitbucket.passwordSharedCredentials.deleted", true);
                }
            } else {
                context.put("repository.bitbucket.username", cfg.get("repository.bitbucket.username"));
                this.putDummyIfValueIsNotBlank(context, cfg, "repository.bitbucket.password");
            }
        } else {
            context.put("repository.bitbucket.owner", cfg.get("repository.bitbucket.owner"));
        }
        if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            BitbucketSshCredentialsSource sshCredentialsSource = BitbucketSshCredentialsSource.valueOf((String)cfg.get("repository.bitbucket.sshCredentialsSource"));
            context.put("repository.bitbucket.sshCredentialsSource", sshCredentialsSource.name());
            if (sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                Long sshSharedCredentialsId = Long.parseLong((String)cfg.get("repository.bitbucket.sshSharedCredentials.id"));
                context.put("repository.bitbucket.sshSharedCredentials.id", sshSharedCredentialsId);
                if (!this.credentialExists(sshSharedCredentialsId)) {
                    context.put("repository.bitbucket.sshSharedCredentials.deleted", true);
                }
            } else {
                this.putDummyIfValueIsNotBlank(context, cfg, "repository.bitbucket.sshKey");
                this.putDummyIfValueIsNotBlank(context, cfg, "repository.bitbucket.sshPassphrase");
            }
        }
        context.put("repository.bitbucket.repository", cfg.get("repository.bitbucket.repository"));
        context.put("repository.bitbucket.scm", cfg.get("repository.bitbucket.scm"));
        context.put("repository.bitbucket.commandTimeout", Integer.parseInt((String)cfg.get("repository.bitbucket.commandTimeout")));
        context.put("repository.bitbucket.verbose.logs", Boolean.valueOf((String)cfg.get("repository.bitbucket.verbose.logs")));
        context.put("repository.bitbucket.fetch.whole.repository", Boolean.valueOf((String)cfg.get("repository.bitbucket.fetch.whole.repository")));
        context.put("repository.bitbucket.git.useShallowClones", Boolean.valueOf((String)cfg.get("repository.bitbucket.git.useShallowClones")));
        context.put("repository.bitbucket.git.useSubmodules", Boolean.valueOf((String)cfg.get("repository.bitbucket.git.useSubmodules")));
        context.put("repository.bitbucket.git.lfs", Boolean.valueOf((String)cfg.get("repository.bitbucket.git.lfs")));
        context.put("repository.bitbucket.git.useRemoteAgentCache", Boolean.valueOf((String)cfg.get("repository.bitbucket.git.useRemoteAgentCache")));
        context.computeIfAbsent("repository.bitbucket.passwordCredentialsSource", key -> this.getDefaultPasswordCredentialsSource().name());
        context.computeIfAbsent("repository.bitbucket.sshCredentialsSource", key -> this.getDefaultSshCredentialsSource().name());
        this.populateUiElements(context);
    }

    private void putDummyIfValueIsNotBlank(@NotNull Map<String, Object> context, @NotNull Map<String, String> cfg, String key) {
        if (StringUtils.isNotBlank((CharSequence)cfg.get(key))) {
            context.put(key, "dummy");
        }
    }

    private boolean credentialExists(long credentialId) {
        return this.credentialsAccessor.getCredentials(credentialId) != null;
    }

    private void populateUiElements(@NotNull Map<String, Object> context) {
        context.put(ACCESS_LEVELS, Arrays.stream(BitbucketAccessLevel.values()).map(Enum::name).map(accessLevel -> new NameValuePair(this.getAccessLevelName((String)accessLevel), this.getAccessLevelDescription((String)accessLevel), accessLevel)).collect(Collectors.toList()));
        context.put(PASSWORD_CREDENTIAL_SOURCES, Arrays.stream(BitbucketPasswordCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getPasswordCredentialsSourceName((String)name))).collect(Collectors.toList()));
        context.put(SSH_CREDENTIAL_SOURCES, Arrays.stream(BitbucketSshCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getSshCredentialsSourceName((String)name))).collect(Collectors.toList()));
        context.put(PRIVATE_REPO_AUTH_TYPES, Arrays.stream(BitbucketAuthenticationType.values()).filter(authenticationType -> authenticationType != BitbucketAuthenticationType.NONE).map(Enum::name).map(name -> new NameValuePair(name, this.getAuthenticationTypeName((String)name))).collect(Collectors.toList()));
        context.put(PASSWORD_SHARED_CREDENTIALS, this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials"));
        context.put(SSH_SHARED_CREDENTIALS, this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials"));
    }

    private String getAuthenticationTypeName(String authenticationType) {
        return this.i18nResolver.getText("repository.bitbucket.authenticationType." + StringUtils.lowerCase((String)authenticationType));
    }

    @NotNull
    private List<NameValuePair> getSharedCredentials(String pluginKey) {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials(pluginKey)).map(credentials -> new NameValuePair(Long.toString(credentials.getId()), credentials.getName())).collect(Collectors.toList());
    }

    @NotNull
    private String getAccessLevelName(String accessLevel) {
        return this.i18nResolver.getText("repository.bitbucket.accessLevel." + StringUtils.lowerCase((String)accessLevel));
    }

    @NotNull
    private String getAccessLevelDescription(String accessLevel) {
        return this.i18nResolver.getText("repository.bitbucket.accessLevel." + StringUtils.lowerCase((String)accessLevel) + ".description");
    }

    @NotNull
    private String getPasswordCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.bitbucket.passwordCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    @NotNull
    private String getSshCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.bitbucket.sshCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    private BitbucketSshCredentialsSource getDefaultSshCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials") ? BitbucketSshCredentialsSource.SHARED_CREDENTIALS : BitbucketSshCredentialsSource.CUSTOM;
    }

    private BitbucketPasswordCredentialsSource getDefaultPasswordCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials") ? BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS : BitbucketPasswordCredentialsSource.CUSTOM;
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition, @NotNull ErrorCollection errorCollection) {
        BitbucketAuthenticationType authenticationType;
        BitbucketAccessLevel accessLevel;
        this.validateAccessLevel(errorCollection, actionParametersMap.getString("repository.bitbucket.accessLevel", ""));
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.validateAuthenticationType(errorCollection, accessLevel, (accessLevel = BitbucketAccessLevel.valueOf(actionParametersMap.getString("repository.bitbucket.accessLevel"))) == BitbucketAccessLevel.PUBLIC ? BitbucketAuthenticationType.NONE.name() : actionParametersMap.getString("repository.bitbucket.authenticationType", ""));
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        BitbucketAuthenticationType bitbucketAuthenticationType = authenticationType = accessLevel != BitbucketAccessLevel.PUBLIC ? BitbucketAuthenticationType.valueOf(actionParametersMap.getString("repository.bitbucket.authenticationType")) : BitbucketAuthenticationType.NONE;
        if (accessLevel == BitbucketAccessLevel.PUBLIC) {
            this.validateUsername(errorCollection, "repository.bitbucket.owner", actionParametersMap.getString("repository.bitbucket.owner", ""), "repository.bitbucket.owner.error.empty");
        }
        if (accessLevel == BitbucketAccessLevel.PRIVATE || authenticationType == BitbucketAuthenticationType.PASSWORD) {
            this.validateUsernamePasswordCredentials(errorCollection, previousVcsLocationDefinition, actionParametersMap);
        }
        if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            this.validateSshCredentials(errorCollection, previousVcsLocationDefinition, actionParametersMap);
        }
        this.validateRepository(errorCollection, actionParametersMap.getString("repository.bitbucket.repository", ""));
    }

    public void validateForConnectionTesting(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition, @NotNull ErrorCollection errorCollection) {
        boolean requiresSshKeyFileTransfer;
        boolean bl = requiresSshKeyFileTransfer = BitbucketAuthenticationType.SSH_KEYPAIR.name().equals(actionParametersMap.getString("repository.bitbucket.authenticationType", "")) && BitbucketSshCredentialsSource.CUSTOM.name().equals(actionParametersMap.getString("repository.bitbucket.sshCredentialsSource", "")) && actionParametersMap.getBoolean("repository.bitbucket.temporary.sshKeyChange") && !actionParametersMap.getString("repository.bitbucket.accessLevel", "").equals(BitbucketAccessLevel.PUBLIC.name());
        if (requiresSshKeyFileTransfer) {
            errorCollection.addError("repository.bitbucket.temporary.sshKeyFile", this.i18nResolver.getText("repository.test.connection.private.key.not.received"));
        } else {
            this.validate(actionParametersMap, previousVcsLocationDefinition, errorCollection);
        }
    }

    private void validateAccessLevel(@NotNull ErrorCollection errorCollection, @Nullable String accessLevel) {
        if (StringUtils.isEmpty((CharSequence)accessLevel)) {
            errorCollection.addError("repository.bitbucket.accessLevel", this.i18nResolver.getText("repository.bitbucket.accessLevel.error.empty"));
        } else if (Arrays.stream(BitbucketAccessLevel.values()).map(Enum::name).noneMatch(accessLevel::equals)) {
            errorCollection.addError("repository.bitbucket.accessLevel", this.i18nResolver.getText("repository.bitbucket.accessLevel.error.unknown", new Serializable[]{accessLevel}));
        }
    }

    @VisibleForTesting
    void validateAuthenticationType(@NotNull ErrorCollection errorCollection, @NotNull BitbucketAccessLevel accessLevel, @Nullable String authenticationType) {
        if (StringUtils.isEmpty((CharSequence)authenticationType)) {
            errorCollection.addError("repository.bitbucket.authenticationType", this.i18nResolver.getText("repository.bitbucket.authenticationType.error.empty"));
        } else if (accessLevel.getSupportedAuthenticationTypes().stream().map(Enum::name).noneMatch(authenticationType::equals)) {
            errorCollection.addError("repository.bitbucket.authenticationType", this.i18nResolver.getText("repository.bitbucket.authenticationType.error.unknown", new Serializable[]{authenticationType}));
        }
    }

    @VisibleForTesting
    void validateUsernamePasswordCredentials(@NotNull ErrorCollection errorCollection, @Nullable VcsLocationDefinition previousLocationDefinition, @NotNull ActionParametersMap actionParametersMap) {
        String passwordCredentialsSourceString = actionParametersMap.getString("repository.bitbucket.passwordCredentialsSource", "");
        if (StringUtils.isEmpty((CharSequence)passwordCredentialsSourceString)) {
            errorCollection.addError("repository.bitbucket.passwordCredentialsSource", this.i18nResolver.getText("repository.bitbucket.passwordCredentialsSource.error.empty"));
        } else if (Arrays.stream(BitbucketPasswordCredentialsSource.values()).map(Enum::name).noneMatch(passwordCredentialsSourceString::equals)) {
            errorCollection.addError("repository.bitbucket.passwordCredentialsSource", this.i18nResolver.getText("repository.bitbucket.passwordCredentialsSource.error.unknown", new Serializable[]{passwordCredentialsSourceString}));
        } else {
            String password;
            String username;
            BitbucketPasswordCredentialsSource passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf(passwordCredentialsSourceString);
            if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                Long passwordSharedCredentialsId = actionParametersMap.getLong("repository.bitbucket.passwordSharedCredentials.id", -1L);
                if (passwordSharedCredentialsId == -1L) {
                    errorCollection.addErrorMessage(this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.empty"));
                    return;
                }
                CredentialsData credentials = this.credentialsAccessor.getCredentials(passwordSharedCredentialsId.longValue());
                if (credentials == null) {
                    errorCollection.addError("repository.bitbucket.passwordSharedCredentials.id", this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.notFound"));
                    return;
                }
                UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentials);
                username = passwordCredentials.getUsername();
                password = passwordCredentials.getPassword();
            } else {
                username = actionParametersMap.getString("repository.bitbucket.username");
                String string = password = previousLocationDefinition != null ? (String)previousLocationDefinition.getConfiguration().get("repository.bitbucket.password") : "";
                if (actionParametersMap.getBoolean("repository.bitbucket.password.change")) {
                    password = actionParametersMap.getString("repository.bitbucket.temporary.password");
                }
            }
            this.validateUsername(errorCollection, "repository.bitbucket.username", username, "repository.bitbucket.username.error.empty");
            if (StringUtils.isEmpty((CharSequence)password)) {
                String errorMessage = this.i18nResolver.getText("repository.bitbucket.password.error.empty");
                if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                    errorCollection.addErrorMessage(errorMessage);
                } else {
                    errorCollection.addError("repository.bitbucket.temporary.password", errorMessage);
                }
            }
        }
    }

    @VisibleForTesting
    void validateSshCredentials(@NotNull ErrorCollection errorCollection, @Nullable VcsLocationDefinition previousLocationDefinition, @NotNull ActionParametersMap actionParametersMap) {
        String sshCredentialsSourceString = actionParametersMap.getString("repository.bitbucket.sshCredentialsSource", "");
        if (StringUtils.isEmpty((CharSequence)sshCredentialsSourceString)) {
            errorCollection.addErrorMessage(this.i18nResolver.getText("repository.bitbucket.sshCredentialsSource.error.empty"));
        } else if (Arrays.stream(BitbucketSshCredentialsSource.values()).map(Enum::name).noneMatch(sshCredentialsSourceString::equals)) {
            errorCollection.addError("repository.bitbucket.sshCredentialsSource", this.i18nResolver.getText("repository.bitbucket.sshCredentialsSource.error.unknown", new Serializable[]{sshCredentialsSourceString}));
        } else {
            String sshPrivateKey;
            BitbucketSshCredentialsSource sshCredentialsSource = BitbucketSshCredentialsSource.valueOf(sshCredentialsSourceString);
            if (sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                Long sshSharedCredentialsId = actionParametersMap.getLong("repository.bitbucket.sshSharedCredentials.id", -1L);
                if (sshSharedCredentialsId == -1L) {
                    errorCollection.addErrorMessage(this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.empty"));
                    return;
                }
                CredentialsData credentials = this.credentialsAccessor.getCredentials(sshSharedCredentialsId.longValue());
                if (credentials == null) {
                    errorCollection.addError("repository.bitbucket.sshSharedCredentials.id", this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.notFound"));
                    return;
                }
                SshCredentialsImpl privateKeyCredentials = new SshCredentialsImpl(credentials);
                sshPrivateKey = privateKeyCredentials.getKey();
            } else {
                Object o;
                String string = sshPrivateKey = previousLocationDefinition != null ? (String)previousLocationDefinition.getConfiguration().get("repository.bitbucket.sshKey") : null;
                if (actionParametersMap.getBoolean("repository.bitbucket.temporary.sshKeyChange") && (o = actionParametersMap.getFiles().get("repository.bitbucket.temporary.sshKeyFile")) instanceof File) {
                    try {
                        sshPrivateKey = FileUtils.readFileToString((File)((File)o));
                    }
                    catch (IOException e) {
                        log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)sshPrivateKey)) {
                String errorMessage = this.i18nResolver.getText("repository.bitbucket.sshKey.error.empty");
                if (sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                    errorCollection.addErrorMessage(errorMessage);
                } else {
                    errorCollection.addError("repository.bitbucket.temporary.sshKeyFile", errorMessage);
                }
            }
        }
    }

    private void validateUsername(@NotNull ErrorCollection errorCollection, @NotNull String usernameField, @Nullable String username, @NotNull String emptyErrorMessageKey) {
        String uuid;
        if (StringUtils.isEmpty((CharSequence)username)) {
            errorCollection.addError(usernameField, this.i18nResolver.getText(emptyErrorMessageKey));
        } else if (!BambooFieldValidate.findFieldRelaxedXssViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)usernameField, (String)username) && (uuid = this.getUuidForEmailFunction.apply(username)) == null) {
            errorCollection.addError(usernameField, this.i18nResolver.getText("repository.bitbucket.error.invalidUsername"));
        }
    }

    private void validateRepository(@NotNull ErrorCollection errorCollection, @Nullable String repository) {
        if (StringUtils.isBlank((CharSequence)repository)) {
            errorCollection.addError("repository.bitbucket.repository", this.i18nResolver.getText("repository.bitbucket.error.missingRepository"));
        } else {
            BambooFieldValidate.findFieldRelaxedXssViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.bitbucket.repository", (String)repository);
        }
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition) {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        if (previousVcsLocationDefinition != null) {
            cfgMap.putAll(previousVcsLocationDefinition.getConfiguration());
        }
        cfgMap.put("repository.bitbucket.repository", actionParametersMap.getString("repository.bitbucket.repository"));
        cfgMap.put("repository.bitbucket.scm", actionParametersMap.getString("repository.bitbucket.scm"));
        cfgMap.put("repository.bitbucket.commandTimeout", actionParametersMap.getString("repository.bitbucket.commandTimeout", Long.toString(HgRepository.DEFAULT_COMMAND_TIMEOUT.toMinutes())));
        cfgMap.put("repository.bitbucket.verbose.logs", Boolean.toString(actionParametersMap.getBoolean("repository.bitbucket.verbose.logs")));
        cfgMap.put("repository.bitbucket.fetch.whole.repository", Boolean.toString(actionParametersMap.getBoolean("repository.bitbucket.fetch.whole.repository")));
        cfgMap.put("repository.bitbucket.git.useShallowClones", Boolean.toString(actionParametersMap.getBoolean("repository.bitbucket.git.useShallowClones")));
        cfgMap.put("repository.bitbucket.git.lfs", Boolean.toString(actionParametersMap.getBoolean("repository.bitbucket.git.lfs")));
        cfgMap.put("repository.bitbucket.git.useSubmodules", Boolean.toString(actionParametersMap.getBoolean("repository.bitbucket.git.useSubmodules")));
        cfgMap.put("repository.bitbucket.git.useRemoteAgentCache", Boolean.toString(actionParametersMap.getBoolean("repository.bitbucket.git.useRemoteAgentCache")));
        BitbucketAccessLevel accessLevel = BitbucketAccessLevel.valueOf(actionParametersMap.getString("repository.bitbucket.accessLevel"));
        cfgMap.put("repository.bitbucket.accessLevel", accessLevel.name());
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.NONE;
        if (BitbucketAccessLevel.PUBLIC != accessLevel) {
            authenticationType = BitbucketAuthenticationType.valueOf(actionParametersMap.getString("repository.bitbucket.authenticationType"));
        }
        cfgMap.put("repository.bitbucket.authenticationType", authenticationType.name());
        if (accessLevel == BitbucketAccessLevel.PRIVATE || authenticationType == BitbucketAuthenticationType.PASSWORD) {
            if (accessLevel == BitbucketAccessLevel.PRIVATE) {
                this.removeOwner(cfgMap);
            }
            if (authenticationType == BitbucketAuthenticationType.PASSWORD) {
                this.removeSshCredentials(cfgMap);
            }
            BitbucketPasswordCredentialsSource passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf(actionParametersMap.getString("repository.bitbucket.passwordCredentialsSource"));
            cfgMap.put("repository.bitbucket.passwordCredentialsSource", passwordCredentialsSource.name());
            if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                Long passwordSharedCredentialsId = actionParametersMap.getLong("repository.bitbucket.passwordSharedCredentials.id", -1L);
                cfgMap.put("repository.bitbucket.passwordSharedCredentials.id", Long.toString(passwordSharedCredentialsId));
                cfgMap.remove("repository.bitbucket.username");
                cfgMap.remove("repository.bitbucket.password");
            } else {
                cfgMap.put("repository.bitbucket.username", actionParametersMap.getString("repository.bitbucket.username", ""));
                if (actionParametersMap.getBoolean("repository.bitbucket.password.change")) {
                    cfgMap.put("repository.bitbucket.password", actionParametersMap.getString("repository.bitbucket.temporary.password"));
                }
                cfgMap.remove("repository.bitbucket.passwordSharedCredentials.id");
            }
        } else {
            cfgMap.put("repository.bitbucket.owner", actionParametersMap.getString("repository.bitbucket.owner", ""));
            this.removePasswordCredentials(cfgMap);
        }
        if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            if (accessLevel == BitbucketAccessLevel.PRIVATE) {
                this.removeOwner(cfgMap);
            } else {
                this.removePasswordCredentials(cfgMap);
            }
            BitbucketSshCredentialsSource sshCredentialsSource = BitbucketSshCredentialsSource.valueOf(actionParametersMap.getString("repository.bitbucket.sshCredentialsSource"));
            cfgMap.put("repository.bitbucket.sshCredentialsSource", sshCredentialsSource.name());
            if (sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                Long sshSharedCredentialsId = actionParametersMap.getLong("repository.bitbucket.sshSharedCredentials.id", -1L);
                cfgMap.put("repository.bitbucket.sshSharedCredentials.id", Long.toString(sshSharedCredentialsId));
                cfgMap.remove("repository.bitbucket.sshKey");
                cfgMap.remove("repository.bitbucket.sshPassphrase");
            } else {
                cfgMap.remove("repository.bitbucket.sshSharedCredentials.id");
                if (actionParametersMap.getBoolean("repository.bitbucket.temporary.sshPassphraseChange")) {
                    cfgMap.put("repository.bitbucket.sshPassphrase", actionParametersMap.getString("repository.bitbucket.temporary.sshPassphrase"));
                }
                if (actionParametersMap.getBoolean("repository.bitbucket.temporary.sshKeyChange")) {
                    Object o = actionParametersMap.getFiles().get("repository.bitbucket.temporary.sshKeyFile");
                    if (o instanceof File) {
                        try {
                            cfgMap.put("repository.bitbucket.sshKey", FileUtils.readFileToString((File)((File)o)));
                        }
                        catch (IOException e) {
                            log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                        }
                    } else {
                        cfgMap.remove("repository.bitbucket.sshKey");
                    }
                }
            }
        }
        return cfgMap;
    }

    private void removeOwner(@NotNull Map<String, String> cfgMap) {
        cfgMap.remove("repository.bitbucket.owner");
    }

    private void removePasswordCredentials(@NotNull Map<String, String> cfgMap) {
        cfgMap.remove("repository.bitbucket.passwordSharedCredentials.id");
        cfgMap.remove("repository.bitbucket.passwordCredentialsSource");
        cfgMap.remove("repository.bitbucket.password");
        cfgMap.remove("repository.bitbucket.username");
    }

    private void removeSshCredentials(@NotNull Map<String, String> cfgMap) {
        cfgMap.remove("repository.bitbucket.sshSharedCredentials.id");
        cfgMap.remove("repository.bitbucket.sshCredentialsSource");
        cfgMap.remove("repository.bitbucket.sshPassphrase");
        cfgMap.remove("repository.bitbucket.sshKey");
    }

    public void addDefaultsForAdvancedOptions(@NotNull Map<String, String> cfgMap) {
        cfgMap.put("repository.bitbucket.commandTimeout", String.valueOf(HgRepositoryFields.DEFAULT_COMMAND_TIMEOUT.toMinutes()));
    }

    @NotNull
    public String getServerHost(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        try {
            return new URL(BitbucketProperty.BITBUCKET_BASE_URL).getHost();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public String getLocationIdentifier(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return BitbucketProperty.BITBUCKET_BASE_URL + (String)vcsLocationDefinition.getConfiguration().get("repository.bitbucket.repository");
    }

    @NotNull
    public Iterable<Long> getSharedCredentialsIds(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        String sshSharedCredentialsIdString;
        HashSet<Long> sharedCredentials = new HashSet<Long>();
        String passwordSharedCredentialsIdString = (String)vcsLocationDefinition.getConfiguration().get("repository.bitbucket.passwordSharedCredentials.id");
        if (StringUtils.isNotBlank((CharSequence)passwordSharedCredentialsIdString)) {
            sharedCredentials.add(Long.parseLong(passwordSharedCredentialsIdString));
        }
        if (StringUtils.isNotBlank((CharSequence)(sshSharedCredentialsIdString = (String)vcsLocationDefinition.getConfiguration().get("repository.bitbucket.sshSharedCredentials.id")))) {
            sharedCredentials.add(Long.parseLong(sshSharedCredentialsIdString));
        }
        return sharedCredentials;
    }

    public Optional<VcsType> getScmType(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        String scm = (String)vcsLocationDefinition.getConfiguration().get("repository.bitbucket.scm");
        BitbucketRepositoryType type = BitbucketRepositoryType.valueOf(scm);
        switch (type) {
            case GIT: {
                return Optional.of(VcsType.GIT);
            }
            case HG: {
                return Optional.of(VcsType.HG);
            }
        }
        throw new IllegalStateException("Bitbucket cloud repository that is neither git nor mercurial");
    }

    @Deprecated
    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Deprecated
    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

