/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryType;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudBranchConfigurator
implements VcsBranchConfigurator {
    @Inject
    private I18nResolver i18nResolver;
    @Inject
    private CustomVariableContext customVariableContext;

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition branchDefinition) {
        context.put("repository.bitbucket.branch", branchDefinition.getConfiguration().get("repository.bitbucket.branch"));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition branchDefinition) {
        context.put("repository.bitbucket.branch", branchDefinition.getConfiguration().get("repository.bitbucket.branch"));
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @NotNull ErrorCollection errorCollection) {
        if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.bitbucket.branch", (String)this.substituteString(actionParametersMap.getString("repository.bitbucket.branch")))) {
            return;
        }
    }

    private String substituteString(@Nullable String stringWithValuesToSubstitute) {
        return this.customVariableContext.substituteString(stringWithValuesToSubstitute);
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsBranchDefinition previousBranchDefinition, @NotNull Map<String, String> serverConfiguration) {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        String branch = actionParametersMap.getString("repository.bitbucket.branch", "").trim();
        if (StringUtils.isBlank((CharSequence)branch)) {
            BitbucketRepositoryType type = BitbucketRepositoryType.valueOf(serverConfiguration.get("repository.bitbucket.scm"));
            switch (type) {
                case GIT: {
                    branch = "master";
                    break;
                }
                case HG: {
                    branch = "default";
                }
            }
        }
        cfgMap.put("repository.bitbucket.branch", branch);
        return cfgMap;
    }

    @NotNull
    public VcsBranch getVcsBranchFromConfig(@NotNull Map<String, String> configMap) {
        return new VcsBranchImpl(configMap.get("repository.bitbucket.branch"));
    }

    @NotNull
    public Map<String, String> setVcsBranchInConfig(@NotNull Map<String, String> configMap, @NotNull VcsBranch vcsBranch) {
        configMap.put("repository.bitbucket.branch", vcsBranch.getName());
        return configMap;
    }

    @NotNull
    public VcsBranch createVcsBranchFromName(@NotNull String name) {
        return new VcsBranchImpl(name);
    }

    @Deprecated
    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Deprecated
    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

