/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2;

import com.atlassian.bamboo.plugins.bitbucket.v2.configurator.BitbucketCloudConfigurationConstants;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import io.atlassian.util.concurrent.Lazy;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BitbucketCloudRestApiClient {
    protected final Supplier<Client> bitbucketClientSupplier = Lazy.supplier(() -> {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        clientConfig.getProperties().put("com.sun.jersey.api.json.POJOMappingFeature", true);
        return Client.create((ClientConfig)clientConfig);
    });

    BitbucketCloudRestApiClient() {
    }

    @Nullable
    protected HTTPBasicAuthFilter getAuthFilter(String username, String password) {
        HTTPBasicAuthFilter authFilter = StringUtils.isNotEmpty((CharSequence)password) ? new HTTPBasicAuthFilter(username, password) : null;
        return authFilter;
    }

    @Nullable
    protected LoggingFilter getLoggingFilter(org.apache.log4j.Logger log) {
        LoggingFilter loggingFilter = log.isTraceEnabled() ? new LoggingFilter(Logger.getLogger(this.getClass().getName())) : null;
        return loggingFilter;
    }

    protected void addFilters(WebResource resource, ClientFilter ... filters) {
        Arrays.stream(filters).filter(Objects::nonNull).forEach(arg_0 -> ((WebResource)resource).addFilter(arg_0));
    }

    @NotNull
    protected WebResource.Builder prepareResourceCall(URI requestUri, ClientFilter ... filters) {
        WebResource resource = this.bitbucketClientSupplier.get().resource(requestUri);
        this.addFilters(resource, filters);
        return (WebResource.Builder)((WebResource.Builder)resource.header("User-Agent", (Object)BitbucketCloudConfigurationConstants.BAMBOO_USER_AGENT).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).type(MediaType.APPLICATION_JSON_TYPE);
    }
}

