/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestImpl;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketConfigUtils;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.rest.entity.ListPullRequestsResponse;
import com.atlassian.bamboo.plugins.bitbucket.rest.entity.PullRequest;
import com.atlassian.bamboo.plugins.bitbucket.v2.BitbucketCloudRestApiClient;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsPullRequestDetector;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudPullRequestDetector
extends BitbucketCloudRestApiClient
implements VcsPullRequestDetector {
    private static final Logger log = Logger.getLogger(BitbucketCloudPullRequestDetector.class);
    private final UriBuilder PULL_REQUESTS_URL = UriBuilder.fromUri((String)BitbucketProperty.getBitbucketApiBaseUrl()).path("repositories/{owner}/{repo_slug}/pullrequests").queryParam("state", new Object[]{"OPEN"});
    private CredentialsAccessor credentialsAccessor;

    @NotNull
    public List<VcsPullRequest> getOpenPullRequests(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        ArrayList<PullRequest> pullRequests;
        Pair<String, String> userNameAndPassword = BitbucketConfigUtils.getUsernameAndPassword(repositoryData, this.credentialsAccessor);
        String username = (String)userNameAndPassword.getFirst();
        String password = (String)userNameAndPassword.getSecond();
        try {
            URI requestUri = this.PULL_REQUESTS_URL.build(new Object[]{BitbucketConfigUtils.getRepositoryOwner(repositoryData), BitbucketConfigUtils.getRepositorySlug(repositoryData)});
            HTTPBasicAuthFilter authFilter = this.getAuthFilter(username, password);
            LoggingFilter loggingFilter = this.getLoggingFilter(log);
            WebResource.Builder resource = this.prepareResourceCall(requestUri, new ClientFilter[]{authFilter, loggingFilter});
            ListPullRequestsResponse pullRequestsResponse = (ListPullRequestsResponse)resource.get(ListPullRequestsResponse.class);
            pullRequests = new ArrayList<PullRequest>(pullRequestsResponse.getPullRequests());
            while (pullRequestsResponse.getNextPageLink() != null) {
                WebResource.Builder nextPageResource = this.prepareResourceCall(URI.create(pullRequestsResponse.getNextPageLink()), new ClientFilter[]{authFilter, loggingFilter});
                pullRequestsResponse = (ListPullRequestsResponse)((WebResource.Builder)((WebResource.Builder)nextPageResource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).type(MediaType.APPLICATION_JSON_TYPE)).get(ListPullRequestsResponse.class);
                pullRequests.addAll(pullRequestsResponse.getPullRequests());
            }
        }
        catch (UniformInterfaceException e) {
            if (log.isTraceEnabled() && e.getResponse().hasEntity()) {
                log.trace((Object)("Bitbucket response status " + e.getResponse().getStatus()));
                log.trace((Object)("Bitbucket response body " + (String)e.getResponse().getEntity(String.class)));
            }
            throw new RepositoryException((Throwable)e, repositoryData.getRootVcsRepositoryId());
        }
        return pullRequests.stream().filter(pr -> pr.getDestination() != null).map(pr -> this.convert(repositoryData, (PullRequest)pr)).collect(Collectors.toList());
    }

    @NotNull
    private VcsPullRequest convert(@NotNull VcsRepositoryData repositoryData, PullRequest pr) {
        VcsPullRequestImpl request = new VcsPullRequestImpl();
        request.setKey(pr.getId());
        if (this.isFork(pr)) {
            request.setSourceRepositoryId(null);
        } else {
            request.setSourceRepositoryId(Long.valueOf(repositoryData.getRootVcsRepositoryId()));
        }
        request.setSource(pr.getSource().getBranch().getName());
        request.setTargetRepositoryId(repositoryData.getRootVcsRepositoryId());
        request.setTarget(pr.getDestination().getBranch().getName());
        request.setOpen(true);
        return request;
    }

    private boolean isFork(PullRequest pr) {
        return !pr.getSource().getRepository().getUuid().equals(pr.getDestination().getRepository().getUuid());
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{(String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.repository")});
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

