/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.analytics.RssLogDownloadEvent;
import com.atlassian.bamboo.event.rss.RssEvent;
import com.atlassian.bamboo.event.rss.RssSuccessfulEvent;
import com.atlassian.bamboo.notification.rss.RssAffectedPlan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketConfigUtils;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.v2.BitbucketCloudRestApiClient;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsCommitCommenter;
import com.atlassian.event.Event;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudCommitCommenter
extends BitbucketCloudRestApiClient
implements VcsCommitCommenter {
    private static final Logger log = Logger.getLogger(BitbucketCloudCommitCommenter.class);
    private static final String RSS_SUCCESS_TEMPLATE = "com/atlassian/bamboo/plugins/bitbucket/v2/bitbucketCloudBuildSpecSuccessCommitComment.ftl";
    private static final String RSS_FAILED_TEMPLATE = "com/atlassian/bamboo/plugins/bitbucket/v2/bitbucketCloudBuildSpecFailedCommitComment.ftl";
    private final UriBuilder COMMIT_COMMENT_URL = UriBuilder.fromUri((String)BitbucketProperty.getBitbucketApiBaseUrl()).path("/repositories/{owner}/{repo_slug}/commit/{changesetId}/comments");
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final CredentialsAccessor credentialsAccessor;
    private final DeploymentProjectService deploymentProjectService;
    private final ProjectManager projectManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final RepositoryStoredSpecsLogService repositoryStoreSpecsLogService;
    private final TemplateRenderer templateRenderer;

    @Inject
    public BitbucketCloudCommitCommenter(@BambooImport AdministrationConfigurationAccessor administrationConfigurationAccessor, @BambooImport CredentialsAccessor credentialsAccessor, @BambooImport DeploymentProjectService deploymentProjectService, @BambooImport ProjectManager projectManager, @BambooImport RepositoryDefinitionManager repositoryDefinitionManager, @BambooImport RepositoryStoredSpecsLogService repositoryStoreSpecsLogService, @BambooImport TemplateRenderer templateRenderer) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.credentialsAccessor = credentialsAccessor;
        this.deploymentProjectService = deploymentProjectService;
        this.projectManager = projectManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.repositoryStoreSpecsLogService = repositoryStoreSpecsLogService;
        this.templateRenderer = templateRenderer;
    }

    public boolean publishRssStatus(@NotNull VcsRepositoryData repositoryData, @NotNull String commitId, @NotNull Event event) throws RepositoryException {
        if (!(event instanceof RssEvent)) {
            log.info((Object)("Can't prepare content for " + event.getClass() + ". Skip commit comment for '" + repositoryData.getName() + "' repo"));
            return false;
        }
        String payload = this.generatePayload((RssEvent)event);
        return this.publishComment(repositoryData, commitId, payload);
    }

    public boolean publishComment(@NotNull VcsRepositoryData repositoryData, @NotNull String commitId, @NotNull String payload) throws RepositoryException {
        Pair<String, String> userNameAndPassword = BitbucketConfigUtils.getUsernameAndPassword(repositoryData, this.credentialsAccessor);
        String username = (String)userNameAndPassword.getFirst();
        String password = (String)userNameAndPassword.getSecond();
        if (StringUtils.isEmpty((CharSequence)password)) {
            log.debug((Object)("Password is empty, looks like public repository, skip comment publishing for repo " + repositoryData.getName() + "(" + repositoryData.getId() + ")"));
            return false;
        }
        try {
            URI requestUri = this.COMMIT_COMMENT_URL.build(new Object[]{BitbucketConfigUtils.getRepositoryOwner(repositoryData), BitbucketConfigUtils.getRepositorySlug(repositoryData), commitId});
            HTTPBasicAuthFilter authFilter = this.getAuthFilter(username, password);
            LoggingFilter loggingFilter = this.getLoggingFilter(log);
            WebResource.Builder resource = this.prepareResourceCall(requestUri, new ClientFilter[]{authFilter, loggingFilter});
            HashMap<String, ImmutableMap> content = new HashMap<String, ImmutableMap>();
            content.put("content", ImmutableMap.of((Object)"raw", (Object)payload));
            resource.post((Object)new Gson().toJson(content));
        }
        catch (UniformInterfaceException e) {
            if (log.isTraceEnabled() && e.getResponse().hasEntity()) {
                log.trace((Object)("Bitbucket response status " + e.getResponse().getStatus()));
                log.trace((Object)("Bitbucket response body " + (String)e.getResponse().getEntity(String.class)));
            }
            throw new RepositoryException((Throwable)e, repositoryData.getRootVcsRepositoryId());
        }
        return true;
    }

    @VisibleForTesting
    String generatePayload(RssEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Collection affectedPlans = event.getAffectedPlans();
        if (!affectedPlans.isEmpty()) {
            List plans = affectedPlans.stream().map(plan -> new PlanDTO((RssAffectedPlan)plan, this.administrationConfigurationAccessor)).collect(Collectors.toList());
            context.put("plans", plans);
            this.putMissingPermissionEntities(context, affectedPlans);
        }
        if (!event.getAffectedDeploymentProjects().isEmpty()) {
            List deployments = event.getAffectedDeploymentProjects().stream().map(arg_0 -> ((DeploymentProjectService)this.deploymentProjectService).getDeploymentProject(arg_0)).filter(Objects::nonNull).map(deploymentProject -> new DeploymentDTO(deploymentProject.getName(), BitbucketCloudCommitCommenter.getLink("/deploy/viewDeploymentProjectVersions.action?id=" + deploymentProject.getId(), this.administrationConfigurationAccessor))).collect(Collectors.toList());
            context.put("deployments", deployments);
        }
        context.put("logsUrl", BitbucketCloudCommitCommenter.getLink(this.repositoryStoreSpecsLogService.generateSpecsLogsUrl(event.getRepositoryData().getRootVcsRepositoryId(), event.getCommits(), RssLogDownloadEvent.Referrer.COMMIT.getName()), this.administrationConfigurationAccessor));
        return this.templateRenderer.render(this.getTemplate(event), context);
    }

    private void putMissingPermissionEntities(Map<String, Object> context, Collection<RssAffectedPlan> affectedPlans) {
        Set collect = affectedPlans.stream().filter(RssAffectedPlan::isRssMissingAnyAccess).map(plan -> {
            HashSet result = new HashSet();
            if (plan.getProjectsMissingRssAccess() != null) {
                plan.getProjectsMissingRssAccess().stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectByKey(arg_0)).filter(Objects::nonNull).map(project -> new MissingPermissionEntity(project.getName(), BitbucketCloudCommitCommenter.getLink("/project/admin/config/editProjectSpecsRepositories.action?projectKey=" + project.getKey(), this.administrationConfigurationAccessor))).forEach(result::add);
            }
            if (plan.getRepositoriesMissingRssAccess() != null) {
                plan.getRepositoriesMissingRssAccess().stream().map(arg_0 -> ((RepositoryDefinitionManager)this.repositoryDefinitionManager).getLinkedRepositoryByName(arg_0)).filter(Objects::nonNull).map(repository -> new MissingPermissionEntity(repository.getName(), BitbucketCloudCommitCommenter.getLink("/admin/configureLinkedRepositories!doDefault.action?repositoryId=" + repository.getRootVcsRepositoryId(), this.administrationConfigurationAccessor))).forEach(result::add);
            }
            return result;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
        context.put("rssPermissionMissingEntities", collect);
    }

    private String getTemplate(RssEvent event) {
        if (event instanceof RssSuccessfulEvent) {
            return RSS_SUCCESS_TEMPLATE;
        }
        return RSS_FAILED_TEMPLATE;
    }

    private static String getLink(String relativeUrl, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        return new BambooUrl(administrationConfigurationAccessor).withBaseUrlFromConfiguration(relativeUrl);
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{(String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.repository")});
    }

    public static class MissingPermissionEntity {
        private final String name;
        private final String url;

        MissingPermissionEntity(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MissingPermissionEntity that = (MissingPermissionEntity)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.url);
        }
    }

    public static class DeploymentDTO {
        private final String name;
        private final String url;

        DeploymentDTO(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class PlanDTO {
        private final String projectName;
        private final String projectUrl;
        private final String planName;
        private final String planUrl;
        private final String buildNumber;
        private final String buildResultUrl;
        private final boolean disabled;
        private final boolean permissionMissing;

        PlanDTO(RssAffectedPlan plan, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
            this.projectName = plan.getProjectName();
            this.projectUrl = BitbucketCloudCommitCommenter.getLink("/browse/" + plan.getProjectKey(), administrationConfigurationAccessor);
            this.planName = plan.getName();
            this.planUrl = BitbucketCloudCommitCommenter.getLink("/browse/" + plan.getPlanKey(), administrationConfigurationAccessor);
            if (plan.getBuildNumber() == null) {
                this.buildNumber = "";
                this.buildResultUrl = "";
            } else {
                this.buildNumber = plan.getBuildNumber().toString();
                this.buildResultUrl = BitbucketCloudCommitCommenter.getLink("/browse/" + PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)plan.getBuildNumber()), administrationConfigurationAccessor);
            }
            this.disabled = plan.isDisabled();
            this.permissionMissing = plan.isRssMissingAnyAccess();
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectUrl() {
            return this.projectUrl;
        }

        public String getPlanName() {
            return this.planName;
        }

        public String getPlanUrl() {
            return this.planUrl;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getBuildResultUrl() {
            return this.buildResultUrl;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isPermissionMissing() {
            return this.permissionMissing;
        }
    }
}

