/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryType;
import com.atlassian.bamboo.plugins.bitbucket.v2.AbstractBitbucketCloudExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudBambooSpecsHandler
extends AbstractBitbucketCloudExecutor
implements BambooSpecsHandler {
    private static final Logger log = Logger.getLogger(BitbucketCloudBambooSpecsHandler.class);

    @NotNull
    public Optional<String> detectSpecRevision(@NotNull VcsRepositoryData repositoryData, @NotNull Object source) throws RepositoryException {
        BambooSpecsHandler bambooSpecsHandler = this.getBambooSpecsHandler(repositoryData);
        if (bambooSpecsHandler == null) {
            return Optional.empty();
        }
        return bambooSpecsHandler.detectSpecRevision(this.bitbucketCloudToUnderlyingVcsData(repositoryData), source);
    }

    public boolean isNewer(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) throws RepositoryException {
        BambooSpecsHandler bambooSpecsHandler = this.getBambooSpecsHandler(repositoryData);
        if (bambooSpecsHandler == null) {
            throw new UnsupportedOperationException("Can't handle Bamboo Specs for repository " + repositoryData.getId());
        }
        return bambooSpecsHandler.isNewer(this.bitbucketCloudToUnderlyingVcsData(repositoryData), rev1, rev2);
    }

    @NotNull
    public List<CommitContext> findCommitsToSpecs(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) throws RepositoryException {
        BambooSpecsHandler bambooSpecsHandler = this.getBambooSpecsHandler(repositoryData);
        if (bambooSpecsHandler == null) {
            return Collections.emptyList();
        }
        return bambooSpecsHandler.findCommitsToSpecs(this.bitbucketCloudToUnderlyingVcsData(repositoryData), rev1, rev2);
    }

    public boolean isWebhookRequired() {
        return true;
    }

    @Nullable
    private BambooSpecsHandler getBambooSpecsHandler(@NotNull VcsRepositoryData repositoryData) {
        BambooSpecsHandler bambooSpecsHandler = this.getUnderlyingVcsModuleDescriptor(repositoryData).getBambooSpecsHandler();
        if (bambooSpecsHandler == null) {
            BitbucketRepositoryType repositoryType = this.getRepositoryType(repositoryData);
            String errorMessage = String.format("Repository %s (id=%s) of type %s (%s) doesn't support Bamboo Specs handling", repositoryData.getName(), String.valueOf(repositoryData.getId()), repositoryType.getType(), repositoryType.getPluginKey());
            log.warn((Object)errorMessage);
            return null;
        }
        return bambooSpecsHandler;
    }
}

