/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.v2;

import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAuthenticationType;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketSshCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryType;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.plugins.hg.AuthenticationType;
import com.atlassian.bamboo.plugins.hg.configuration.CredentialsSource;
import com.atlassian.bamboo.plugins.hg.configuration.HgRepositoryFields;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AbstractBitbucketCloudExecutor {
    private static final Logger log = Logger.getLogger(AbstractBitbucketCloudExecutor.class);
    @VisibleForTesting
    static final Map<BitbucketAuthenticationType, GitAuthenticationType> GIT_AUTHENTICATION_TYPE_MAP = ImmutableMap.of((Object)((Object)BitbucketAuthenticationType.NONE), (Object)GitAuthenticationType.NONE, (Object)((Object)BitbucketAuthenticationType.PASSWORD), (Object)GitAuthenticationType.PASSWORD, (Object)((Object)BitbucketAuthenticationType.SSH_KEYPAIR), (Object)GitAuthenticationType.SSH_KEYPAIR);
    @VisibleForTesting
    static final Map<BitbucketAuthenticationType, AuthenticationType> HG_AUTHENTICATION_TYPE_MAP = ImmutableMap.of((Object)((Object)BitbucketAuthenticationType.NONE), (Object)AuthenticationType.BYPASS, (Object)((Object)BitbucketAuthenticationType.PASSWORD), (Object)AuthenticationType.PASSWORD, (Object)((Object)BitbucketAuthenticationType.SSH_KEYPAIR), (Object)AuthenticationType.SSH_PROXY);
    @VisibleForTesting
    static final Map<BitbucketPasswordCredentialsSource, GitPasswordCredentialsSource> GIT_PASSWORD_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketPasswordCredentialsSource.CUSTOM), (Object)GitPasswordCredentialsSource.CUSTOM, (Object)((Object)BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS), (Object)GitPasswordCredentialsSource.SHARED_CREDENTIALS);
    @VisibleForTesting
    static final Map<BitbucketPasswordCredentialsSource, CredentialsSource> HG_PASSWORD_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketPasswordCredentialsSource.CUSTOM), (Object)CredentialsSource.CUSTOM, (Object)((Object)BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS), (Object)CredentialsSource.SHARED_CREDENTIALS);
    @VisibleForTesting
    static final Map<BitbucketSshCredentialsSource, GitSshCredentialsSource> GIT_SSH_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketSshCredentialsSource.CUSTOM), (Object)GitSshCredentialsSource.CUSTOM, (Object)((Object)BitbucketSshCredentialsSource.SHARED_CREDENTIALS), (Object)GitSshCredentialsSource.SHARED_CREDENTIALS);
    @VisibleForTesting
    static final Map<BitbucketSshCredentialsSource, CredentialsSource> HG_SSH_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketSshCredentialsSource.CUSTOM), (Object)CredentialsSource.CUSTOM, (Object)((Object)BitbucketSshCredentialsSource.SHARED_CREDENTIALS), (Object)CredentialsSource.SHARED_CREDENTIALS);
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;

    protected BitbucketRepositoryType getRepositoryType(@NotNull VcsRepositoryData repositoryData) {
        return BitbucketRepositoryType.valueOf((String)repositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.scm"));
    }

    protected VcsRepositoryData bitbucketCloudToUnderlyingVcsData(@NotNull VcsRepositoryData repositoryData) {
        BitbucketRepositoryType type = this.getRepositoryType(repositoryData);
        PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder().vcsBranch(repositoryData.getBranch().getVcsBranch()).changeDetectionConfiguration(repositoryData.getVcsChangeDetectionOptions().getConfiguration()).name(repositoryData.getName()).description(repositoryData.getDescription());
        switch (this.getRepositoryType(repositoryData)) {
            case GIT: {
                Map<String, String> gitServerConfiguration = this.transformToGitServerCfg(repositoryData.getVcsLocation().getConfiguration());
                Map<String, String> gitBranchConfiguration = this.transformToGitBranchCfg(repositoryData.getBranch().getConfiguration());
                builder.pluginKey("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2").serverConfiguration(gitServerConfiguration).branchConfiguration(gitBranchConfiguration);
                break;
            }
            case HG: {
                Map<String, String> hgServerConfiguration = this.transformToMercurialServerCfg(repositoryData.getVcsLocation().getConfiguration());
                Map<String, String> hgBranchConfiguration = this.transformToMercurialBranchCfg(repositoryData.getBranch().getConfiguration());
                builder.pluginKey("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:mercurial").serverConfiguration(hgServerConfiguration).branchConfiguration(hgBranchConfiguration);
                break;
            }
            default: {
                throw new IllegalStateException("Neither git nor mercurial in bb cloud");
            }
        }
        return builder.build().getCompleteData();
    }

    private Map<String, String> transformToMercurialBranchCfg(Map<String, String> configuration) {
        HashMap<String, String> hgConfig = new HashMap<String, String>();
        hgConfig.put("repository.hg.branch", (String)StringUtils.defaultIfBlank((CharSequence)configuration.get("repository.bitbucket.branch"), (CharSequence)"default"));
        return hgConfig;
    }

    private Map<String, String> transformToMercurialServerCfg(Map<String, String> configuration) {
        HashMap<String, String> hgConfig = new HashMap<String, String>();
        this.populateHgConfigWithAuthenticationSettings(hgConfig, configuration);
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(configuration.get("repository.bitbucket.authenticationType"));
        hgConfig.put("repository.hg.repositoryUrl", this.getRepositoryCloneUrl(BitbucketRepositoryType.HG, authenticationType, configuration.get("repository.bitbucket.repository").trim()));
        hgConfig.put("repository.hg.commandTimeout", configuration.get("repository.bitbucket.commandTimeout"));
        hgConfig.put("repository.hg.verbose.logs", configuration.get("repository.bitbucket.verbose.logs"));
        return hgConfig;
    }

    private void populateHgConfigWithAuthenticationSettings(Map<String, String> hgConfig, Map<String, String> configuration) {
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(configuration.get("repository.bitbucket.authenticationType"));
        hgConfig.put("repository.hg.authentication", HG_AUTHENTICATION_TYPE_MAP.get((Object)authenticationType).name());
        if (authenticationType == BitbucketAuthenticationType.PASSWORD) {
            BitbucketAccessLevel accessLevel = BitbucketAccessLevel.valueOf(configuration.get("repository.bitbucket.accessLevel"));
            String usernameField = accessLevel == BitbucketAccessLevel.PUBLIC ? "repository.bitbucket.owner" : "repository.bitbucket.username";
            BitbucketPasswordCredentialsSource credentialsSource = BitbucketPasswordCredentialsSource.valueOf(configuration.get("repository.bitbucket.passwordCredentialsSource"));
            hgConfig.put("repository.hg.password.source", HG_PASSWORD_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                hgConfig.put("repository.hg.password.sharedCredentials", configuration.get("repository.bitbucket.passwordSharedCredentials.id"));
            } else {
                hgConfig.put("repository.hg.password.username", configuration.get(usernameField));
                hgConfig.put("repository.hg.password.password", configuration.get("repository.bitbucket.password"));
            }
        } else if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            BitbucketSshCredentialsSource credentialsSource = BitbucketSshCredentialsSource.valueOf(configuration.get("repository.bitbucket.sshCredentialsSource"));
            hgConfig.put("repository.hg.ssh_proxy.source", HG_SSH_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                hgConfig.put("repository.hg.ssh_proxy.sharedCredentials", configuration.get("repository.bitbucket.sshSharedCredentials.id"));
            } else if (credentialsSource == BitbucketSshCredentialsSource.CUSTOM) {
                hgConfig.put("repository.hg.ssh_proxy.privateKey", configuration.get("repository.bitbucket.sshKey"));
                hgConfig.put("repository.hg.ssh_proxy.passphrase", configuration.get("repository.bitbucket.sshPassphrase"));
            }
        }
    }

    private Map<String, String> transformToGitBranchCfg(Map<String, String> configuration) {
        HashMap<String, String> gitConfig = new HashMap<String, String>();
        gitConfig.put("repository.git.branch", (String)StringUtils.defaultIfBlank((CharSequence)configuration.get("repository.bitbucket.branch"), (CharSequence)"master"));
        return gitConfig;
    }

    private Map<String, String> transformToGitServerCfg(Map<String, String> configuration) {
        HashMap<String, String> gitConfig = new HashMap<String, String>();
        this.populateGitConfigWithAuthenticationSettings(gitConfig, configuration);
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(configuration.get("repository.bitbucket.authenticationType"));
        gitConfig.put("repository.git.repositoryUrl", this.getRepositoryCloneUrl(BitbucketRepositoryType.GIT, authenticationType, configuration.get("repository.bitbucket.repository").trim()));
        gitConfig.put("repository.git.commandTimeout", StringUtils.defaultString((String)configuration.get("repository.bitbucket.commandTimeout"), (String)Long.toString(HgRepositoryFields.DEFAULT_COMMAND_TIMEOUT.toMinutes())));
        gitConfig.put("repository.git.verbose.logs", configuration.get("repository.bitbucket.verbose.logs"));
        gitConfig.put("repository.git.fetch.whole.repository", configuration.get("repository.bitbucket.fetch.whole.repository"));
        gitConfig.put("repository.git.useShallowClones", configuration.get("repository.bitbucket.git.useShallowClones"));
        gitConfig.put("repository.git.lfs", configuration.get("repository.bitbucket.git.lfs"));
        gitConfig.put("repository.git.useSubmodules", configuration.get("repository.bitbucket.git.useSubmodules"));
        gitConfig.put("repository.git.useRemoteAgentCache", configuration.get("repository.bitbucket.git.useRemoteAgentCache"));
        return gitConfig;
    }

    private void populateGitConfigWithAuthenticationSettings(Map<String, String> gitConfig, Map<String, String> configuration) {
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(configuration.get("repository.bitbucket.authenticationType"));
        gitConfig.put("repository.git.authenticationType", GIT_AUTHENTICATION_TYPE_MAP.get((Object)authenticationType).name());
        if (authenticationType == BitbucketAuthenticationType.PASSWORD) {
            BitbucketAccessLevel accessLevel = BitbucketAccessLevel.valueOf(configuration.get("repository.bitbucket.accessLevel"));
            String usernameField = accessLevel == BitbucketAccessLevel.PUBLIC ? "repository.bitbucket.owner" : "repository.bitbucket.username";
            BitbucketPasswordCredentialsSource credentialsSource = BitbucketPasswordCredentialsSource.valueOf(configuration.get("repository.bitbucket.passwordCredentialsSource"));
            gitConfig.put("repository.git.passwordCredentialsSource", GIT_PASSWORD_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                gitConfig.put("repository.git.passwordSharedCredentials", configuration.get("repository.bitbucket.passwordSharedCredentials.id"));
            } else {
                gitConfig.put("repository.git.username", configuration.get(usernameField));
                gitConfig.put("repository.git.password", configuration.get("repository.bitbucket.password"));
            }
        } else if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            BitbucketSshCredentialsSource credentialsSource = BitbucketSshCredentialsSource.valueOf(configuration.get("repository.bitbucket.sshCredentialsSource"));
            gitConfig.put("repository.git.sshCredentialsSource", GIT_SSH_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                gitConfig.put("repository.git.sharedCredentials", configuration.get("repository.bitbucket.sshSharedCredentials.id"));
            } else if (credentialsSource == BitbucketSshCredentialsSource.CUSTOM) {
                gitConfig.put("repository.git.ssh.key", configuration.get("repository.bitbucket.sshKey"));
                gitConfig.put("repository.git.ssh.passphrase", configuration.get("repository.bitbucket.sshPassphrase"));
            }
        }
    }

    @NotNull
    private String getRepositoryCloneUrl(@NotNull BitbucketRepositoryType repositoryType, @NotNull BitbucketAuthenticationType authenticationType, @NotNull String repositorySlug) {
        return authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR ? this.getRepositorySshCloneUrl(repositoryType, repositorySlug) : this.getRepositoryHttpsCloneUrl(repositorySlug);
    }

    @NotNull
    private String getRepositorySshCloneUrl(@NotNull BitbucketRepositoryType repositoryType, @NotNull String repositorySlug) {
        try {
            URI bitbucketUri = new URI(BitbucketProperty.BITBUCKET_BASE_URL);
            return bitbucketUri.getPort() > -1 ? String.format("ssh://%s@%s:%d/%s", repositoryType.getType(), bitbucketUri.getHost(), bitbucketUri.getPort(), repositorySlug) : String.format("ssh://%s@%s/%s", repositoryType.getType(), bitbucketUri.getHost(), repositorySlug);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid Bitbucket Cloud url: " + BitbucketProperty.BITBUCKET_BASE_URL, e);
        }
    }

    @NotNull
    private String getRepositoryHttpsCloneUrl(@NotNull String repositorySlug) {
        return BitbucketProperty.BITBUCKET_BASE_URL + repositorySlug;
    }

    protected VcsRepositoryModuleDescriptor getUnderlyingVcsModuleDescriptor(@NotNull VcsRepositoryData repositoryData) {
        switch (this.getRepositoryType(repositoryData)) {
            case GIT: {
                return this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2");
            }
            case HG: {
                return this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:mercurial");
            }
        }
        throw new IllegalStateException("Neither git nor mercurial in bb cloud");
    }

    @Deprecated
    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }
}

