/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.utils;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.SshCredentialsImpl;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketApiAccessor;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAuthenticationType;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketSshCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.utils.BitbucketValidationHelper;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class BitbucketValidationHelperImpl
implements BitbucketValidationHelper {
    private final Function<String, String> getUsernameForEmailFunction;
    private final CredentialsAccessor credentialsAccessor;
    private final I18nResolver i18nResolver;

    @Autowired
    public BitbucketValidationHelperImpl(CredentialsAccessor credentialsAccessor, I18nResolver i18nResolver) {
        this(credentialsAccessor, i18nResolver, BitbucketApiAccessor::getUuidForAnEmailOrUsername);
    }

    @VisibleForTesting
    BitbucketValidationHelperImpl(CredentialsAccessor credentialsAccessor, I18nResolver i18nResolver, Function<String, String> getUsernameForEmailFunction) {
        this.credentialsAccessor = credentialsAccessor;
        this.i18nResolver = i18nResolver;
        this.getUsernameForEmailFunction = getUsernameForEmailFunction;
    }

    @Override
    public ErrorCollection validate(@NotNull HierarchicalConfiguration configuration, @NotNull ErrorCollection errorCollection) {
        this.validateAccessLevel(errorCollection, configuration.getString("repository.bitbucket.accessLevel", null));
        if (errorCollection.hasAnyErrors()) {
            return errorCollection;
        }
        BitbucketAccessLevel accessLevel = BitbucketAccessLevel.valueOf(configuration.getString("repository.bitbucket.accessLevel"));
        this.validateAuthenticationType(errorCollection, accessLevel, configuration.getString("repository.bitbucket.authenticationType", null));
        if (errorCollection.hasAnyErrors()) {
            return errorCollection;
        }
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(configuration.getString("repository.bitbucket.authenticationType"));
        if (accessLevel == BitbucketAccessLevel.PUBLIC) {
            this.validateUsername(errorCollection, "repository.bitbucket.owner", configuration.getString("repository.bitbucket.owner", null), "repository.bitbucket.owner.error.empty");
        }
        if (accessLevel == BitbucketAccessLevel.PRIVATE || authenticationType == BitbucketAuthenticationType.PASSWORD) {
            this.validateUsernamePasswordCredentials(errorCollection, configuration);
        }
        if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            this.validateSshCredentials(errorCollection, configuration);
        }
        this.validateRepository(errorCollection, configuration.getString("repository.bitbucket.repository", null));
        return errorCollection;
    }

    @Override
    public ErrorCollection validateForConnectionTesting(@NotNull HierarchicalConfiguration configuration, @NotNull ErrorCollection errorCollection) {
        boolean requiresSshKeyFileTransfer;
        boolean bl = requiresSshKeyFileTransfer = BitbucketAuthenticationType.SSH_KEYPAIR.name().equals(configuration.getString("repository.bitbucket.authenticationType", "")) && BitbucketSshCredentialsSource.CUSTOM.name().equals(configuration.getString("repository.bitbucket.sshCredentialsSource", "")) && configuration.getBoolean("repository.bitbucket.temporary.sshKeyChange", false);
        if (requiresSshKeyFileTransfer) {
            errorCollection.addError("repository.bitbucket.temporary.sshKeyFile", this.i18nResolver.getText("repository.test.connection.private.key.not.received"));
            return errorCollection;
        }
        return this.validate(configuration, errorCollection);
    }

    private void validateAccessLevel(@NotNull ErrorCollection errorCollection, @Nullable String accessLevel) {
        if (StringUtils.isEmpty((CharSequence)accessLevel)) {
            errorCollection.addError("repository.bitbucket.accessLevel", this.i18nResolver.getText("repository.bitbucket.accessLevel.error.empty"));
        } else if (Arrays.stream(BitbucketAccessLevel.values()).map(Enum::name).noneMatch(accessLevel::equals)) {
            errorCollection.addError("repository.bitbucket.accessLevel", this.i18nResolver.getText("repository.bitbucket.accessLevel.error.unknown", new Serializable[]{accessLevel}));
        }
    }

    @VisibleForTesting
    void validateAuthenticationType(@NotNull ErrorCollection errorCollection, @NotNull BitbucketAccessLevel accessLevel, @Nullable String authenticationType) {
        if (StringUtils.isEmpty((CharSequence)authenticationType)) {
            errorCollection.addError("repository.bitbucket.authenticationType", this.i18nResolver.getText("repository.bitbucket.authenticationType.error.empty"));
        } else if (accessLevel.getSupportedAuthenticationTypes().stream().map(Enum::name).noneMatch(authenticationType::equals)) {
            errorCollection.addError("repository.bitbucket.authenticationType", this.i18nResolver.getText("repository.bitbucket.authenticationType.error.unknown", new Serializable[]{authenticationType}));
        }
    }

    @VisibleForTesting
    void validateUsernamePasswordCredentials(@NotNull ErrorCollection errorCollection, @NotNull HierarchicalConfiguration configuration) {
        String passwordCredentialsSourceString = configuration.getString("repository.bitbucket.passwordCredentialsSource", null);
        if (StringUtils.isEmpty((CharSequence)passwordCredentialsSourceString)) {
            errorCollection.addError("repository.bitbucket.passwordCredentialsSource", this.i18nResolver.getText("repository.bitbucket.passwordCredentialsSource.error.empty"));
        } else if (Arrays.stream(BitbucketPasswordCredentialsSource.values()).map(Enum::name).noneMatch(passwordCredentialsSourceString::equals)) {
            errorCollection.addError("repository.bitbucket.passwordCredentialsSource", this.i18nResolver.getText("repository.bitbucket.passwordCredentialsSource.error.unknown", new Serializable[]{passwordCredentialsSourceString}));
        } else {
            String password;
            String username;
            BitbucketPasswordCredentialsSource passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf(passwordCredentialsSourceString);
            if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                Long passwordSharedCredentialsId = configuration.getLong("repository.bitbucket.passwordSharedCredentials.id", null);
                if (passwordSharedCredentialsId == null) {
                    errorCollection.addErrorMessage(this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.empty"));
                    return;
                }
                CredentialsData credentials = this.credentialsAccessor.getCredentials(passwordSharedCredentialsId.longValue());
                if (credentials == null) {
                    errorCollection.addError("repository.bitbucket.passwordSharedCredentials.id", this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.notFound"));
                    return;
                }
                UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentials);
                username = passwordCredentials.getUsername();
                password = passwordCredentials.getPassword();
            } else {
                username = configuration.getString("repository.bitbucket.username");
                password = configuration.getString("repository.bitbucket.password");
            }
            this.validateUsername(errorCollection, "repository.bitbucket.username", username, "repository.bitbucket.username.error.empty");
            if (StringUtils.isEmpty((CharSequence)password)) {
                String errorMessage = this.i18nResolver.getText("repository.bitbucket.password.error.empty");
                if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                    errorCollection.addErrorMessage(errorMessage);
                } else {
                    errorCollection.addError("repository.bitbucket.temporary.password", errorMessage);
                }
            }
        }
    }

    @VisibleForTesting
    void validateSshCredentials(@NotNull ErrorCollection errorCollection, @NotNull HierarchicalConfiguration configuration) {
        String sshCredentialsSourceString = configuration.getString("repository.bitbucket.sshCredentialsSource", null);
        if (StringUtils.isEmpty((CharSequence)sshCredentialsSourceString)) {
            errorCollection.addErrorMessage(this.i18nResolver.getText("repository.bitbucket.sshCredentialsSource.error.empty"));
        } else if (Arrays.stream(BitbucketSshCredentialsSource.values()).map(Enum::name).noneMatch(sshCredentialsSourceString::equals)) {
            errorCollection.addError("repository.bitbucket.sshCredentialsSource", this.i18nResolver.getText("repository.bitbucket.sshCredentialsSource.error.unknown", new Serializable[]{sshCredentialsSourceString}));
        } else {
            String sshPrivateKey;
            BitbucketSshCredentialsSource sshCredentialsSource = BitbucketSshCredentialsSource.valueOf(sshCredentialsSourceString);
            if (sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                Long sshSharedCredentialsId = configuration.getLong("repository.bitbucket.sshSharedCredentials.id", null);
                if (sshSharedCredentialsId == null) {
                    errorCollection.addErrorMessage(this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.empty"));
                    return;
                }
                CredentialsData credentials = this.credentialsAccessor.getCredentials(sshSharedCredentialsId.longValue());
                if (credentials == null) {
                    errorCollection.addError("repository.bitbucket.sshSharedCredentials.id", this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.notFound"));
                    return;
                }
                SshCredentialsImpl privateKeyCredentials = new SshCredentialsImpl(credentials);
                sshPrivateKey = privateKeyCredentials.getKey();
            } else {
                sshPrivateKey = configuration.getString("repository.bitbucket.sshKey");
            }
            if (StringUtils.isEmpty((CharSequence)sshPrivateKey)) {
                String errorMessage = this.i18nResolver.getText("repository.bitbucket.sshKey.error.empty");
                if (sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                    errorCollection.addErrorMessage(errorMessage);
                } else {
                    errorCollection.addError("repository.bitbucket.temporary.sshKeyFile", errorMessage);
                }
            }
        }
    }

    private void validateUsername(@NotNull ErrorCollection errorCollection, @NotNull String usernameField, @Nullable String username, @NotNull String emptyErrorMessageKey) {
        String realUsername;
        if (StringUtils.isEmpty((CharSequence)username)) {
            errorCollection.addError(usernameField, this.i18nResolver.getText(emptyErrorMessageKey));
        } else if (!BambooFieldValidate.findFieldRelaxedXssViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)usernameField, (String)username) && (realUsername = this.getUsernameForEmailFunction.apply(username)) == null) {
            errorCollection.addError(usernameField, this.i18nResolver.getText("repository.bitbucket.error.invalidUsername"));
        }
    }

    private void validateRepository(@NotNull ErrorCollection errorCollection, @Nullable String repository) {
        if (StringUtils.isBlank((CharSequence)repository)) {
            errorCollection.addError("repository.bitbucket.repository", this.i18nResolver.getText("repository.bitbucket.error.missingRepository"));
        } else {
            BambooFieldValidate.findFieldRelaxedXssViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.bitbucket.repository", (String)repository);
        }
    }
}

