/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.rest.resource;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketConfigUtils;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketRepository;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiException;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiService;
import com.atlassian.bamboo.plugins.bitbucket.api.rest.entity.BitbucketResourceEntity;
import com.atlassian.bamboo.plugins.bitbucket.api.rest.entity.node.BitbucketNodeEntity;
import com.atlassian.bamboo.plugins.bitbucket.rest.entity.BitbucketPageEntity;
import com.atlassian.bamboo.plugins.bitbucket.rest.entity.RestBitbucketRequest;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.rest.common.exception.RestErrorCollection;
import com.atlassian.bamboo.rest.entity.RestResponse;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.sal.api.message.I18nResolver;
import com.sun.jersey.spi.resource.Singleton;
import java.io.Serializable;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="bb")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
public class BitbucketResource {
    private static final Logger log = Logger.getLogger(BitbucketResource.class);
    private final BitbucketApiService bitbucketApiService;
    private final I18nResolver i18nResolver;
    private final CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    private final CredentialsAccessor credentialsAccessor;

    public BitbucketResource(BitbucketApiService bitbucketApiService, I18nResolver i18nResolver, CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager, CredentialsAccessor credentialsAccessor) {
        this.bitbucketApiService = bitbucketApiService;
        this.i18nResolver = i18nResolver;
        this.cachedRepositoryDefinitionManager = cachedRepositoryDefinitionManager;
        this.credentialsAccessor = credentialsAccessor;
    }

    @POST
    @Path(value="repositories")
    public Response getAvailableRepositories(@Context UriInfo uriInfo, @NotNull RestBitbucketRequest request) {
        return this.executeCall((BambooCallables.Throwing1<Response, WebValidationException>)((BambooCallables.Throwing1)() -> {
            BitbucketAccessCredentials accessCredentials = this.getAccessCredentials(request);
            String query = request.getQuery();
            try {
                BitbucketPageEntity<BitbucketResourceEntity> repositories = accessCredentials.getPassword() != null ? this.bitbucketApiService.findRepositories(accessCredentials.getUsername(), accessCredentials.getPassword(), query, request.getStart(), request.getLimit()) : this.bitbucketApiService.findPublicRepositories(accessCredentials.getUsername(), query, request.getStart(), request.getLimit());
                return Response.ok(repositories).build();
            }
            catch (BitbucketApiException e) {
                return this.buildResponseFromException(e, null);
            }
        }));
    }

    @POST
    @Path(value="repository")
    public Response getRepository(@Context UriInfo uriInfo, @NotNull RestBitbucketRequest request) {
        return this.executeCall((BambooCallables.Throwing1<Response, WebValidationException>)((BambooCallables.Throwing1)() -> {
            BitbucketAccessCredentials accessCredentials = this.getAccessCredentials(request);
            String[] ownerSlug = BitbucketConfigUtils.checkSplitRepositoryName(request.getRepository());
            try {
                BitbucketResourceEntity repository = this.bitbucketApiService.getRepository(ownerSlug[0], ownerSlug[1], accessCredentials.getUsername(), accessCredentials.getPassword());
                return Response.ok((Object)repository).build();
            }
            catch (BitbucketApiException e) {
                return this.buildResponseFromException(e, this.i18nResolver.getText("repository.bitbucket.error.noRepositoryMatching", new Serializable[]{request.getRepository()}));
            }
        }));
    }

    @POST
    @Path(value="branches")
    public Response getBranches(@Context UriInfo uriInfo, @NotNull RestBitbucketRequest request) {
        return this.executeCall((BambooCallables.Throwing1<Response, WebValidationException>)((BambooCallables.Throwing1)() -> {
            BitbucketAccessCredentials accessCredentials = this.getAccessCredentials(request);
            String[] ownerSlug = BitbucketConfigUtils.checkSplitRepositoryName(request.getRepository());
            RestResponse.Builder builder = RestResponse.builder();
            try {
                BitbucketPageEntity<BitbucketNodeEntity> branches = this.bitbucketApiService.findBranches(ownerSlug[0], ownerSlug[1], accessCredentials.getUsername(), accessCredentials.getPassword(), request.getQuery(), request.getStart(), request.getLimit());
                return Response.ok(branches).build();
            }
            catch (BitbucketApiException e) {
                return this.buildResponseFromException(e, this.i18nResolver.getText("repository.bitbucket.error.noRepositoryMatching", new Serializable[]{request.getRepository()}));
            }
        }));
    }

    @POST
    @Path(value="branch")
    public Response getBranch(@Context UriInfo uriInfo, @NotNull RestBitbucketRequest request) {
        return this.executeCall((BambooCallables.Throwing1<Response, WebValidationException>)((BambooCallables.Throwing1)() -> {
            BitbucketAccessCredentials accessCredentials = this.getAccessCredentials(request);
            String[] ownerSlug = BitbucketConfigUtils.checkSplitRepositoryName(request.getRepository());
            if (StringUtils.isBlank((CharSequence)request.getBranch())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestErrorCollection(this.i18nResolver.getText("repository.bitbucket.error.provideBranch"))).build();
            }
            try {
                BitbucketNodeEntity branch = this.bitbucketApiService.getBranch(ownerSlug[0], ownerSlug[1], request.getBranch(), accessCredentials.getUsername(), accessCredentials.getPassword());
                if (branch != null) {
                    return Response.ok((Object)branch).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestErrorCollection(this.i18nResolver.getText("repository.bitbucket.error.noBranchMatching", new Serializable[]{request.getBranch()}))).build();
            }
            catch (BitbucketApiException e) {
                return this.buildResponseFromException(e, this.i18nResolver.getText("repository.bitbucket.error.noBranchMatching", new Serializable[]{request.getBranch()}));
            }
        }));
    }

    @POST
    @Path(value="branches/default")
    public Response getDefaultBranch(@Context UriInfo uriInfo, @NotNull RestBitbucketRequest request) {
        return this.executeCall((BambooCallables.Throwing1<Response, WebValidationException>)((BambooCallables.Throwing1)() -> {
            BitbucketAccessCredentials accessCredentials = this.getAccessCredentials(request);
            String[] ownerSlug = BitbucketConfigUtils.checkSplitRepositoryName(request.getRepository());
            try {
                BitbucketNodeEntity defaultBranch = this.bitbucketApiService.getDefaultBranch(ownerSlug[0], ownerSlug[1], accessCredentials.getUsername(), accessCredentials.getPassword());
                if (defaultBranch != null) {
                    return Response.ok((Object)defaultBranch).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestErrorCollection(this.i18nResolver.getText("repository.bitbucket.ajax.error.noBranches", new Serializable[]{request.getRepository()}))).build();
            }
            catch (BitbucketApiException e) {
                return this.buildResponseFromException(e, this.i18nResolver.getText("repository.bitbucket.error.noRepositoryMatching", new Serializable[]{request.getRepository()}));
            }
        }));
    }

    @Nullable
    private String getUsernameFromRequestOrRepository(@NotNull RestBitbucketRequest request, @Nullable VcsRepositoryData existingRepository) {
        if (StringUtils.isNotBlank((CharSequence)request.getUsername())) {
            return request.getUsername();
        }
        if (existingRepository != null && (request.getAccessLevel() == null || BitbucketConfigUtils.getAccessLevel(existingRepository).name().equals(request.getAccessLevel()))) {
            return BitbucketConfigUtils.getAccessLevel(existingRepository) == BitbucketAccessLevel.PRIVATE ? BitbucketConfigUtils.getUsername(existingRepository, this.credentialsAccessor) : BitbucketConfigUtils.getOwner(existingRepository);
        }
        return null;
    }

    @Nullable
    private String getPasswordFromRequestOrRepository(@NotNull RestBitbucketRequest request, @Nullable VcsRepositoryData existingRepository) {
        if (StringUtils.isNotBlank((CharSequence)request.getPassword())) {
            return request.getPassword();
        }
        if (existingRepository != null && (request.getAccessLevel() == null || BitbucketConfigUtils.getAccessLevel(existingRepository).name().equals(request.getAccessLevel()))) {
            return Optional.ofNullable(BitbucketConfigUtils.getPassword(existingRepository, this.credentialsAccessor)).filter(StringUtils::isNotBlank).orElse(null);
        }
        return null;
    }

    @Nullable
    private String getAccessLevelFromRequestOrRepository(@NotNull RestBitbucketRequest request, @Nullable VcsRepositoryData existingRepository) {
        if (StringUtils.isNotBlank((CharSequence)request.getAccessLevel())) {
            return request.getAccessLevel();
        }
        if (existingRepository != null) {
            return BitbucketConfigUtils.getAccessLevel(existingRepository).name();
        }
        return null;
    }

    @Nullable
    private String getPasswordCredentialTypeFromRequestOrRepository(@NotNull RestBitbucketRequest request, @Nullable VcsRepositoryData existingRepository) {
        if (StringUtils.isNotBlank((CharSequence)request.getCredentialsSource())) {
            return request.getCredentialsSource();
        }
        if (existingRepository != null) {
            return BitbucketConfigUtils.getPasswordCredentialSource(existingRepository).name();
        }
        return null;
    }

    private Long getPasswordSharedCredentialsId(@NotNull VcsRepositoryData existingRepository) {
        if (existingRepository.isLegacyRepository()) {
            return ((BitbucketRepository)existingRepository.asLegacyData().getRepository()).getPasswordSharedCredentialsId();
        }
        String sharedCredString = (String)existingRepository.getVcsLocation().getConfiguration().get("repository.bitbucket.passwordSharedCredentials.id");
        return sharedCredString != null ? Long.valueOf(Long.parseLong(sharedCredString)) : null;
    }

    @Nullable
    private Long getSharedCredentialsIdFromRequestOrRepository(@NotNull RestBitbucketRequest request, @Nullable VcsRepositoryData existingRepository) {
        return request.getSharedCredentialsId() != null ? request.getSharedCredentialsId() : (Long)Optional.ofNullable(existingRepository).map(this::getPasswordSharedCredentialsId).orElse(null);
    }

    @Nullable
    private VcsRepositoryData getExistingRepository(@NotNull RestBitbucketRequest request) {
        return Optional.of(request.getRepositoryId()).filter(id -> id > 0L).map(arg_0 -> ((CachedRepositoryDefinitionManager)this.cachedRepositoryDefinitionManager).getVcsRepositoryData(arg_0)).orElse(null);
    }

    @NotNull
    private BitbucketAccessCredentials getAccessCredentials(@NotNull RestBitbucketRequest request) throws WebValidationException {
        String password;
        String username;
        VcsRepositoryData existingRepository = this.getExistingRepository(request);
        if (BitbucketAccessLevel.PUBLIC.name().equals(this.getAccessLevelFromRequestOrRepository(request, existingRepository))) {
            String username2 = this.getUsernameFromRequestOrRepository(request, existingRepository);
            BambooValidationUtils.validate((username2 != null ? 1 : 0) != 0, () -> this.i18nResolver.getText("repository.bitbucket.username.error.empty"));
            return new BitbucketAccessCredentials(username2, null);
        }
        if (BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS.name().equals(this.getPasswordCredentialTypeFromRequestOrRepository(request, existingRepository))) {
            Long sharedCredentialsId = this.getSharedCredentialsIdFromRequestOrRepository(request, existingRepository);
            BambooValidationUtils.validate((sharedCredentialsId != null ? 1 : 0) != 0, () -> this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.empty"));
            CredentialsData credentialsData = this.credentialsAccessor.getCredentials(sharedCredentialsId.longValue());
            BambooValidationUtils.validate((credentialsData != null ? 1 : 0) != 0, () -> this.i18nResolver.getText("repository.bitbucket.sharedCredentials.id.error.notFound"));
            UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentialsData);
            username = passwordCredentials.getUsername();
            password = StringUtils.isNotBlank((CharSequence)passwordCredentials.getPassword()) ? passwordCredentials.getPassword() : null;
        } else {
            username = this.getUsernameFromRequestOrRepository(request, existingRepository);
            password = this.getPasswordFromRequestOrRepository(request, existingRepository);
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            if (username == null) {
                errorCollection.addError("repository.bitbucket.username", this.i18nResolver.getText("repository.bitbucket.username.error.empty"));
            }
            if (password == null) {
                errorCollection.addError("repository.bitbucket.temporary.password", this.i18nResolver.getText("repository.bitbucket.password.error.empty"));
            }
            BambooValidationUtils.checkErrors((ErrorCollection)errorCollection);
        }
        return new BitbucketAccessCredentials(username, password);
    }

    @NotNull
    private Response executeCall(@NotNull BambooCallables.Throwing1<Response, WebValidationException> restCall) {
        try {
            return (Response)restCall.call();
        }
        catch (WebValidationException e) {
            RestErrorCollection restErrorCollection = new RestErrorCollection(e.getErrorCollection());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)restErrorCollection).build();
        }
    }

    private void logBitbucketApiException(BitbucketApiException e) {
        if (e.getRestCallStatusCode() != 0) {
            log.warn((Object)this.i18nResolver.getText("repository.bitbucket.ajaxError.http", new Serializable[]{e.getRestCallURI(), Integer.valueOf(e.getRestCallStatusCode())}));
            if (log.isTraceEnabled()) {
                log.trace((Object)this.i18nResolver.getText("repository.bitbucket.ajaxError.restResponse"), (Throwable)e);
            }
        } else {
            log.warn((Object)this.i18nResolver.getText("repository.bitbucket.ajaxError"), (Throwable)e);
        }
    }

    private Response buildResponseFromException(BitbucketApiException e, @Nullable String e404Message) {
        RestResponse.Builder builder = RestResponse.builder();
        this.logBitbucketApiException(e);
        if (e.getRestCallStatusCode() == 404 && StringUtils.isNotBlank((CharSequence)e404Message)) {
            builder.error(e404Message);
        } else {
            builder.error(this.i18nResolver.getText("repository.bitbucket.ajaxError") + " " + (e.getRestCallStatusCode() == 401 ? this.i18nResolver.getText("repository.bitbucket.error.401") : e.getMessage()));
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)builder.build(RestResponse.class)).build();
    }

    private static class BitbucketAccessCredentials {
        private final String username;
        private final String password;

        private BitbucketAccessCredentials(@NotNull String username, @Nullable String password) {
            this.username = username;
            this.password = password;
        }

        @NotNull
        public String getUsername() {
            return this.username;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }
    }
}

