/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.rest.entity;

import com.google.common.collect.Iterables;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="page")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BitbucketPageEntity<T> {
    @XmlElement(name="size")
    private final int size;
    @XmlElement(name="limit")
    private final int limit;
    @XmlElement(name="lastPage")
    private final boolean lastPage;
    @XmlElement(name="start")
    private final int start;
    @XmlElement(name="nextPageStart")
    @Nullable
    private final Integer nextPageStart;
    @XmlElement(name="values")
    private Iterable<T> values;

    public BitbucketPageEntity(int size, int limit, boolean lastPage, int start, @Nullable Integer nextPageStart, Iterable<T> values) {
        this.size = size;
        this.limit = limit;
        this.lastPage = lastPage;
        this.values = values;
        this.start = start;
        this.nextPageStart = nextPageStart;
    }

    public static <T> BitbucketPageEntity<T> singlePage(Iterable<T> values) {
        int size = Iterables.size(values);
        return new BitbucketPageEntity<T>(size, size, true, 0, null, values);
    }

    public int getSize() {
        return this.size;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    public Iterable<T> getValues() {
        return this.values;
    }

    public void setValues(Iterable<T> values) {
        this.values = values;
    }

    public int getStart() {
        return this.start;
    }

    @Nullable
    public Integer getNextPageStart() {
        return this.nextPageStart;
    }
}

