/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.impl;

import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAuthenticationType;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketSshCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryHelperService;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryType;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.plugins.hg.AuthenticationType;
import com.atlassian.bamboo.plugins.hg.configuration.CredentialsSource;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BitbucketRepositoryHelperServiceImpl
implements BitbucketRepositoryHelperService {
    @VisibleForTesting
    static final Map<BitbucketAuthenticationType, GitAuthenticationType> GIT_AUTHENTICATION_TYPE_MAP = ImmutableMap.of((Object)((Object)BitbucketAuthenticationType.NONE), (Object)GitAuthenticationType.NONE, (Object)((Object)BitbucketAuthenticationType.PASSWORD), (Object)GitAuthenticationType.PASSWORD, (Object)((Object)BitbucketAuthenticationType.SSH_KEYPAIR), (Object)GitAuthenticationType.SSH_KEYPAIR);
    @VisibleForTesting
    static final Map<BitbucketAuthenticationType, AuthenticationType> HG_AUTHENTICATION_TYPE_MAP = ImmutableMap.of((Object)((Object)BitbucketAuthenticationType.NONE), (Object)AuthenticationType.BYPASS, (Object)((Object)BitbucketAuthenticationType.PASSWORD), (Object)AuthenticationType.PASSWORD, (Object)((Object)BitbucketAuthenticationType.SSH_KEYPAIR), (Object)AuthenticationType.SSH_PROXY);
    @VisibleForTesting
    static final Map<BitbucketPasswordCredentialsSource, GitPasswordCredentialsSource> GIT_PASSWORD_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketPasswordCredentialsSource.CUSTOM), (Object)GitPasswordCredentialsSource.CUSTOM, (Object)((Object)BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS), (Object)GitPasswordCredentialsSource.SHARED_CREDENTIALS);
    @VisibleForTesting
    static final Map<BitbucketPasswordCredentialsSource, CredentialsSource> HG_PASSWORD_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketPasswordCredentialsSource.CUSTOM), (Object)CredentialsSource.CUSTOM, (Object)((Object)BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS), (Object)CredentialsSource.SHARED_CREDENTIALS);
    @VisibleForTesting
    static final Map<BitbucketSshCredentialsSource, GitSshCredentialsSource> GIT_SSH_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketSshCredentialsSource.CUSTOM), (Object)GitSshCredentialsSource.CUSTOM, (Object)((Object)BitbucketSshCredentialsSource.SHARED_CREDENTIALS), (Object)GitSshCredentialsSource.SHARED_CREDENTIALS);
    @VisibleForTesting
    static final Map<BitbucketSshCredentialsSource, CredentialsSource> HG_SSH_CREDENTIALS_SOURCE_MAP = ImmutableMap.of((Object)((Object)BitbucketSshCredentialsSource.CUSTOM), (Object)CredentialsSource.CUSTOM, (Object)((Object)BitbucketSshCredentialsSource.SHARED_CREDENTIALS), (Object)CredentialsSource.SHARED_CREDENTIALS);

    @Override
    public void populateFromConfig(@NotNull Repository repository, @NotNull HierarchicalConfiguration config) {
        XMLConfiguration newConfig = ConfigUtils.newConfiguration();
        switch (this.getRepositoryType(repository)) {
            case GIT: {
                this.populateGitConfigWithAuthenticationSettings((HierarchicalConfiguration)newConfig, config);
                this.populateGitConfigWithRepositoryDetails((HierarchicalConfiguration)newConfig, config);
                if (config.containsKey("repository.bitbucket.commandTimeout")) {
                    newConfig.setProperty("repository.git.commandTimeout", (Object)config.getInt("repository.bitbucket.commandTimeout"));
                }
                if (config.containsKey("repository.bitbucket.verbose.logs")) {
                    newConfig.setProperty("repository.git.verbose.logs", (Object)config.getBoolean("repository.bitbucket.verbose.logs"));
                }
                if (config.containsKey("repository.bitbucket.fetch.whole.repository")) {
                    newConfig.setProperty("repository.git.fetch.whole.repository", (Object)config.getBoolean("repository.bitbucket.fetch.whole.repository"));
                }
                newConfig.setProperty("repository.git.useShallowClones", (Object)config.getBoolean("repository.bitbucket.git.useShallowClones", false));
                newConfig.setProperty("repository.git.lfs", (Object)config.getBoolean("repository.bitbucket.git.lfs", false));
                newConfig.setProperty("repository.git.useSubmodules", (Object)config.getBoolean("repository.bitbucket.git.useSubmodules"));
                newConfig.setProperty("repository.git.useRemoteAgentCache", (Object)config.getBoolean("repository.bitbucket.git.useRemoteAgentCache"));
                break;
            }
            case HG: {
                this.populateHgConfigWithAuthenticationSettings((HierarchicalConfiguration)newConfig, config);
                this.populateHgConfigWithRepositoryDetails((HierarchicalConfiguration)newConfig, config);
                if (config.containsKey("repository.bitbucket.commandTimeout")) {
                    newConfig.setProperty("repository.hg.commandTimeout", (Object)config.getInt("repository.bitbucket.commandTimeout"));
                }
                if (!config.containsKey("repository.bitbucket.verbose.logs")) break;
                newConfig.setProperty("repository.hg.verbose.logs", (Object)config.getBoolean("repository.bitbucket.verbose.logs"));
            }
        }
        repository.populateFromConfig((HierarchicalConfiguration)newConfig);
    }

    private void populateGitConfigWithAuthenticationSettings(HierarchicalConfiguration newConfig, HierarchicalConfiguration config) {
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(config.getString("repository.bitbucket.authenticationType"));
        newConfig.setProperty("repository.git.authenticationType", (Object)GIT_AUTHENTICATION_TYPE_MAP.get((Object)authenticationType).name());
        if (authenticationType == BitbucketAuthenticationType.PASSWORD) {
            BitbucketAccessLevel accessLevel = BitbucketAccessLevel.valueOf(config.getString("repository.bitbucket.accessLevel"));
            String usernameField = accessLevel == BitbucketAccessLevel.PUBLIC ? "repository.bitbucket.owner" : "repository.bitbucket.username";
            BitbucketPasswordCredentialsSource credentialsSource = BitbucketPasswordCredentialsSource.valueOf(config.getString("repository.bitbucket.passwordCredentialsSource"));
            newConfig.setProperty("repository.git.passwordCredentialsSource", (Object)GIT_PASSWORD_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                newConfig.setProperty("repository.git.passwordSharedCredentials", (Object)config.getLong("repository.bitbucket.passwordSharedCredentials.id"));
            } else {
                newConfig.setProperty("repository.git.username", (Object)config.getString(usernameField));
                newConfig.setProperty("repository.git.password", (Object)config.getString("repository.bitbucket.password"));
            }
        } else if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            BitbucketSshCredentialsSource credentialsSource = BitbucketSshCredentialsSource.valueOf(config.getString("repository.bitbucket.sshCredentialsSource"));
            newConfig.setProperty("repository.git.sshCredentialsSource", (Object)GIT_SSH_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                newConfig.setProperty("repository.git.sharedCredentials", (Object)config.getLong("repository.bitbucket.sshSharedCredentials.id"));
            } else if (credentialsSource == BitbucketSshCredentialsSource.CUSTOM) {
                newConfig.setProperty("repository.git.ssh.key", (Object)config.getString("repository.bitbucket.sshKey"));
                newConfig.setProperty("repository.git.ssh.passphrase", (Object)config.getString("repository.bitbucket.sshPassphrase"));
            }
        }
    }

    private void populateGitConfigWithRepositoryDetails(HierarchicalConfiguration newConfig, HierarchicalConfiguration config) {
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(config.getString("repository.bitbucket.authenticationType"));
        newConfig.setProperty("repository.git.repositoryUrl", (Object)this.getRepositoryCloneUrl(BitbucketRepositoryType.GIT, authenticationType, StringUtils.defaultString((String)config.getString("repository.bitbucket.repository")).trim()));
        newConfig.setProperty("repository.git.branch", (Object)config.getString("repository.bitbucket.branch"));
    }

    private void populateHgConfigWithAuthenticationSettings(HierarchicalConfiguration newConfig, HierarchicalConfiguration config) {
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(config.getString("repository.bitbucket.authenticationType"));
        newConfig.setProperty("repository.hg.authentication", (Object)HG_AUTHENTICATION_TYPE_MAP.get((Object)authenticationType).name());
        if (authenticationType == BitbucketAuthenticationType.PASSWORD) {
            BitbucketAccessLevel accessLevel = BitbucketAccessLevel.valueOf(config.getString("repository.bitbucket.accessLevel"));
            String usernameField = accessLevel == BitbucketAccessLevel.PUBLIC ? "repository.bitbucket.owner" : "repository.bitbucket.username";
            BitbucketPasswordCredentialsSource credentialsSource = BitbucketPasswordCredentialsSource.valueOf(config.getString("repository.bitbucket.passwordCredentialsSource"));
            newConfig.setProperty("repository.hg.password.source", (Object)HG_PASSWORD_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                newConfig.setProperty("repository.hg.password.sharedCredentials", (Object)config.getLong("repository.bitbucket.passwordSharedCredentials.id"));
            } else {
                newConfig.setProperty("repository.hg.password.username", (Object)config.getString(usernameField));
                newConfig.setProperty("repository.hg.password.password", (Object)config.getString("repository.bitbucket.password"));
            }
        } else if (authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            BitbucketSshCredentialsSource credentialsSource = BitbucketSshCredentialsSource.valueOf(config.getString("repository.bitbucket.sshCredentialsSource"));
            newConfig.setProperty("repository.hg.ssh_proxy.source", (Object)HG_SSH_CREDENTIALS_SOURCE_MAP.get((Object)credentialsSource).name());
            if (credentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                newConfig.setProperty("repository.hg.ssh_proxy.sharedCredentials", (Object)config.getLong("repository.bitbucket.sshSharedCredentials.id"));
            } else if (credentialsSource == BitbucketSshCredentialsSource.CUSTOM) {
                newConfig.setProperty("repository.hg.ssh_proxy.privateKey", (Object)config.getString("repository.bitbucket.sshKey"));
                newConfig.setProperty("repository.hg.ssh_proxy.passphrase", (Object)config.getString("repository.bitbucket.sshPassphrase"));
            }
        }
    }

    private void populateHgConfigWithRepositoryDetails(HierarchicalConfiguration newConfig, HierarchicalConfiguration config) {
        BitbucketAuthenticationType authenticationType = BitbucketAuthenticationType.valueOf(config.getString("repository.bitbucket.authenticationType"));
        newConfig.setProperty("repository.hg.repositoryUrl", (Object)this.getRepositoryCloneUrl(BitbucketRepositoryType.HG, authenticationType, StringUtils.defaultString((String)config.getString("repository.bitbucket.repository")).trim()));
        newConfig.setProperty("repository.hg.branch", (Object)config.getString("repository.bitbucket.branch"));
    }

    @NotNull
    private String getRepositoryCloneUrl(@NotNull BitbucketRepositoryType repositoryType, @NotNull BitbucketAuthenticationType authenticationType, @NotNull String repositorySlug) {
        return authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR ? this.getRepositorySshCloneUrl(repositoryType, repositorySlug) : this.getRepositoryHttpsCloneUrl(repositorySlug);
    }

    @NotNull
    private String getRepositorySshCloneUrl(@NotNull BitbucketRepositoryType repositoryType, @NotNull String repositorySlug) {
        try {
            URI bitbucketUri = new URI(BitbucketProperty.BITBUCKET_BASE_URL);
            return bitbucketUri.getPort() > -1 ? String.format("ssh://%s@%s:%d/%s", repositoryType.getType(), bitbucketUri.getHost(), bitbucketUri.getPort(), repositorySlug) : String.format("ssh://%s@%s/%s", repositoryType.getType(), bitbucketUri.getHost(), repositorySlug);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid Bitbucket Cloud url: " + BitbucketProperty.BITBUCKET_BASE_URL, e);
        }
    }

    @NotNull
    private String getRepositoryHttpsCloneUrl(@NotNull String repositorySlug) {
        return BitbucketProperty.BITBUCKET_BASE_URL + repositorySlug;
    }

    @NotNull
    private BitbucketRepositoryType getRepositoryType(@NotNull Repository repository) {
        String repositoryClassName = repository.getClass().getSimpleName();
        if (repositoryClassName.equals("GitRepository")) {
            return BitbucketRepositoryType.GIT;
        }
        if (repositoryClassName.equals("HgRepository")) {
            return BitbucketRepositoryType.HG;
        }
        throw new IllegalArgumentException(String.format("Not allowed repository class %s", repositoryClassName));
    }
}

