/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.impl;

import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiException;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiService;
import com.atlassian.bamboo.plugins.bitbucket.api.rest.entity.BitbucketResourceEntity;
import com.atlassian.bamboo.plugins.bitbucket.api.rest.entity.node.BitbucketNodeEntity;
import com.atlassian.bamboo.plugins.bitbucket.rest.entity.BitbucketPageEntity;
import com.atlassian.bamboo.plugins.bitbucket.rest.entity.buildstatus.RestBuildStatus;
import com.atlassian.bamboo.plugins.bitbucket.v2.configurator.BitbucketCloudConfigurationConstants;
import com.atlassian.bamboo.rest.utils.Get;
import com.atlassian.bamboo.rest.utils.RESTCall;
import com.atlassian.bamboo.utils.EscapeChars;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import io.atlassian.util.concurrent.Lazy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;

public class BitbucketApiServiceImpl
implements BitbucketApiService,
DisposableBean {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(BitbucketApiServiceImpl.class);
    private static final String NEXT_PAGE_URL_KEY = "next";
    private final UriBuilder BUILD_STATUS_RESOURCE_URI_BUILDER = UriBuilder.fromUri((String)BitbucketProperty.getBitbucketApiV2BaseUrl()).path("/repositories/{owner}/{repo_slug}/commit/{revision}/statuses/build");
    private final Supplier<Client> bitbucketClientSupplier = Lazy.supplier(() -> {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        clientConfig.getProperties().put("com.sun.jersey.api.json.POJOMappingFeature", true);
        return Client.create((ClientConfig)clientConfig);
    });

    public void destroy() {
        this.bitbucketClientSupplier.get().destroy();
    }

    private String getFieldsParam(@NotNull String prefix) {
        return String.format("fields=%s.name,%s.is_private,%s.slug,%s.owner,%s.scm,%s.full_name,next", prefix, prefix, prefix, prefix, prefix, prefix);
    }

    @Override
    @NotNull
    public BitbucketPageEntity<BitbucketResourceEntity> findPublicRepositories(@NotNull String username, @Nullable String queryString, int start, int limit) throws BitbucketApiException {
        String url = this.getPublicRepositoriesEndpointUrl(username, queryString, start, limit);
        return this.getPageFromResource(url, username, null, start, limit, BitbucketResourceEntity::from);
    }

    @NotNull
    private String getPublicRepositoriesEndpointUrl(@NotNull String username, @Nullable String queryString, int start, int limit) {
        String url = BitbucketProperty.getBitbucketApiBaseUrl() + String.format("repositories/%s?pagelen=%d&%s&sort=full_name", username, limit, this.getFieldsParam("values"));
        if (start != 0) {
            url = url + "&page=" + (start / limit + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            url = url + "&q=slug+%7E+%22" + EscapeChars.forUrl((String)queryString.trim()) + "%22";
        }
        return url;
    }

    @Override
    @NotNull
    public List<BitbucketResourceEntity> getPublicRepositories(@NotNull String username, @Nullable String queryString) throws BitbucketApiException {
        String url = this.getPublicRepositoriesEndpointUrl(username, queryString, 0, 100);
        return this.getResultsFromPaginatedResource(url, username, null, BitbucketResourceEntity::from);
    }

    @Override
    @NotNull
    public List<BitbucketResourceEntity> getPublicRepositories(@NotNull String username) throws BitbucketApiException {
        return this.getPublicRepositories(username, null);
    }

    @Override
    @NotNull
    public BitbucketPageEntity<BitbucketResourceEntity> findRepositories(@NotNull String username, @NotNull String password, @Nullable String queryString, int start, int limit) throws BitbucketApiException {
        String url = this.getRepositoriesEndpointUrl(queryString, start, limit);
        return this.getPageFromResource(url, username, password, start, limit, BitbucketResourceEntity::fromPermissionEntry);
    }

    @NotNull
    private String getRepositoriesEndpointUrl(@Nullable String queryString, int start, int limit) {
        String url = BitbucketProperty.getBitbucketApiBaseUrl() + String.format("user/permissions/repositories?pagelen=%d&%s&sort=repository.full_name", limit, this.getFieldsParam("values.repository"));
        if (start != 0) {
            url = url + "&page=" + (start / limit + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            url = url + "&q=repository.full_name+%7E+%22" + EscapeChars.forUrl((String)queryString.trim()) + "%22";
        }
        return url;
    }

    @Override
    @NotNull
    public List<BitbucketResourceEntity> getRepositories(@NotNull String username, @NotNull String password) throws BitbucketApiException {
        return this.getRepositories(username, password, null);
    }

    @Override
    @NotNull
    public List<BitbucketResourceEntity> getRepositories(@NotNull String username, @NotNull String password, @Nullable String queryString) throws BitbucketApiException {
        String url = this.getRepositoriesEndpointUrl(queryString, 0, 100);
        return this.getResultsFromPaginatedResource(url, username, password, BitbucketResourceEntity::fromPermissionEntry);
    }

    @Override
    @NotNull
    public BitbucketPageEntity<BitbucketNodeEntity> findBranches(@NotNull String owner, @NotNull String slug, @NotNull String username, @Nullable String password, @Nullable String queryString, int start, int limit) throws BitbucketApiException {
        String url = BitbucketProperty.getBitbucketApiV2BaseUrl() + String.format("/repositories/%s/%s/refs/branches?pagelen=100&fields=values.name,next&sort=name", owner, slug);
        if (start != 0) {
            url = url + "&page=" + (start / limit + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            url = url + "&q=name+%7E+%22" + EscapeChars.forUrl((String)queryString.trim()) + "%22";
        }
        return this.getPageFromResource(url, username, password, start, limit, BitbucketNodeEntity::from);
    }

    @Override
    @NotNull
    public List<BitbucketNodeEntity> getBranches(@NotNull String owner, @NotNull String slug, @NotNull String username, @Nullable String password) throws BitbucketApiException {
        String url = BitbucketProperty.getBitbucketApiV2BaseUrl() + String.format("/repositories/%s/%s/refs/branches?pagelen=100&fields=values.name,next", owner, slug);
        return this.getResultsFromPaginatedResource(url, username, password, BitbucketNodeEntity::from);
    }

    @Override
    @NotNull
    public BitbucketNodeEntity getBranch(@NotNull String owner, @NotNull String slug, @NotNull String branch, String username, String password) throws BitbucketApiException {
        JSONObject response = this.getJSONResponseFromUrl(String.format("%s/repositories/%s/%s/refs/branches/%s", BitbucketProperty.getBitbucketApiV2BaseUrl(), owner, slug, branch), StringUtils.isNotBlank((CharSequence)username) ? username : owner, password);
        return BitbucketNodeEntity.from(response);
    }

    @Override
    @NotNull
    public BitbucketResourceEntity getRepository(@NotNull String owner, @NotNull String slug, @Nullable String username, @Nullable String password) throws BitbucketApiException {
        JSONObject response = this.getRepositoryJson(owner, slug, username, password);
        return BitbucketResourceEntity.from(response);
    }

    @Override
    @NotNull
    public BitbucketNodeEntity getDefaultBranch(@NotNull String owner, @NotNull String slug, @Nullable String username, @Nullable String password) throws BitbucketApiException {
        JSONObject response = this.getRepositoryJson(owner, slug, username, password);
        return BitbucketNodeEntity.mainBranchOf(response);
    }

    @NotNull
    private JSONObject getRepositoryJson(@NotNull String owner, @NotNull String slug, @Nullable String username, @Nullable String password) throws BitbucketApiException {
        return this.getJSONResponseFromUrl(String.format("%s/repositories/%s/%s", BitbucketProperty.getBitbucketApiV2BaseUrl(), owner, slug), StringUtils.isNotBlank((CharSequence)username) ? username : owner, password);
    }

    private <R> BitbucketPageEntity<R> getPageFromResource(@NotNull String initialUrl, @Nullable String username, @Nullable String password, int start, int limit, @NotNull Function<JSONObject, R> converter) throws BitbucketApiException {
        boolean hasMorePages;
        ArrayList<R> result = new ArrayList<R>();
        JSONObject response = this.getJSONResponseFromUrl(initialUrl, username, password);
        try {
            JSONArray branchesJsonArray = response.getJSONArray("values");
            for (int i = 0; i < branchesJsonArray.length(); ++i) {
                R converted = converter.apply(branchesJsonArray.getJSONObject(i));
                if (converted == null) continue;
                result.add(converted);
            }
            hasMorePages = response.has(NEXT_PAGE_URL_KEY);
        }
        catch (JSONException e) {
            throw new BitbucketApiException(e);
        }
        return new BitbucketPageEntity(result.size(), limit, !hasMorePages, start, !hasMorePages ? null : Integer.valueOf(start + limit), result);
    }

    private <R> List<R> getResultsFromPaginatedResource(@NotNull String initialUrl, @Nullable String username, @Nullable String password, @NotNull Function<JSONObject, R> converter) throws BitbucketApiException {
        boolean hasMorePages;
        String nextUrl = initialUrl;
        ArrayList<R> result = new ArrayList<R>();
        do {
            JSONObject response = this.getJSONResponseFromUrl(nextUrl, username, password);
            try {
                JSONArray branchesJsonArray = response.getJSONArray("values");
                for (int i = 0; i < branchesJsonArray.length(); ++i) {
                    R converted = converter.apply(branchesJsonArray.getJSONObject(i));
                    if (converted == null) continue;
                    result.add(converted);
                }
                hasMorePages = response.has(NEXT_PAGE_URL_KEY);
                if (!hasMorePages) continue;
                nextUrl = response.getString(NEXT_PAGE_URL_KEY);
            }
            catch (JSONException e) {
                throw new BitbucketApiException(e);
            }
        } while (hasMorePages);
        return result;
    }

    @Override
    public void updateBuildStatus(@NotNull String owner, @NotNull String slug, @NotNull String revision, @NotNull RestBuildStatus buildStatus, @NotNull String username, @NotNull String password) throws BitbucketApiException {
        WebResource resource = this.getBitbucketClient().resource(this.BUILD_STATUS_RESOURCE_URI_BUILDER.build(new Object[]{owner, slug, revision}));
        resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        if (log.isTraceEnabled()) {
            resource.addFilter((ClientFilter)new LoggingFilter(Logger.getLogger(BitbucketApiServiceImpl.class.getName())));
        }
        try {
            ((WebResource.Builder)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post((Object)buildStatus);
        }
        catch (UniformInterfaceException e) {
            if (log.isTraceEnabled() && e.getResponse().hasEntity()) {
                log.trace((Object)("Bitbucket response status " + e.getResponse().getStatus()));
                log.trace((Object)("Bitbucket response body " + (String)e.getResponse().getEntity(String.class)));
            }
            throw new BitbucketApiException(e);
        }
    }

    private Client getBitbucketClient() {
        return this.bitbucketClientSupplier.get();
    }

    private void addAuthenticationInfo(Get call, String username, String password) {
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            call.setBasicCredentials(username, password);
        }
        call.addRequestHeader("User-Agent", BitbucketCloudConfigurationConstants.BAMBOO_USER_AGENT);
    }

    private JSONObject getJSONResponseFromUrl(@NotNull String bitbucketUrl, @Nullable String username, @Nullable String password) throws BitbucketApiException {
        Get call = new Get(bitbucketUrl);
        this.addAuthenticationInfo(call, username, password);
        try {
            call.execute();
            if (call.getStatusCode() == 200) {
                JSONObject jSONObject = new JSONObject(IOUtils.toString((InputStream)call.getResponseAsStream(), (Charset)Charset.defaultCharset()));
                return jSONObject;
            }
            try {
                throw new BitbucketApiException((RESTCall)call);
            }
            catch (JSONException | IOException e) {
                throw new BitbucketApiException(e);
            }
        }
        finally {
            call.release();
        }
    }
}

