/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.events;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.status.AbstractBuildStatusUpdater;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.chains.branches.MergeResultState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.event.ChainAbandonedEvent;
import com.atlassian.bamboo.event.ChainStartedEvent;
import com.atlassian.bamboo.event.PlanResultEvent;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketConfigUtils;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiException;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiService;
import com.atlassian.bamboo.plugins.bitbucket.rest.entity.buildstatus.RestBuildStatus;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BitbucketBuildStatusUpdater
extends AbstractBuildStatusUpdater {
    private static final Logger log = Logger.getLogger(BitbucketBuildStatusUpdater.class);
    private static final Set<String> BB_CLOUD_PLUGIN_KEYS = ImmutableSet.of((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bb", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bbCloud");
    private final BitbucketApiService bitbucketApiService;
    private final CredentialsAccessor credentialsAccessor;
    private final Supplier<UriBuilder> planResultUriBuilder;

    public BitbucketBuildStatusUpdater(@ComponentImport ApplicationProperties applicationProperties, BitbucketApiService bitbucketApiService, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport ResultsSummaryManager resultsSummaryManager, @ComponentImport CredentialsAccessor credentialsAccessor) {
        super(cachedPlanManager, resultsSummaryManager);
        this.bitbucketApiService = bitbucketApiService;
        this.planResultUriBuilder = () -> UriBuilder.fromUri((String)applicationProperties.getBaseUrl(UrlMode.CANONICAL)).path("/browse/{planResultKey}");
        this.credentialsAccessor = credentialsAccessor;
    }

    @EventListener
    public void onChainStartedEvent(@NotNull ChainStartedEvent event) {
        this.handleEvent((PlanResultEvent)event);
    }

    @EventListener
    public void onChainAbandonedEvent(@NotNull ChainAbandonedEvent event) {
        this.handleEvent((PlanResultEvent)event);
    }

    protected boolean isBuildStatusHandlingEnabled() {
        return true;
    }

    protected void send(@NotNull PlanResultEvent event, @NotNull ImmutablePlan plan, @NotNull ImmutableResultsSummary resultsSummary) {
        MergeResultSummary mergeResult;
        RestBuildStatus buildStatus = new RestBuildStatus((ResultKey)resultsSummary.getPlanResultKey(), BitbucketBuildStatusUpdater.toState(resultsSummary), plan.getName(), this.planResultUriBuilder.get(), resultsSummary.getTestResultsSummary().getTestSummaryDescription());
        Map bitbucketRepositoryMap = (Map)PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)plan).stream().collect(BambooCollectors.toMap(BambooIdProvider::getId));
        resultsSummary.getRepositoryChangesets().stream().filter(rc -> BB_CLOUD_PLUGIN_KEYS.contains(rc.getRepositoryData().getPluginKey())).map(rc -> Pair.make((Object)rc.getChangesetId(), (Object)rc.getRepositoryData().getId())).forEach(this.buildStatusUpdater(buildStatus, bitbucketRepositoryMap));
        ImmutableChainResultsSummary chainResultsSummary = (ImmutableChainResultsSummary)Narrow.to((Object)resultsSummary, ImmutableChainResultsSummary.class);
        if (chainResultsSummary != null && (mergeResult = chainResultsSummary.getMergeResult()) != null && mergeResult.getPushState() == MergeResultState.SUCCESS) {
            String mergeResultVcsKey = mergeResult.getMergeResultVcsKey();
            PlanRepositoryDefinition repositoryData = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)plan);
            if (repositoryData != null && BB_CLOUD_PLUGIN_KEYS.contains(repositoryData.getPluginKey())) {
                this.buildStatusUpdater(buildStatus, bitbucketRepositoryMap).accept((Pair<String, Long>)Pair.make((Object)mergeResultVcsKey, (Object)repositoryData.getId()));
            }
        }
    }

    private Consumer<Pair<String, Long>> buildStatusUpdater(@NotNull RestBuildStatus buildStatus, @NotNull Map<Long, VcsRepositoryData> repositoryMap) {
        return changeset -> {
            VcsRepositoryData vcsRepositoryData = (VcsRepositoryData)repositoryMap.get(changeset.getSecond());
            if (vcsRepositoryData == null) {
                log.debug((Object)String.format("Unable to locate Bitbucket repository with id %d", changeset.getSecond()));
                return;
            }
            Pair<String, String> userNameAndPassword = BitbucketConfigUtils.getUsernameAndPassword(vcsRepositoryData, this.credentialsAccessor);
            String repoUsername = (String)userNameAndPassword.getFirst();
            String repoPassword = (String)userNameAndPassword.getSecond();
            String repoRevision = (String)changeset.getFirst();
            if (StringUtils.isEmpty((CharSequence)repoUsername) || StringUtils.isEmpty((CharSequence)repoPassword)) {
                log.debug((Object)"Unable to send build status update to Bitbucket. Missing credentials.");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)repoRevision)) {
                log.debug((Object)"Unable to send build status update to Bitbucket. Missing changeset id.");
                return;
            }
            try {
                this.bitbucketApiService.updateBuildStatus(BitbucketConfigUtils.getRepositoryOwner(vcsRepositoryData), BitbucketConfigUtils.getRepositorySlug(vcsRepositoryData), repoRevision, buildStatus, repoUsername, repoPassword);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updated build status for " + BitbucketConfigUtils.getRepositorySlug(vcsRepositoryData) + " " + repoRevision + " " + buildStatus));
                }
            }
            catch (BitbucketApiException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to sent build status update to Bitbucket", (Throwable)e);
                }
                log.info((Object)("Unable to sent build status update to Bitbucket: " + Throwables.getRootCause((Throwable)e).getMessage()));
            }
        };
    }

    @NotNull
    private static RestBuildStatus.State toState(@NotNull ImmutableResultsSummary resultsSummary) {
        if (resultsSummary.isActive()) {
            return RestBuildStatus.State.INPROGRESS;
        }
        if (resultsSummary.isSuccessful()) {
            return RestBuildStatus.State.SUCCESSFUL;
        }
        return RestBuildStatus.State.FAILED;
    }
}

