/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.api.rest.entity.node;

import com.google.common.collect.Ordering;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class BitbucketNodeEntity {
    @XmlElement(name="branch")
    private String branch;

    @Nullable
    public static BitbucketNodeEntity from(@NotNull JSONObject json) {
        BitbucketNodeEntity entity = new BitbucketNodeEntity();
        entity.branch = json.optString("name");
        if ("null".equalsIgnoreCase(entity.branch)) {
            return null;
        }
        return entity;
    }

    public static BitbucketNodeEntity mainBranchOf(JSONObject json) {
        BitbucketNodeEntity entity = new BitbucketNodeEntity();
        JSONObject mainBranch = json.optJSONObject("mainbranch");
        if (mainBranch == null) {
            return null;
        }
        entity.branch = mainBranch.optString("name");
        if ("null".equalsIgnoreCase(entity.branch)) {
            return null;
        }
        return entity;
    }

    public static Ordering<BitbucketNodeEntity> orderingByBranchName() {
        return OrderingByBranchName.ORDERING;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    private static enum OrderingByBranchName implements Comparator<BitbucketNodeEntity>
    {
        INSTANCE;

        private static final Ordering<BitbucketNodeEntity> ORDERING;

        @Override
        public int compare(BitbucketNodeEntity o1, BitbucketNodeEntity o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getBranch(), (Object)o2.getBranch(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }

        static {
            ORDERING = Ordering.from((Comparator)INSTANCE);
        }
    }
}

