/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.api.rest.entity;

import com.google.common.collect.Ordering;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BitbucketResourceEntity {
    private static final Logger log = Logger.getLogger(BitbucketResourceEntity.class);
    @XmlElement
    private String scm;
    @XmlElement
    private boolean isPrivate;
    @XmlElement
    private String name;
    @XmlElement
    private String fullName;

    public static BitbucketResourceEntity from(@NotNull JSONObject json) {
        Builder builder = BitbucketResourceEntity.builder();
        try {
            builder.name = json.getString("name");
            builder.isPrivate = json.getBoolean("is_private");
            builder.scm = json.getString("scm");
            builder.fullName = json.getString("full_name");
            return builder.build();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static BitbucketResourceEntity fromPermissionEntry(JSONObject json) {
        try {
            return BitbucketResourceEntity.from(json.getJSONObject("repository"));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Ordering<BitbucketResourceEntity> orderingByRepositoryFullName() {
        return OrderingByRepositoryFullName.ORDERING;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getName() {
        return this.name;
    }

    public String getScm() {
        return this.scm;
    }

    public String getId() {
        return this.fullName;
    }

    public static class Builder {
        private String scm;
        private boolean isPrivate;
        private String name;
        private String fullName;

        public Builder scm(String scm) {
            this.scm = scm;
            return this;
        }

        public Builder isPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public BitbucketResourceEntity build() {
            BitbucketResourceEntity entity = new BitbucketResourceEntity();
            entity.scm = this.scm;
            entity.isPrivate = this.isPrivate;
            entity.name = this.name;
            entity.fullName = this.fullName;
            return entity;
        }
    }

    private static enum OrderingByRepositoryFullName implements Comparator<BitbucketResourceEntity>
    {
        INSTANCE;

        private static final Ordering<BitbucketResourceEntity> ORDERING;

        @Override
        public int compare(BitbucketResourceEntity o1, BitbucketResourceEntity o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getId(), (Object)o2.getId(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }

        static {
            ORDERING = Ordering.from((Comparator)INSTANCE);
        }
    }
}

