/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket.api;

import com.atlassian.bamboo.rest.utils.RESTCall;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class BitbucketApiException
extends Exception {
    private int restCallStatusCode;
    private URI restCallURI;

    public BitbucketApiException(String message) {
        super(message);
    }

    public BitbucketApiException(Throwable cause) {
        super(cause);
    }

    public BitbucketApiException(RESTCall restCall) {
        super("HTTP " + restCall.getStatusCode() + ' ' + new String(restCall.getResponseBody(), StandardCharsets.UTF_8));
        this.restCallStatusCode = restCall.getStatusCode();
        this.restCallURI = restCall.getURI();
    }

    public int getRestCallStatusCode() {
        return this.restCallStatusCode;
    }

    public URI getRestCallURI() {
        return this.restCallURI;
    }
}

