/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.SharedCredentialDepender;
import com.atlassian.bamboo.credentials.SshCredentialsImpl;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAuthenticationType;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketSshCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiException;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiService;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryHelperService;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketRepositoryType;
import com.atlassian.bamboo.plugins.bitbucket.api.rest.entity.node.BitbucketNodeEntity;
import com.atlassian.bamboo.plugins.bitbucket.utils.BitbucketValidationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryFacade;
import com.atlassian.bamboo.plugins.hg.HgRepository;
import com.atlassian.bamboo.plugins.hg.HgRepositoryFacade;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.BranchAwareRepository;
import com.atlassian.bamboo.repository.BranchDetectionCapableRepository;
import com.atlassian.bamboo.repository.BranchInformationProvider;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.DeploymentAwareRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.OnceOffCapableRepository;
import com.atlassian.bamboo.repository.PushCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.repository.ScmTypePublishingRepository;
import com.atlassian.bamboo.repository.TestConnectionAwareRepository;
import com.atlassian.bamboo.repository.UniqueRevisionIdRepository;
import com.atlassian.bamboo.repository.ui.EditActionAwareRepository;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.v2.build.repository.RequirementsAwareRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketRepository
extends AbstractStandaloneRepository
implements BranchInformationProvider,
BranchMergingAwareRepository,
CachingAwareRepository,
CustomSourceDirectoryAwareRepository,
CustomVariableProviderRepository,
DeploymentAwareRepository,
HgRepositoryFacade,
GitRepositoryFacade,
PushCapableRepository,
RequirementsAwareRepository,
UniqueRevisionIdRepository,
ScmTypePublishingRepository,
TestConnectionAwareRepository,
SharedCredentialDepender,
EditActionAwareRepository {
    private static final Logger log = Logger.getLogger(BitbucketRepository.class);
    public static final String REPOSITORY_BITBUCKET_ACCESS_LEVEL = "repository.bitbucket.accessLevel";
    public static final String REPOSITORY_BITBUCKET_AUTHENTICATION_TYPE = "repository.bitbucket.authenticationType";
    public static final String REPOSITORY_BITBUCKET_OWNER = "repository.bitbucket.owner";
    public static final String REPOSITORY_BITBUCKET_USERNAME = "repository.bitbucket.username";
    public static final String REPOSITORY_BITBUCKET_PASSWORD = "repository.bitbucket.password";
    public static final String REPOSITORY_BITBUCKET_PASSWORD_CREDENTIALS_SOURCE = "repository.bitbucket.passwordCredentialsSource";
    public static final String REPOSITORY_BITBUCKET_PASSWORD_SHARED_CREDENTIALS_ID = "repository.bitbucket.passwordSharedCredentials.id";
    public static final String REPOSITORY_BITBUCKET_PASSWORD_SHARED_CREDENTIALS_DELETED = "repository.bitbucket.passwordSharedCredentials.deleted";
    public static final String REPOSITORY_BITBUCKET_REPOSITORY = "repository.bitbucket.repository";
    public static final String REPOSITORY_BITBUCKET_SSH_CREDENTIALS_SOURCE = "repository.bitbucket.sshCredentialsSource";
    public static final String REPOSITORY_BITBUCKET_SSH_SHARED_CREDENTIALS_ID = "repository.bitbucket.sshSharedCredentials.id";
    public static final String REPOSITORY_BITBUCKET_SSH_SHARED_CREDENTIALS_DELETED = "repository.bitbucket.sshSharedCredentials.deleted";
    public static final String REPOSITORY_BITBUCKET_SSH_KEY = "repository.bitbucket.sshKey";
    public static final String REPOSITORY_BITBUCKET_SSH_PASSPHRASE = "repository.bitbucket.sshPassphrase";
    public static final String REPOSITORY_BITBUCKET_SCM = "repository.bitbucket.scm";
    public static final String REPOSITORY_BITBUCKET_BRANCH = "repository.bitbucket.branch";
    private static final String REPOSITORY_BITBUCKET_SHOW_ADVANCED_OPTIONS = "repository.bitbucket.showAdvancedOptions";
    public static final String REPOSITORY_BITBUCKET_COMMAND_TIMEOUT = "repository.bitbucket.commandTimeout";
    public static final String REPOSITORY_BITBUCKET_VERBOSE_LOGS = "repository.bitbucket.verbose.logs";
    public static final String REPOSITORY_BITBUCKET_FETCH_WHOLE_REPOSITORY = "repository.bitbucket.fetch.whole.repository";
    public static final String REPOSITORY_BITBUCKET_GIT_USE_SHALLOW_CLONES = "repository.bitbucket.git.useShallowClones";
    public static final String REPOSITORY_BITBUCKET_GIT_LFS = "repository.bitbucket.git.lfs";
    public static final String REPOSITORY_BITBUCKET_GIT_USE_SUBMODULES = "repository.bitbucket.git.useSubmodules";
    public static final String REPOSITORY_BITBUCKET_GIT_USE_REMOTE_AGENT_CACHE = "repository.bitbucket.git.useRemoteAgentCache";
    public static final String REPOSITORY_BITBUCKET_TEMPORARY_PASSWORD = "repository.bitbucket.temporary.password";
    public static final String REPOSITORY_BITBUCKET_PASSWORD_CHANGE = "repository.bitbucket.password.change";
    public static final String REPOSITORY_BITBUCKET_TEMPORARY_SSH_PASSPHRASE = "repository.bitbucket.temporary.sshPassphrase";
    public static final String REPOSITORY_BITBUCKET_TEMPORARY_SSH_PASSPHRASE_CHANGE = "repository.bitbucket.temporary.sshPassphraseChange";
    public static final String REPOSITORY_BITBUCKET_TEMPORARY_SSH_KEY_FROM_FILE = "repository.bitbucket.temporary.sshKeyFile";
    public static final String REPOSITORY_BITBUCKET_TEMPORARY_SSH_KEY_CHANGE = "repository.bitbucket.temporary.sshKeyChange";
    private static final String DEFAULT_HG_BRANCH = "default";
    private static final String DEFAULT_GIT_BRANCH = "master";
    private static final String GIT_CAPABILITY = "system.git.executable";
    private Repository repositoryObject;
    private BitbucketAccessLevel accessLevel;
    private BitbucketAuthenticationType authenticationType;
    private BitbucketPasswordCredentialsSource passwordCredentialsSource;
    private BitbucketSshCredentialsSource sshCredentialsSource;
    private String owner;
    private String username;
    @Nullable
    private String password;
    private String repository;
    @Nullable
    private String scm;
    @Nullable
    private String branch;
    private Duration commandTimeout;
    private boolean showAdvancedOptions;
    private boolean verboseLogs;
    private String refSpecOverride;
    private boolean gitUseShallowClones;
    private boolean gitLfs;
    private boolean gitUseSubmodules;
    private boolean gitUseRemoteAgentCache;
    @Nullable
    private Long passwordSharedCredentialsId;
    private boolean passwordSharedCredentialsDeleted;
    @Nullable
    private Long sshSharedCredentialsId;
    private boolean sshSharedCredentialsDeleted;
    private String sshKey;
    @Nullable
    private String sshPassphrase;
    private BitbucketApiService bitbucketApiService;
    private BitbucketRepositoryHelperService repositoryHelperService;
    private CapabilityContext capabilityContext;
    private I18nResolver i18nResolver;
    private RepositoryManager repositoryManager;
    private CredentialsAccessor credentialsAccessor;
    private BitbucketValidationHelper bitbucketValidationHelper;

    @NotNull
    public String getName() {
        return "Bitbucket Cloud";
    }

    public String getScm() {
        return StringUtils.lowerCase((String)this.scm);
    }

    public String getHost() {
        try {
            return new URL(BitbucketProperty.BITBUCKET_BASE_URL).getHost();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof BitbucketRepository) {
            BitbucketRepository bbRepo = (BitbucketRepository)repository;
            return !new EqualsBuilder().append((Object)this.repository, (Object)bbRepo.repository).append((Object)this.branch, (Object)bbRepo.branch).isEquals();
        }
        return true;
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_COMMAND_TIMEOUT, (Object)String.valueOf(HgRepository.DEFAULT_COMMAND_TIMEOUT.toMinutes()));
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_ACCESS_LEVEL, (Object)BitbucketAccessLevel.PRIVATE.name());
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_PASSWORD_CREDENTIALS_SOURCE, (Object)this.getDefaultPasswordCredentialsSource().name());
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_SSH_CREDENTIALS_SOURCE, (Object)this.getDefaultSshCredentialsSource().name());
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_AUTHENTICATION_TYPE, (Object)BitbucketAuthenticationType.SSH_KEYPAIR.name());
    }

    public void beforeEditPageRendering(@NotNull HierarchicalConfiguration configuration) {
        configuration.setProperty(REPOSITORY_BITBUCKET_ACCESS_LEVEL, (Object)configuration.getString(REPOSITORY_BITBUCKET_ACCESS_LEVEL, BitbucketAccessLevel.PRIVATE.name()));
        configuration.setProperty(REPOSITORY_BITBUCKET_PASSWORD_CREDENTIALS_SOURCE, (Object)configuration.getString(REPOSITORY_BITBUCKET_PASSWORD_CREDENTIALS_SOURCE, this.getDefaultPasswordCredentialsSource().name()));
        configuration.setProperty(REPOSITORY_BITBUCKET_SSH_CREDENTIALS_SOURCE, (Object)configuration.getString(REPOSITORY_BITBUCKET_SSH_CREDENTIALS_SOURCE, this.getDefaultSshCredentialsSource().name()));
        configuration.setProperty(REPOSITORY_BITBUCKET_AUTHENTICATION_TYPE, (Object)configuration.getString(REPOSITORY_BITBUCKET_AUTHENTICATION_TYPE, BitbucketAuthenticationType.SSH_KEYPAIR.name()));
    }

    public ErrorCollection beforeSave(@NotNull HierarchicalConfiguration configuration) {
        return new SimpleErrorCollection();
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        if (BitbucketAccessLevel.PUBLIC.name().equals(buildConfiguration.getString(REPOSITORY_BITBUCKET_ACCESS_LEVEL, null))) {
            buildConfiguration.setProperty(REPOSITORY_BITBUCKET_AUTHENTICATION_TYPE, (Object)BitbucketAuthenticationType.NONE.name());
        }
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_USERNAME, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_USERNAME, "").trim());
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_OWNER, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_OWNER, "").trim());
        if (buildConfiguration.getBoolean(REPOSITORY_BITBUCKET_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_BITBUCKET_PASSWORD, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_TEMPORARY_PASSWORD));
        }
        if (buildConfiguration.getBoolean(REPOSITORY_BITBUCKET_TEMPORARY_SSH_PASSPHRASE_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_BITBUCKET_SSH_PASSPHRASE, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_TEMPORARY_SSH_PASSPHRASE));
        }
        if (buildConfiguration.getBoolean(REPOSITORY_BITBUCKET_TEMPORARY_SSH_KEY_CHANGE)) {
            Object o = buildConfiguration.getProperty(REPOSITORY_BITBUCKET_TEMPORARY_SSH_KEY_FROM_FILE);
            if (o instanceof File) {
                try {
                    buildConfiguration.setProperty(REPOSITORY_BITBUCKET_SSH_KEY, (Object)FileUtils.readFileToString((File)((File)o)));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                    return;
                }
            } else {
                buildConfiguration.clearProperty(REPOSITORY_BITBUCKET_SSH_KEY);
            }
        }
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_REPOSITORY, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_REPOSITORY, "").trim());
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_SCM, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_SCM, "").trim());
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_BRANCH, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_BRANCH, "").trim());
        buildConfiguration.setProperty(REPOSITORY_BITBUCKET_COMMAND_TIMEOUT, (Object)buildConfiguration.getString(REPOSITORY_BITBUCKET_COMMAND_TIMEOUT, "").trim());
        if (StringUtils.isBlank((CharSequence)buildConfiguration.getString(REPOSITORY_BITBUCKET_BRANCH))) {
            BitbucketRepositoryType repositoryType = BitbucketRepositoryType.valueOf(((String)StringUtils.defaultIfEmpty((CharSequence)buildConfiguration.getString(REPOSITORY_BITBUCKET_SCM), (CharSequence)BitbucketRepositoryType.HG.name())).toUpperCase());
            switch (repositoryType) {
                case GIT: {
                    buildConfiguration.setProperty(REPOSITORY_BITBUCKET_BRANCH, (Object)DEFAULT_GIT_BRANCH);
                    break;
                }
                case HG: {
                    buildConfiguration.setProperty(REPOSITORY_BITBUCKET_BRANCH, (Object)DEFAULT_HG_BRANCH);
                }
            }
        }
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        Object credentialsData;
        super.populateFromConfig(config);
        this.accessLevel = BitbucketAccessLevel.valueOf(config.getString(REPOSITORY_BITBUCKET_ACCESS_LEVEL));
        this.authenticationType = BitbucketAuthenticationType.valueOf(config.getString(REPOSITORY_BITBUCKET_AUTHENTICATION_TYPE));
        if (this.accessLevel == BitbucketAccessLevel.PRIVATE || this.authenticationType == BitbucketAuthenticationType.PASSWORD) {
            this.passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf(config.getString(REPOSITORY_BITBUCKET_PASSWORD_CREDENTIALS_SOURCE));
            if (this.passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                this.passwordSharedCredentialsId = config.getLong(REPOSITORY_BITBUCKET_PASSWORD_SHARED_CREDENTIALS_ID);
                credentialsData = this.credentialsAccessor.getCredentials(this.passwordSharedCredentialsId.longValue());
                if (credentialsData != null) {
                    UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials((CredentialsData)credentialsData);
                    this.username = passwordCredentials.getUsername();
                    this.password = passwordCredentials.getPassword();
                } else {
                    this.passwordSharedCredentialsDeleted = true;
                }
            } else {
                this.username = config.getString(REPOSITORY_BITBUCKET_USERNAME);
                this.password = config.getString(REPOSITORY_BITBUCKET_PASSWORD);
            }
        } else {
            this.owner = config.getString(REPOSITORY_BITBUCKET_OWNER);
        }
        if (this.authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            this.sshCredentialsSource = BitbucketSshCredentialsSource.valueOf(config.getString(REPOSITORY_BITBUCKET_SSH_CREDENTIALS_SOURCE));
            if (this.sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                this.sshSharedCredentialsId = config.getLong(REPOSITORY_BITBUCKET_SSH_SHARED_CREDENTIALS_ID, null);
                credentialsData = Optional.ofNullable(this.sshSharedCredentialsId).map(arg_0 -> ((CredentialsAccessor)this.credentialsAccessor).getCredentials(arg_0));
                if (((Optional)credentialsData).isPresent()) {
                    SshCredentialsImpl sshCredentials = new SshCredentialsImpl((CredentialsData)((Optional)credentialsData).get());
                    this.sshKey = sshCredentials.getKey();
                    this.sshPassphrase = sshCredentials.getPassphrase();
                } else {
                    this.sshSharedCredentialsDeleted = true;
                }
            } else {
                this.sshKey = config.getString(REPOSITORY_BITBUCKET_SSH_KEY);
                this.sshPassphrase = config.getString(REPOSITORY_BITBUCKET_SSH_PASSPHRASE);
            }
        }
        this.repository = config.getString(REPOSITORY_BITBUCKET_REPOSITORY);
        this.scm = config.getString(REPOSITORY_BITBUCKET_SCM);
        this.branch = config.getString(REPOSITORY_BITBUCKET_BRANCH);
        this.showAdvancedOptions = config.getBoolean(REPOSITORY_BITBUCKET_SHOW_ADVANCED_OPTIONS, false);
        this.commandTimeout = Duration.ofMinutes(config.getLong(REPOSITORY_BITBUCKET_COMMAND_TIMEOUT, HgRepository.DEFAULT_COMMAND_TIMEOUT.toMinutes()));
        this.verboseLogs = config.getBoolean(REPOSITORY_BITBUCKET_VERBOSE_LOGS, false);
        this.refSpecOverride = config.getBoolean(REPOSITORY_BITBUCKET_FETCH_WHOLE_REPOSITORY, false) ? "refs/heads/*" : null;
        this.gitUseShallowClones = config.getBoolean(REPOSITORY_BITBUCKET_GIT_USE_SHALLOW_CLONES);
        this.gitLfs = config.getBoolean(REPOSITORY_BITBUCKET_GIT_LFS, false);
        this.gitUseSubmodules = config.getBoolean(REPOSITORY_BITBUCKET_GIT_USE_SUBMODULES, false);
        this.gitUseRemoteAgentCache = config.getBoolean(REPOSITORY_BITBUCKET_GIT_USE_REMOTE_AGENT_CACHE, false);
        BitbucketRepositoryType repositoryType = BitbucketRepositoryType.valueOf(((String)StringUtils.defaultIfEmpty((CharSequence)this.scm, (CharSequence)BitbucketRepositoryType.HG.name())).toUpperCase());
        Repository delegate = this.repositoryManager.getNewRepositoryInstance(repositoryType.getPluginKey());
        Preconditions.checkArgument((boolean)(delegate instanceof BranchDetectionCapableRepository), (Object)"Should implement BranchDetectionCapableRepository");
        Preconditions.checkArgument((boolean)(delegate instanceof BranchMergingAwareRepository), (Object)"Should implement BranchMergingAwareRepository");
        Preconditions.checkArgument((boolean)(delegate instanceof CachingAwareRepository), (Object)"Should implement CachingAwareRepository");
        Preconditions.checkArgument((boolean)(delegate instanceof PushCapableRepository), (Object)"Should implement PushCapableRepository");
        Preconditions.checkArgument((boolean)(delegate instanceof RequirementsAwareRepository), (Object)"Should implement RequirementsAwareRepository");
        Preconditions.checkArgument((boolean)(delegate instanceof OnceOffCapableRepository), (Object)"Should implement OnceOffCapableRepository");
        Preconditions.checkArgument((boolean)(delegate instanceof TestConnectionAwareRepository), (Object)"Should implement TestConnectionAwareRepository");
        this.repositoryObject = delegate;
        this.repositoryObject.init((ModuleDescriptor)this.repositoryModuleDescriptor);
        this.repositoryHelperService.populateFromConfig(this.repositoryObject, config);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_BITBUCKET_AUTHENTICATION_TYPE, (Object)this.authenticationType.name());
        configuration.setProperty(REPOSITORY_BITBUCKET_ACCESS_LEVEL, (Object)this.accessLevel.name());
        if (this.accessLevel == BitbucketAccessLevel.PRIVATE || this.authenticationType == BitbucketAuthenticationType.PASSWORD) {
            configuration.setProperty(REPOSITORY_BITBUCKET_PASSWORD_CREDENTIALS_SOURCE, (Object)this.passwordCredentialsSource.name());
            if (this.passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                configuration.setProperty(REPOSITORY_BITBUCKET_PASSWORD_SHARED_CREDENTIALS_ID, (Object)this.passwordSharedCredentialsId);
                if (this.passwordSharedCredentialsDeleted) {
                    configuration.setProperty(REPOSITORY_BITBUCKET_PASSWORD_SHARED_CREDENTIALS_DELETED, (Object)true);
                }
            } else {
                configuration.setProperty(REPOSITORY_BITBUCKET_USERNAME, (Object)this.username);
                configuration.setProperty(REPOSITORY_BITBUCKET_PASSWORD, (Object)this.password);
            }
        } else {
            configuration.setProperty(REPOSITORY_BITBUCKET_OWNER, (Object)this.owner);
        }
        if (this.authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR) {
            configuration.setProperty(REPOSITORY_BITBUCKET_SSH_CREDENTIALS_SOURCE, (Object)this.sshCredentialsSource.name());
            if (this.sshCredentialsSource == BitbucketSshCredentialsSource.SHARED_CREDENTIALS) {
                configuration.setProperty(REPOSITORY_BITBUCKET_SSH_SHARED_CREDENTIALS_ID, (Object)this.sshSharedCredentialsId);
                if (this.sshSharedCredentialsDeleted) {
                    configuration.setProperty(REPOSITORY_BITBUCKET_SSH_SHARED_CREDENTIALS_DELETED, (Object)true);
                }
            } else {
                configuration.setProperty(REPOSITORY_BITBUCKET_SSH_KEY, (Object)this.sshKey);
                configuration.setProperty(REPOSITORY_BITBUCKET_SSH_PASSPHRASE, (Object)this.sshPassphrase);
            }
        }
        configuration.setProperty(REPOSITORY_BITBUCKET_REPOSITORY, (Object)this.repository);
        configuration.setProperty(REPOSITORY_BITBUCKET_SCM, (Object)this.scm);
        configuration.setProperty(REPOSITORY_BITBUCKET_BRANCH, (Object)this.branch);
        configuration.setProperty(REPOSITORY_BITBUCKET_SHOW_ADVANCED_OPTIONS, (Object)this.showAdvancedOptions);
        configuration.setProperty(REPOSITORY_BITBUCKET_COMMAND_TIMEOUT, (Object)this.commandTimeout.toMinutes());
        configuration.setProperty(REPOSITORY_BITBUCKET_VERBOSE_LOGS, (Object)this.verboseLogs);
        configuration.setProperty(REPOSITORY_BITBUCKET_FETCH_WHOLE_REPOSITORY, (Object)(this.refSpecOverride != null ? 1 : 0));
        configuration.setProperty(REPOSITORY_BITBUCKET_GIT_USE_SHALLOW_CLONES, (Object)this.gitUseShallowClones);
        configuration.setProperty(REPOSITORY_BITBUCKET_GIT_LFS, (Object)this.gitLfs);
        configuration.setProperty(REPOSITORY_BITBUCKET_GIT_USE_SUBMODULES, (Object)this.gitUseSubmodules);
        configuration.setProperty(REPOSITORY_BITBUCKET_GIT_USE_REMOTE_AGENT_CACHE, (Object)this.gitUseRemoteAgentCache);
        return configuration;
    }

    @NotNull
    public ErrorCollection validateForConnectionTesting(@NotNull BuildConfiguration configuration) {
        return this.bitbucketValidationHelper.validateForConnectionTesting((HierarchicalConfiguration)configuration, this.preValidate(configuration));
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration configuration) {
        return this.bitbucketValidationHelper.validate((HierarchicalConfiguration)configuration, this.preValidate(configuration));
    }

    private ErrorCollection preValidate(@NotNull BuildConfiguration buildConfiguration) {
        return super.validate(buildConfiguration);
    }

    @Nullable
    public Long getPasswordSharedCredentialsId() {
        return this.passwordSharedCredentialsId;
    }

    @NotNull
    public Iterable<Long> getSharedCredentialIds() {
        ArrayList<Long> result = new ArrayList<Long>();
        if (this.passwordSharedCredentialsId != null) {
            result.add(this.passwordSharedCredentialsId);
        }
        if (this.sshSharedCredentialsId != null) {
            result.add(this.sshSharedCredentialsId);
        }
        return result;
    }

    @NotNull
    public List<NameValuePair> getPasswordCredentialsSources() {
        return Arrays.stream(BitbucketPasswordCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getPasswordCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    @NotNull
    public List<NameValuePair> getSshCredentialsSources() {
        return Arrays.stream(BitbucketSshCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getSshCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    @NotNull
    private String getPasswordCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.bitbucket.passwordCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    @NotNull
    private String getSshCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.bitbucket.sshCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    @NotNull
    private BitbucketPasswordCredentialsSource getDefaultPasswordCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials") ? BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS : BitbucketPasswordCredentialsSource.CUSTOM;
    }

    @NotNull
    private BitbucketSshCredentialsSource getDefaultSshCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials") ? BitbucketSshCredentialsSource.SHARED_CREDENTIALS : BitbucketSshCredentialsSource.CUSTOM;
    }

    @NotNull
    public List<NameValuePair> getPasswordSharedCredentials() {
        return this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials");
    }

    @NotNull
    public List<NameValuePair> getSshSharedCredentials() {
        return this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials");
    }

    @NotNull
    private List<NameValuePair> getSharedCredentials(String pluginKey) {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials(pluginKey)).map(credentials -> new NameValuePair(Long.toString(credentials.getId()), credentials.getName())).collect(Collectors.toList());
    }

    @NotNull
    public List<NameValuePair> getAccessLevels() {
        return Arrays.stream(BitbucketAccessLevel.values()).map(Enum::name).map(accessLevel -> new NameValuePair(this.getAccessLevelName((String)accessLevel), this.getAccessLevelDescription((String)accessLevel), accessLevel)).collect(Collectors.toList());
    }

    @NotNull
    private String getAccessLevelName(String accessLevel) {
        return this.i18nResolver.getText("repository.bitbucket.accessLevel." + StringUtils.lowerCase((String)accessLevel));
    }

    @NotNull
    private String getAccessLevelDescription(String accessLevel) {
        return this.i18nResolver.getText("repository.bitbucket.accessLevel." + StringUtils.lowerCase((String)accessLevel) + ".description");
    }

    @NotNull
    public List<NameValuePair> getPrivateRepositoryAuthenticationTypes() {
        return Arrays.stream(BitbucketAuthenticationType.values()).filter(authenticationType -> authenticationType != BitbucketAuthenticationType.NONE).map(Enum::name).map(name -> new NameValuePair(name, this.getAuthenticationTypeName((String)name))).collect(Collectors.toList());
    }

    private String getAuthenticationTypeName(String authenticationType) {
        return this.i18nResolver.getText("repository.bitbucket.authenticationType." + StringUtils.lowerCase((String)authenticationType));
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        return ((OnceOffCapableRepository)this.repositoryObject).collectChangesForRevision(planKey, targetRevision);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.repositoryObject.collectChangesSinceLastBuild(planKey, lastVcsRevisionKey);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws RepositoryException {
        return ((CustomSourceDirectoryAwareRepository)this.repositoryObject).retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory, int depth) throws RepositoryException {
        return ((BranchMergingAwareRepository)this.repositoryObject).retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory, depth);
    }

    @NotNull
    public ErrorCollection testConnection(long timeout, @NotNull TimeUnit unit) {
        if (this.authenticationType == BitbucketAuthenticationType.SSH_KEYPAIR && this.sshCredentialsSource == BitbucketSshCredentialsSource.CUSTOM && StringUtils.isEmpty((CharSequence)this.sshKey)) {
            return new SimpleErrorCollection(new String[]{this.i18nResolver.getText("repository.test.connection.private.key.not.received")});
        }
        return ((TestConnectionAwareRepository)this.repositoryObject).testConnection(timeout, unit);
    }

    @NotNull
    public Set<Requirement> getRequirements() {
        return ((RequirementsAwareRepository)this.repositoryObject).getRequirements();
    }

    private String extractRepositoryNameFromUrl(String repositoryUrl) {
        try {
            URL url = new URL(repositoryUrl);
            String path = url.getPath();
            return path.substring(path.indexOf("/") + 1);
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }

    private String[] checkSplitRepositoryName() {
        String[] ownerSlugPair = this.repository.split("/");
        Preconditions.checkArgument((ownerSlugPair.length == 2 ? 1 : 0) != 0, (String)"repository has an incorrect value [%s]", (Object[])new Object[]{this.repository});
        return ownerSlugPair;
    }

    public void setBitbucketApiService(BitbucketApiService bitbucketApiService) {
        this.bitbucketApiService = bitbucketApiService;
    }

    public void setRepositoryHelperService(BitbucketRepositoryHelperService repositoryHelperService) {
        this.repositoryHelperService = repositoryHelperService;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setBitbucketValidationHelper(BitbucketValidationHelper bitbucketValidationHelper) {
        this.bitbucketValidationHelper = bitbucketValidationHelper;
    }

    public CapabilityContext getCapabilityContext() {
        return this.capabilityContext;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public String getRealRepositoryUrl() {
        return BitbucketProperty.BITBUCKET_BASE_URL + this.repository;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public boolean isFetchWholeRepository() {
        return this.refSpecOverride != null;
    }

    public String getOptionDescription() {
        String capabilitiesLink = ServletActionContext.getRequest().getContextPath() + "/admin/agent/configureSharedLocalCapabilities.action";
        String gitCapability = this.capabilityContext.getCapabilityValue(GIT_CAPABILITY);
        String hgCapability = this.capabilityContext.getCapabilityValue("system.hg.executable");
        StringBuilder descriptionBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)gitCapability)) {
            descriptionBuilder.append(this.i18nResolver.getText("repository.git.executableExists", new Serializable[]{gitCapability, capabilitiesLink}));
        } else {
            descriptionBuilder.append(this.i18nResolver.getText("repository.git.noExecutable", new Serializable[]{capabilitiesLink}));
        }
        descriptionBuilder.append(" ");
        if (StringUtils.isNotBlank((CharSequence)hgCapability)) {
            descriptionBuilder.append(this.i18nResolver.getText("repository.hg.executableExists", new Serializable[]{hgCapability, capabilitiesLink}));
        } else {
            descriptionBuilder.append(this.i18nResolver.getText("repository.hg.noExecutable", new Serializable[]{capabilitiesLink}));
        }
        return descriptionBuilder.toString();
    }

    public CacheId getCacheId(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return ((CachingAwareRepository)this.repositoryObject).getCacheId(cachableOperation);
    }

    public boolean isCachingSupportedFor(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return ((CachingAwareRepository)this.repositoryObject).isCachingSupportedFor(cachableOperation);
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@Nullable String context) throws RepositoryException {
        String[] repositoryOwnerSlug = this.checkSplitRepositoryName();
        String username = this.substituteString(this.getAccessLevel() == BitbucketAccessLevel.PRIVATE ? this.username : this.owner);
        try {
            return this.bitbucketApiService.getBranches(repositoryOwnerSlug[0], repositoryOwnerSlug[1], username, this.password).stream().map(BitbucketNodeEntity::getBranch).map(VcsBranchImpl::new).collect(Collectors.toList());
        }
        catch (BitbucketApiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Nullable
    public String getOwner() {
        return this.owner;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public BitbucketAccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public BitbucketAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public BitbucketPasswordCredentialsSource getPasswordCredentialsSource() {
        return this.passwordCredentialsSource;
    }

    public BitbucketSshCredentialsSource getSshCredentialsSource() {
        return this.sshCredentialsSource;
    }

    public String getRepositoryOwner() {
        return this.checkSplitRepositoryName()[0];
    }

    public String getRepositorySlug() {
        return this.checkSplitRepositoryName()[1];
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return ((BranchAwareRepository)this.repositoryObject).getVcsBranch();
    }

    public void setVcsBranch(@NotNull VcsBranch branch) {
        ((BranchAwareRepository)this.repositoryObject).setVcsBranch(branch);
        this.branch = branch.getName();
    }

    public CommitContext getFirstCommit() throws RepositoryException {
        return ((BranchDetectionCapableRepository)this.repositoryObject).getFirstCommit();
    }

    public CommitContext getLastCommit() throws RepositoryException {
        return ((BranchDetectionCapableRepository)this.repositoryObject).getLastCommit();
    }

    public boolean mergeWorkspaceWith(@NotNull BuildContext buildContext, @NotNull File checkoutDirectory, @NotNull String targetRevision) throws RepositoryException {
        return ((BranchMergingAwareRepository)this.repositoryObject).mergeWorkspaceWith(buildContext, checkoutDirectory, targetRevision);
    }

    public boolean isMergingSupported() {
        return ((BranchMergingAwareRepository)this.repositoryObject).isMergingSupported();
    }

    public void pushRevision(@NotNull File sourceDirectory, @Nullable String vcsRevisionKey) throws RepositoryException {
        ((PushCapableRepository)this.repositoryObject).pushRevision(sourceDirectory, vcsRevisionKey);
    }

    @NotNull
    public String commit(@NotNull File sourceDirectory, @NotNull String message) throws RepositoryException {
        return ((PushCapableRepository)this.repositoryObject).commit(sourceDirectory, message);
    }

    public boolean usePollingForBranchDetection() {
        return true;
    }

    @Nullable
    public GitRepository getGitRepository() {
        return (GitRepository)Narrow.downTo((Object)this.repositoryObject, GitRepository.class);
    }

    @Nullable
    public HgRepository getHgRepository() {
        return (HgRepository)Narrow.downTo((Object)this.repositoryObject, HgRepository.class);
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        CustomVariableProviderRepository delegate = (CustomVariableProviderRepository)Narrow.downTo((Object)this.repositoryObject, CustomVariableProviderRepository.class);
        if (delegate != null) {
            return delegate.getCustomVariables();
        }
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables() {
        CustomVariableProviderRepository delegate = (CustomVariableProviderRepository)Narrow.downTo((Object)this.repositoryObject, CustomVariableProviderRepository.class);
        if (delegate != null) {
            return delegate.getPlanRepositoryVariables();
        }
        return Collections.emptyMap();
    }
}

