/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketAccessLevel;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketRepository;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BitbucketConfigUtils {
    private static final Logger log = Logger.getLogger(BitbucketConfigUtils.class);

    private BitbucketConfigUtils() {
    }

    public static BitbucketAccessLevel getAccessLevel(@NotNull VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            return ((BitbucketRepository)repositoryData.asLegacyData().getRepository()).getAccessLevel();
        }
        String accessLevelString = (String)repositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.accessLevel");
        return BitbucketAccessLevel.valueOf(accessLevelString);
    }

    public static String getUsername(@NotNull VcsRepositoryData repositoryData, @NotNull CredentialsAccessor credentialsAccessor) {
        if (repositoryData.isLegacyRepository()) {
            return ((BitbucketRepository)repositoryData.asLegacyData().getRepository()).getUsername();
        }
        if (BitbucketConfigUtils.isPrivateRepository(repositoryData)) {
            Map config = repositoryData.getVcsLocation().getConfiguration();
            BitbucketPasswordCredentialsSource passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf((String)config.get("repository.bitbucket.passwordCredentialsSource"));
            if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                String passwordSharedCredentialsId = (String)config.get("repository.bitbucket.passwordSharedCredentials.id");
                CredentialsData credentialsData = credentialsAccessor.getCredentials(Long.parseLong(passwordSharedCredentialsId));
                if (credentialsData != null) {
                    UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentialsData);
                    return passwordCredentials.getUsername();
                }
            } else {
                return (String)config.get("repository.bitbucket.username");
            }
        }
        return null;
    }

    public static String getPassword(@NotNull VcsRepositoryData repositoryData, @NotNull CredentialsAccessor credentialsAccessor) {
        if (repositoryData.isLegacyRepository()) {
            return ((BitbucketRepository)repositoryData.asLegacyData().getRepository()).getPassword();
        }
        if (BitbucketConfigUtils.isPrivateRepository(repositoryData)) {
            Map config = repositoryData.getVcsLocation().getConfiguration();
            BitbucketPasswordCredentialsSource passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf((String)config.get("repository.bitbucket.passwordCredentialsSource"));
            if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                String passwordSharedCredentialsId = (String)config.get("repository.bitbucket.passwordSharedCredentials.id");
                CredentialsData credentialsData = credentialsAccessor.getCredentials(Long.parseLong(passwordSharedCredentialsId));
                if (credentialsData != null) {
                    UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentialsData);
                    return passwordCredentials.getPassword();
                }
            } else {
                return (String)config.get("repository.bitbucket.password");
            }
        }
        return null;
    }

    public static Pair<String, String> getUsernameAndPassword(@NotNull VcsRepositoryData repositoryData, @NotNull CredentialsAccessor credentialsAccessor) {
        if (repositoryData.isLegacyRepository()) {
            BitbucketRepository bitbucketRepository = (BitbucketRepository)repositoryData.asLegacyData().getRepository();
            return Pair.make((Object)bitbucketRepository.getUsername(), (Object)bitbucketRepository.getPassword());
        }
        if (BitbucketConfigUtils.isPrivateRepository(repositoryData)) {
            Map config = repositoryData.getVcsLocation().getConfiguration();
            BitbucketPasswordCredentialsSource passwordCredentialsSource = BitbucketPasswordCredentialsSource.valueOf((String)config.get("repository.bitbucket.passwordCredentialsSource"));
            if (passwordCredentialsSource == BitbucketPasswordCredentialsSource.SHARED_CREDENTIALS) {
                String passwordSharedCredentialsId = (String)config.get("repository.bitbucket.passwordSharedCredentials.id");
                CredentialsData credentialsData = credentialsAccessor.getCredentials(Long.parseLong(passwordSharedCredentialsId));
                if (credentialsData != null) {
                    UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentialsData);
                    return Pair.make((Object)passwordCredentials.getUsername(), (Object)passwordCredentials.getPassword());
                }
            } else {
                return Pair.make(config.get("repository.bitbucket.username"), config.get("repository.bitbucket.password"));
            }
        }
        return Pair.make(null, null);
    }

    private static boolean isPrivateRepository(@NotNull VcsRepositoryData repositoryData) {
        Map config = repositoryData.getVcsLocation().getConfiguration();
        return ((String)config.get("repository.bitbucket.accessLevel")).equals(BitbucketAccessLevel.PRIVATE.name());
    }

    public static String getOwner(@NotNull VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            return ((BitbucketRepository)repositoryData.asLegacyData().getRepository()).getOwner();
        }
        return (String)repositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.owner");
    }

    public static String getRepositoryOwner(@NotNull VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            return ((BitbucketRepository)repositoryData.asLegacyData().getRepository()).getRepositoryOwner();
        }
        String repository = (String)repositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.repository");
        return BitbucketConfigUtils.checkSplitRepositoryName(repository)[0];
    }

    public static String getRepositorySlug(VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            return ((BitbucketRepository)repositoryData.asLegacyData().getRepository()).getRepositorySlug();
        }
        String repository = (String)repositoryData.getVcsLocation().getConfiguration().get("repository.bitbucket.repository");
        return BitbucketConfigUtils.checkSplitRepositoryName(repository)[1];
    }

    public static String[] checkSplitRepositoryName(String repository) {
        String[] ownerSlugPair = repository.split("/");
        Preconditions.checkArgument((ownerSlugPair.length == 2 ? 1 : 0) != 0, (String)"repository has an incorrect value [%s]", (Object[])new Object[]{repository});
        return ownerSlugPair;
    }

    public static BitbucketPasswordCredentialsSource getPasswordCredentialSource(VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            return ((BitbucketRepository)repositoryData.asLegacyData().getRepository()).getPasswordCredentialsSource();
        }
        Map config = repositoryData.getVcsLocation().getConfiguration();
        return BitbucketPasswordCredentialsSource.valueOf((String)config.get("repository.bitbucket.passwordCredentialsSource"));
    }
}

