/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket;

import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.BitbucketRepository;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.hg.AbstractHgWebRepositoryViewer;
import com.atlassian.bamboo.plugins.hg.BitbucketUrlProvider;
import com.atlassian.bamboo.plugins.hg.HgServeWebRepositoryViewer;
import com.atlassian.bamboo.plugins.hg.HgWebRepositoryUrlProvider;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.ModuleDescriptor;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudRepositoryViewer
extends AbstractHgWebRepositoryViewer {
    private static final Logger log = Logger.getLogger(BitbucketCloudRepositoryViewer.class);
    private ImmutableList<String> supportedRepositories;
    private static final Pattern GIT_AT_BITBUCKET_PATTERN = Pattern.compile("git@bitbucket.org:([^/]+/[^/]+)$");
    private static final Pattern GENERIC_GIT_PATTERN = Pattern.compile("[^/]+/[^/]+$");

    public BitbucketCloudRepositoryViewer() {
        super((HgWebRepositoryUrlProvider)new BitbucketUrlProvider());
    }

    public void init(@NotNull ModuleDescriptor moduleDescriptor) {
        super.init(moduleDescriptor);
        this.supportedRepositories = ImmutableList.of((Object)moduleDescriptor.getPlugin().getModuleDescriptor("bb").getCompleteKey(), (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:hg", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:git", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:mercurial");
    }

    @NotNull
    public Collection<String> getSupportedRepositories() {
        return this.supportedRepositories;
    }

    @Nullable
    protected URI getUriForRepositoryData(RepositoryData repositoryData) {
        URI uri = this.getBbUri(repositoryData);
        if (uri != null) {
            return uri;
        }
        uri = HgServeWebRepositoryViewer.getHgRepositoryUri((RepositoryData)repositoryData);
        if (uri != null) {
            return uri;
        }
        uri = this.getGitRepository(repositoryData);
        return uri;
    }

    @Nullable
    private URI getGitRepository(RepositoryData repositoryData) {
        GitRepository repository = (GitRepository)Narrow.downTo((Object)repositoryData.getRepository(), GitRepository.class);
        if (repository == null) {
            return null;
        }
        String repositoryName = BitbucketCloudRepositoryViewer.getBbRepositoryNameFromGitUrl(repository.getRepositoryUrl());
        try {
            return new URI(BitbucketProperty.BITBUCKET_BASE_URL + repositoryName);
        }
        catch (URISyntaxException e) {
            log.debug((Object)"", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static String getBbRepositoryNameFromGitUrl(String repositoryUrl) {
        String noTrailingSlash = StringUtils.removeEnd((String)repositoryUrl, (String)"/");
        String noGit = StringUtils.removeEnd((String)noTrailingSlash, (String)".git");
        Matcher matcher1 = GIT_AT_BITBUCKET_PATTERN.matcher(noGit);
        if (matcher1.find()) {
            return matcher1.group(1);
        }
        Matcher matcher = GENERIC_GIT_PATTERN.matcher(noGit);
        return matcher.find() ? matcher.group(0) : null;
    }

    @Nullable
    private URI getBbUri(RepositoryData repositoryData) {
        BitbucketRepository repository = (BitbucketRepository)((Object)Narrow.downTo((Object)repositoryData.getRepository(), BitbucketRepository.class));
        if (repository == null) {
            return null;
        }
        try {
            return new URI(repository.getRealRepositoryUrl());
        }
        catch (URISyntaxException e) {
            log.debug((Object)"", (Throwable)e);
            return null;
        }
    }
}

