/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.bitbucket;

import com.atlassian.bamboo.plugins.bitbucket.BitbucketProperty;
import com.atlassian.bamboo.plugins.bitbucket.api.BitbucketApiException;
import com.atlassian.bamboo.plugins.bitbucket.v2.configurator.BitbucketCloudConfigurationConstants;
import com.atlassian.bamboo.rest.utils.Delete;
import com.atlassian.bamboo.rest.utils.Get;
import com.atlassian.sal.api.message.I18nResolver;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketApiAccessor {
    private static final Logger log = Logger.getLogger(BitbucketApiAccessor.class);
    private String username;
    private String password;
    private I18nResolver i18nResolver;

    public BitbucketApiAccessor(String username, String password, I18nResolver i18nResolver) {
        this.username = username;
        this.password = password;
        this.i18nResolver = i18nResolver;
    }

    public static String getUuidForAnEmailOrUsername(@NotNull String email) {
        String uuid = BitbucketApiAccessor.getUuidForUserOrTeam(email, true);
        if (uuid == null) {
            uuid = BitbucketApiAccessor.getUuidForUserOrTeam(email, false);
        }
        return StringUtils.replaceChars((String)uuid, (String)"{}", null);
    }

    private static String getUuidForUserOrTeam(@NotNull String email, boolean user) {
        try {
            String resource = user ? "users/" : "teams/";
            String url = BitbucketProperty.getBitbucketApiBaseUrl() + resource + email + "/";
            JSONObject json = new JSONObject(BitbucketApiAccessor.getResponseFromUrl(url, null, null));
            return json.getString("uuid");
        }
        catch (JSONException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("IllegalArgumentException while retrieving Bitbucket uuid for `" + email + "'"), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.error((Object)("IOException while retrieving Bitbucket uuid for `" + email + "'"), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResponseFromUrl(@NotNull String url, @Nullable String username, @Nullable String password) throws IOException {
        Get call = new Get(url);
        if (username != null) {
            call.setBasicCredentials(username, password);
        }
        call.addRequestHeader("User-Agent", BitbucketCloudConfigurationConstants.BAMBOO_USER_AGENT);
        try {
            call.execute();
            String string = IOUtils.toString((InputStream)call.getResponseAsStream(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        finally {
            call.release();
        }
    }

    public List<String> getCommits(String repositorySlug, int limit) throws BitbucketApiException, JSONException {
        JSONObject json;
        String response;
        String apiUrl = BitbucketProperty.getBitbucketApiBaseUrl() + "repositories/" + this.username + "/" + repositorySlug + "/commits?pagelen=" + limit + "&fields=values.hash";
        try {
            response = this.getResponseFromUrl(apiUrl);
        }
        catch (IOException e) {
            throw new BitbucketApiException(e);
        }
        this.throwIfPlainText(response);
        try {
            json = new JSONObject(response);
        }
        catch (JSONException e) {
            throw new BitbucketApiException(this.i18nResolver.getText("repository.bitbucket.error.invalidRepositoryUrl"));
        }
        ArrayList<String> commits = new ArrayList<String>();
        JSONArray commitsJsonArray = json.getJSONArray("values");
        if (commitsJsonArray != null) {
            for (int i = 0; i < commitsJsonArray.length(); ++i) {
                commits.add(commitsJsonArray.getJSONObject(i).getString("hash"));
            }
        }
        return commits;
    }

    public List<String> getCommentIds(String repositorySlug, String commitId) throws BitbucketApiException, JSONException {
        JSONArray json;
        String response;
        String apiUrl = BitbucketProperty.getBitbucketApiBaseUrl() + "repositories/" + this.username + "/" + repositorySlug + "/commit/" + commitId + "/comments";
        try {
            response = this.getResponseFromUrl(apiUrl);
        }
        catch (IOException e) {
            throw new BitbucketApiException(e);
        }
        this.throwIfPlainText(response);
        try {
            JSONObject page = new JSONObject(response);
            json = page.getJSONArray("values");
        }
        catch (JSONException e) {
            throw new BitbucketApiException(this.i18nResolver.getText("repository.bitbucket.error.invalidRepositoryUrl"));
        }
        ArrayList<String> commitIds = new ArrayList<String>();
        for (int i = 0; i < json.length(); ++i) {
            JSONObject comment = json.getJSONObject(i);
            if (comment.getBoolean("deleted")) continue;
            commitIds.add(comment.getString("id"));
        }
        return commitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteComment(String repositorySlug, String commitId, String commentId) {
        String apiUrl = BitbucketProperty.getBitbucketApiBaseUrl() + "repositories/" + this.username + "/" + repositorySlug + "/commit/" + commitId + "/comments/" + commentId;
        Delete call = new Delete(apiUrl);
        if (this.username != null) {
            call.setBasicCredentials(this.username, this.password);
        }
        call.addRequestHeader("User-Agent", BitbucketCloudConfigurationConstants.BAMBOO_USER_AGENT);
        try {
            call.execute();
            log.debug((Object)("Delete comment call status code: \n" + call.getStatusCode()));
        }
        finally {
            call.release();
        }
    }

    private String getResponseFromUrl(String url) throws IOException {
        return BitbucketApiAccessor.getResponseFromUrl(url, this.username, this.password);
    }

    private void throwIfPlainText(String response) throws BitbucketApiException {
        if ("Not Found".equals(response) || "Forbidden".equals(response)) {
            throw new BitbucketApiException(response);
        }
    }
}

