/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials;

import com.amazonaws.auth.AWSCredentials;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.aws.credentials.Constants;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AwsCredentials
implements AWSCredentials {
    private long id;
    private final String name;
    private final String accessKey;
    private final String secretKey;

    public AwsCredentials(long id, @NotNull String name, @NotNull String accessKey, @NotNull String secretKey) {
        this.id = id;
        this.name = name;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getAccessKey() {
        return this.accessKey;
    }

    @NotNull
    public String getSecretKey() {
        return this.secretKey;
    }

    @NotNull
    public String getAWSAccessKeyId() {
        return this.accessKey;
    }

    @NotNull
    public String getAWSSecretKey() {
        return this.secretKey;
    }

    @NotNull
    public static AwsCredentials fromCredentialsData(@NotNull CredentialsData credentialsData) {
        Map credentialsConfiguration = credentialsData.getConfiguration();
        String accessKey = credentialsConfiguration.getOrDefault(Constants.CFG_ACCESS_KEY, null);
        String secretKey = credentialsConfiguration.getOrDefault(Constants.CFG_SECRET_KEY, null);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"Credentials have an empty or null accessKey");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"Credentials have an empty or null secretKey");
        return new AwsCredentials(credentialsData.getId(), credentialsData.getName(), accessKey, secretKey);
    }
}

