/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.codedeploy;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum DeploymentStatus {
    SUCCEEDED(com.amazonaws.services.codedeploy.model.DeploymentStatus.Succeeded.toString()),
    FAILED(com.amazonaws.services.codedeploy.model.DeploymentStatus.Failed.toString()),
    STOPPED(com.amazonaws.services.codedeploy.model.DeploymentStatus.Stopped.toString()),
    CREATED(com.amazonaws.services.codedeploy.model.DeploymentStatus.Created.toString()),
    QUEUED(com.amazonaws.services.codedeploy.model.DeploymentStatus.Queued.toString()),
    INPROGRESS(com.amazonaws.services.codedeploy.model.DeploymentStatus.InProgress.toString()),
    UNKNOWN("Unknown"),
    READY(com.amazonaws.services.codedeploy.model.DeploymentStatus.Ready.toString());

    private final String displayName;

    private DeploymentStatus(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isSuccess() {
        return this == SUCCEEDED;
    }

    public static DeploymentStatus fromDisplayName(@NotNull String displayName) {
        return DeploymentStatus.valueOf(displayName.toUpperCase());
    }

    public static List<DeploymentStatus> valuesFinalisedList() {
        return Arrays.asList(SUCCEEDED, FAILED, STOPPED);
    }
}

